/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import io.confluent.controlcenter.rest.AbstractClusterLookupProxyServlet;
import io.confluent.controlcenter.rest.RestModule;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.http.HttpHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegistryProxyServlet
extends AbstractClusterLookupProxyServlet {
    private static final Logger log = LoggerFactory.getLogger(SchemaRegistryProxyServlet.class);
    private final Random random = new Random();
    private final List<String> endpoints;
    private final String userInfo;

    @Inject
    public SchemaRegistryProxyServlet(@RestModule.SchemaRegistry List<String> schemaRegistryUrls, @RestModule.SchemaRegistry Map<String, Object> configs) {
        this.endpoints = schemaRegistryUrls;
        String authSource = (String)configs.get("basic.auth.credentials.source");
        String userInfo = (String)configs.get("basic.auth.user.info");
        if (!Strings.isNullOrEmpty((String)authSource) && "USER_INFO".equals(authSource)) {
            this.userInfo = userInfo;
        } else {
            if (!Strings.isNullOrEmpty((String)authSource)) {
                log.error("only USER_INFO is supported for Schema Registry basic.auth.credentials.source");
            }
            this.userInfo = null;
        }
    }

    protected void addProxyHeaders(HttpServletRequest clientRequest, Request proxyRequest) {
        super.addProxyHeaders(clientRequest, proxyRequest);
        if (this.userInfo != null) {
            proxyRequest.header(HttpHeader.AUTHORIZATION, null);
            proxyRequest.header(HttpHeader.AUTHORIZATION, "Basic " + Base64.getEncoder().encodeToString(this.userInfo.getBytes(StandardCharsets.UTF_8)));
        }
    }

    @Override
    public String lookupEndpoint(String cluster) {
        return this.endpoints.size() > 0 ? this.endpoints.get(this.random.nextInt(this.endpoints.size())) : null;
    }
}

