/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.base.Preconditions;
import io.confluent.controlcenter.rest.ExpiringSessionAuthentication;
import io.confluent.monitoring.common.Clock;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import joptsimple.internal.Strings;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionBasicAuthenticator
extends BasicAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(SessionBasicAuthenticator.class);
    private final Clock clock;
    private final long authSessionExpiration;

    public SessionBasicAuthenticator(Clock clock, long authSessionExpiration) {
        Preconditions.checkArgument((authSessionExpiration > 0L ? 1 : 0) != 0);
        this.clock = clock;
        this.authSessionExpiration = authSessionExpiration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpSession session = request.getSession(false);
        String credentials = request.getHeader(HttpHeader.AUTHORIZATION.asString());
        try {
            if (Strings.isNullOrEmpty((String)credentials)) {
                if (session == null) return super.validateRequest(req, res, mandatory);
                LOG.debug("no credentials found to authenticate the user agent, forcing re-authentication");
                session.removeAttribute("org.eclipse.jetty.security.UserIdentity");
                return super.validateRequest(req, res, mandatory);
            }
            ExpiringSessionAuthentication authentication = session == null ? null : (ExpiringSessionAuthentication)((Object)session.getAttribute("org.eclipse.jetty.security.UserIdentity"));
            if (authentication == null) return super.validateRequest(req, res, mandatory);
            if (authentication.isExpired(this.clock.currentTimeMillis())) {
                LOG.debug("session auth cache expired, forcing re-authentication");
                session.removeAttribute("org.eclipse.jetty.security.UserIdentity");
                return super.validateRequest(req, res, mandatory);
            }
            LOG.trace("using session cache for authentication and authorization");
            return authentication;
        }
        catch (ServerAuthException e) {
            if (session == null) throw e;
            session.invalidate();
            throw e;
        }
    }

    public UserIdentity login(String username, Object password, ServletRequest request) {
        UserIdentity user = super.login(username, password, request);
        if (user != null) {
            HttpSession session = ((HttpServletRequest)request).getSession(true);
            long expirationTime = this.clock.currentTimeMillis() + this.authSessionExpiration;
            ExpiringSessionAuthentication cached = new ExpiringSessionAuthentication(this.getAuthMethod(), user, password, expirationTime);
            session.setAttribute("org.eclipse.jetty.security.UserIdentity", (Object)cached);
        }
        return user;
    }
}

