/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import io.confluent.controlcenter.data.ScopedPermissions;
import io.confluent.controlcenter.streams.C3Streams;
import io.confluent.controlcenter.streams.KafkaStreamsManager;
import io.confluent.controlcenter.streams.RocksDBConfigurator;
import io.confluent.controlcenter.util.StreamProgressReporter;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.PlatformManagedObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.kafka.streams.TopologyDescription;
import org.apache.kafka.streams.processor.ThreadMetadata;
import org.rocksdb.HistogramData;
import org.rocksdb.HistogramType;
import org.rocksdb.Options;
import org.rocksdb.Statistics;
import org.rocksdb.TickerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/2.0/status")
@Produces(value={"application/json"})
public class StatusResource {
    private static final Logger log = LoggerFactory.getLogger(StatusResource.class);
    private static final String NEWLINE = System.lineSeparator();
    private final C3Streams.Builder builder;
    private final KafkaStreamsManager kstreams;
    private final StreamProgressReporter streamProgressReporter;
    @Context
    private ScopedPermissions scopedPermissions;

    @Inject
    public StatusResource(C3Streams.Builder builder, KafkaStreamsManager kstreams, StreamProgressReporter streamProgressReporter) {
        this.builder = builder;
        this.kstreams = kstreams;
        this.streamProgressReporter = streamProgressReporter;
    }

    @GET
    @Path(value="streams/state")
    public Object streamsState() {
        return this.kstreams.getKStreams().state();
    }

    @GET
    @Path(value="streams/topology")
    public Object streamsTopology() {
        TopologyDescription topology = this.builder.build().describe();
        StringBuilder builder = new StringBuilder();
        builder.append(topology.toString()).append(NEWLINE);
        for (ThreadMetadata metadata : this.kstreams.getKStreams().localThreadsMetadata()) {
            builder.append(metadata).append(NEWLINE);
        }
        return builder.toString();
    }

    @GET
    @Path(value="/progress_window/{type}/{clusterId}")
    public long lastWindowWithData(@PathParam(value="type") String type, @PathParam(value="clusterId") String clusterId) {
        double window = 0.0;
        if (!type.equals("monitoring")) {
            throw new NotFoundException("invalid type=" + type);
        }
        this.verifyVisibility(clusterId);
        window = this.streamProgressReporter.getMonitoringInputProgress(clusterId);
        log.info("Returning most recent window with {} data for cluster {}: {}", new Object[]{type, clusterId, window});
        return (long)window;
    }

    @GET
    @Path(value="/input_timestamp/{type}/{clusterId}")
    public long lastMonitoringInputTopicTimestamp(@PathParam(value="type") String type, @PathParam(value="clusterId") String clusterId) {
        double timestamp = 0.0;
        if (type.equals("monitoring")) {
            this.verifyVisibility(clusterId);
            timestamp = this.streamProgressReporter.getMonitoringInputProgress(clusterId);
        } else if (type.equals("metrics")) {
            this.verifyBrokerMetrics(clusterId);
            timestamp = this.streamProgressReporter.getMetricsInputProgress(clusterId);
        } else {
            throw new NotFoundException("invalid type=" + type);
        }
        log.info("Returning last timestamp consumed from the {} input topic {}: {}", new Object[]{type, clusterId, timestamp});
        return (long)timestamp;
    }

    @GET
    @Path(value="/input_timestamp/{type}")
    public long lastMonitoringInputTopicTimestamp(@PathParam(value="type") String type) {
        double timestamp = -1.0;
        switch (type) {
            case "monitoring": {
                timestamp = this.streamProgressReporter.getMonitoringInputProgress();
                break;
            }
            case "metrics": {
                timestamp = this.streamProgressReporter.getMetricsInputProgress();
                break;
            }
            default: {
                throw new NotFoundException("invalid type=" + type);
            }
        }
        log.info("Returning last timestamp consumed from the {} input topic: {}", (Object)type, (Object)timestamp);
        return (long)timestamp;
    }

    @GET
    @Path(value="/input_rate/{type}")
    public double inputRate(@PathParam(value="type") String type) {
        double rate = -1.0;
        switch (type) {
            case "monitoring": {
                rate = this.streamProgressReporter.getMonitoringInputProgressRate();
                break;
            }
            case "metrics": {
                rate = this.streamProgressReporter.getMetricsInputProgressRate();
                break;
            }
            default: {
                throw new NotFoundException("invalid type=" + type);
            }
        }
        log.info("Returning rate from the {} input topic {}", (Object)type, (Object)rate);
        return rate;
    }

    @GET
    @Path(value="/app_info")
    public Object appInfo() {
        return ImmutableMap.builder().put((Object)"metricsRate", (Object)this.inputRate("metrics")).put((Object)"monitoringRate", (Object)this.inputRate("monitoring")).put((Object)"metricsTimestamp", (Object)this.lastMonitoringInputTopicTimestamp("metrics")).put((Object)"monitoringTimestamp", (Object)this.lastMonitoringInputTopicTimestamp("monitoring")).put((Object)"status", this.streamsState()).build();
    }

    @GET
    @Path(value="java/runtime")
    public Map<String, Object> runtime() throws Exception {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        metrics.put("java.version", System.getProperty("java.version"));
        this.addObjectMetrics(ManagementFactory.getRuntimeMXBean().getObjectName(), metrics);
        return metrics;
    }

    @GET
    @Path(value="java/memory")
    public Map<String, Object> memory() throws Exception {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        metrics.put("HeapMemoryUsage", ManagementFactory.getMemoryMXBean().getHeapMemoryUsage());
        metrics.put("NonHeapMemoryUsage", ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage());
        this.addObjectListMetrics("BufferPools", ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class), metrics);
        this.addMemoryPoolMetrics(metrics);
        this.addObjectListMetrics("GarbageCollector", ManagementFactory.getGarbageCollectorMXBeans(), metrics);
        return metrics;
    }

    @GET
    @Path(value="java/threads")
    public Map<String, Object> threads() throws Exception {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        this.addObjectMetrics(ManagementFactory.getThreadMXBean().getObjectName(), metrics);
        return metrics;
    }

    @GET
    @Path(value="os")
    public Map<String, Object> os() throws Exception {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        this.addObjectMetrics(ManagementFactory.getOperatingSystemMXBean().getObjectName(), metrics);
        return metrics;
    }

    @GET
    @Path(value="streams")
    public Map<String, Object> streams() throws Exception {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName streamsBean = new ObjectName("kafka.streams:*");
        Set<ObjectName> names = beanServer.queryNames(streamsBean, null);
        for (ObjectName name : names) {
            this.addObjectMetrics(name, metrics);
        }
        return metrics;
    }

    @GET
    @Path(value="rocksdb/stats")
    public Map<String, Map<String, Map<String, Object>>> rocksDbStats() throws Exception {
        return Maps.transformValues(RocksDBConfigurator.APP_INSTANCES, (Function)new Function<Map<String, Options>, Map<String, Map<String, Object>>>(){

            public Map<String, Map<String, Object>> apply(Map<String, Options> storeOptions) {
                return Maps.transformValues(storeOptions, (Function)new Function<Options, Map<String, Object>>(){

                    public Map<String, Object> apply(Options options) {
                        Statistics stats = options.statistics();
                        LinkedHashMap storeStats = Maps.newLinkedHashMap();
                        for (TickerType tickerType : TickerType.values()) {
                            storeStats.put(tickerType.name(), stats.getTickerCount(tickerType));
                        }
                        for (TickerType tickerType : HistogramType.values()) {
                            HistogramData histogramData = stats.getHistogramData((HistogramType)tickerType);
                            storeStats.put(tickerType.name(), ImmutableMap.builder().put((Object)"average", (Object)histogramData.getAverage()).put((Object)"median", (Object)histogramData.getMedian()).put((Object)"percentile-95", (Object)histogramData.getPercentile95()).put((Object)"percentile-99", (Object)histogramData.getPercentile99()).put((Object)"standardDeviation", (Object)histogramData.getStandardDeviation()).build());
                        }
                        return storeStats;
                    }
                });
            }
        });
    }

    private void verifyVisibility(String clusterId) {
        if (!this.scopedPermissions.hasViewAccess(clusterId)) {
            throw new ForbiddenException("no access to this cluster");
        }
    }

    private void verifyBrokerMetrics(String clusterId) {
        if (!this.scopedPermissions.hasBrokerMetricsAccess(clusterId)) {
            throw new ForbiddenException("no broker-metrics access to this cluster");
        }
    }

    private <T extends PlatformManagedObject> void addObjectListMetrics(String name, List<T> beans, Map<String, Object> metrics) throws Exception {
        ArrayList<HashMap<String, Object>> metricList = new ArrayList<HashMap<String, Object>>();
        for (PlatformManagedObject bean : beans) {
            HashMap<String, Object> metric = new HashMap<String, Object>();
            this.addObjectMetrics(bean.getObjectName(), metric);
            metricList.add(metric);
        }
        metrics.put(name, metricList);
    }

    private void addObjectMetrics(ObjectName name, Map<String, Object> metrics) throws Exception {
        MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
        HashMap<String, Object> attrMap = new HashMap<String, Object>();
        MBeanInfo info = beanServer.getMBeanInfo(name);
        for (MBeanAttributeInfo attrInfo : info.getAttributes()) {
            try {
                if (attrInfo.getName().equals("ObjectName")) continue;
                attrMap.put(attrInfo.getName(), beanServer.getAttribute(name, attrInfo.getName()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        metrics.put(name.getCanonicalName(), attrMap);
    }

    private void addMemoryPoolMetrics(Map<String, Object> metrics) {
        ArrayList memPools = new ArrayList();
        for (MemoryPoolMXBean bean : ManagementFactory.getMemoryPoolMXBeans()) {
            HashMap<String, Object> metric = new HashMap<String, Object>();
            metric.put("name", bean.getName());
            metric.put("type", (Object)bean.getType());
            metric.put("usage", bean.getUsage());
            memPools.add(metric);
        }
        metrics.put("MemoryPools", memPools);
    }
}

