/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest.res;

import io.confluent.controlcenter.rest.res.OmgDeserializer;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import java.io.IOException;
import java.util.Iterator;
import javax.websocket.Session;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.errors.WakeupException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumeToSocket
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ConsumeToSocket.class);
    private final OmgDeserializer deserializer;
    private final Consumer<byte[], byte[]> consumer;
    private final Session session;
    private long maxRecords;
    private boolean done = false;

    public ConsumeToSocket(Session session, Consumer consumer, long maxRecords, SchemaRegistryClient schemaRegistryClient) {
        this.session = session;
        this.consumer = consumer;
        this.maxRecords = maxRecords;
        this.deserializer = new OmgDeserializer(schemaRegistryClient);
    }

    @Override
    public void run() {
        try {
            if (!this.done && !Thread.currentThread().isInterrupted()) {
                log.info("trace calling poll");
                ConsumerRecords records = this.consumer.poll(100L);
                Iterator iterator = records.iterator();
                while (iterator.hasNext() && this.maxRecords-- > 0L) {
                    ConsumerRecord record = (ConsumerRecord)iterator.next();
                    log.info("trace got a record {}", (Object)record);
                    this.session.getBasicRemote().sendObject(this.decodeRecord((ConsumerRecord<byte[], byte[]>)record));
                }
            }
            if (this.maxRecords <= 0L && this.session.isOpen()) {
                this.close();
            }
        }
        catch (WakeupException wakeup) {
            log.debug("waking up", (Throwable)wakeup);
        }
        catch (Throwable t) {
            log.warn("unable to consume", t);
            try {
                this.close();
            }
            catch (IOException e) {
                log.error("unable to close session", (Throwable)e);
            }
        }
    }

    ConsumerRecord<Object, Object> decodeRecord(ConsumerRecord<byte[], byte[]> record) {
        return new ConsumerRecord(record.topic(), record.partition(), record.offset(), record.timestamp(), record.timestampType(), null, record.serializedKeySize(), record.serializedValueSize(), this.deserializer.deserializeKey(record), this.deserializer.deserializeValue(record), record.headers());
    }

    public void close() throws IOException {
        log.debug("closing session");
        this.done = true;
        this.session.close();
        this.consumer.close();
    }
}

