/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.schemaregistry;

import com.google.common.base.Preconditions;
import io.confluent.controlcenter.ControlCenterRbacConfig;
import io.confluent.controlcenter.rest.RestModule;
import io.confluent.controlcenter.schemaregistry.SchemaRegistryClientSupplier;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import java.util.List;
import java.util.Map;
import joptsimple.internal.Strings;

public class SchemaRegistryClientManager
implements SchemaRegistryClientSupplier<String> {
    private List<String> schemaRegistryUrls;
    private Map<String, Object> schemaRegistryClientConfig;
    private ControlCenterRbacConfig rbacConfig;

    public SchemaRegistryClientManager(@RestModule.SchemaRegistry List<String> schemaRegistryUrls, @RestModule.SchemaRegistry Map<String, Object> schemaRegistryClientConfig, ControlCenterRbacConfig rbacConfig) {
        this.schemaRegistryUrls = schemaRegistryUrls;
        this.schemaRegistryClientConfig = schemaRegistryClientConfig;
        this.rbacConfig = rbacConfig;
    }

    @Override
    public SchemaRegistryClient getClient(String token) {
        if (this.schemaRegistryUrls.isEmpty()) {
            return null;
        }
        return new CachedSchemaRegistryClient(this.schemaRegistryUrls, 100, this.rbacConfig.isRbacEnabled() ? this.injectRbacImpersonationConfigs(this.schemaRegistryClientConfig, token) : this.schemaRegistryClientConfig);
    }

    private Map<String, Object> injectRbacImpersonationConfigs(Map<String, Object> configs, String token) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)token) ? 1 : 0) != 0);
        this.rbacConfig.putAllRbacTokenConfigs(configs, token);
        configs.put("bearer.auth.credentials.source", "MDS");
        return configs;
    }
}

