/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.serialization;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.ControlCenterConfigModule;
import io.confluent.controlcenter.serialization.SerializationModule;
import io.confluent.controlcenter.serialization.WindowStoreSerde;
import io.confluent.controlcenter.streams.StreamsConfigModule;
import io.confluent.controlcenter.streams.TopicStoreMaster;
import io.confluent.controlcenter.streams.TopicStoreModule;
import io.confluent.serializers.SerdeWithJson;
import io.confluent.serializers.UberSerde;
import java.io.PrintStream;
import java.util.Properties;
import kafka.common.MessageFormatter;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.errors.SerializationException;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UberFormatter
implements MessageFormatter {
    private static final Logger log = LoggerFactory.getLogger(UberFormatter.class);
    private ControlCenterConfig config;
    private TopicStoreMaster topicStoreMaster;
    private boolean allowErrors;
    private boolean printTopic;
    private boolean printPartition;
    private boolean printTs;
    private boolean printKey;
    private String fieldSeparator;
    private String lineSeparator;

    public UberFormatter() {
    }

    public UberFormatter(ControlCenterConfig config) {
        this.config = config;
    }

    public void init(Properties props) {
        String configFile = props.getProperty("config");
        try {
            if (this.config == null) {
                this.config = new ControlCenterConfig(configFile);
            }
            Injector injector = Guice.createInjector((Module[])new Module[]{new ControlCenterConfigModule(this.config), new StreamsConfigModule(), new SerializationModule(), new TopicStoreModule()});
            this.topicStoreMaster = (TopicStoreMaster)injector.getInstance(TopicStoreMaster.class);
        }
        catch (Exception e) {
            log.error("Init failed: ", (Throwable)e);
            throw new RuntimeException("Failed to load config", e);
        }
        this.allowErrors = this.getBoolean(props, "allow.errors", true);
        this.printTopic = this.getBoolean(props, "print.topic", true);
        this.printPartition = this.getBoolean(props, "print.partition", true);
        this.printTs = this.getBoolean(props, "print.timestamp", true);
        this.printKey = this.getBoolean(props, "print.key", true);
        this.lineSeparator = props.getProperty("line.separator", "\n");
        this.fieldSeparator = props.getProperty("field.separator", "\t");
    }

    private boolean getBoolean(Properties props, String name, boolean defaultValue) {
        if (props.containsKey(name)) {
            return Boolean.parseBoolean(props.getProperty(name).trim());
        }
        return defaultValue;
    }

    public void writeTo(ConsumerRecord<byte[], byte[]> consumerRecord, PrintStream output) {
        TopicStoreMaster.SerdePair serdes = this.topicStoreMaster.getSerdesForTopic(consumerRecord.topic());
        if (serdes == null && !this.allowErrors) {
            throw new SerializationException("No serde found for topic: " + consumerRecord.topic());
        }
        if (this.printTopic) {
            output.append(consumerRecord.topic());
            output.append(this.fieldSeparator);
        }
        if (this.printPartition) {
            output.append(Integer.toString(consumerRecord.partition()));
            output.append(this.fieldSeparator);
        }
        if (this.printTs) {
            output.append(new DateTime(consumerRecord.timestamp()).toString());
            output.append(this.fieldSeparator);
        }
        if (this.printKey) {
            output.append(this.getKeyString(consumerRecord.topic(), (byte[])consumerRecord.key(), serdes));
            output.append(this.fieldSeparator);
        }
        output.append(this.getValueString(consumerRecord.topic(), (byte[])consumerRecord.value(), serdes));
        output.append(this.lineSeparator);
    }

    private String getValueString(String topic, byte[] valueBytes, TopicStoreMaster.SerdePair serdes) {
        UberSerde serde = null;
        if (serdes != null && serdes.valueSerde != null) {
            serde = serdes.valueSerde;
        }
        return this.getString(topic, valueBytes, (SerdeWithJson)serde, "value");
    }

    private String getKeyString(String topic, byte[] keyBytes, TopicStoreMaster.SerdePair serdes) {
        WindowStoreSerde serde = null;
        if (serdes != null) {
            if (serdes.windowedSerde != null) {
                serde = serdes.windowedSerde;
            } else if (serdes.keySerde != null) {
                serde = serdes.keySerde;
            }
        }
        return this.getString(topic, keyBytes, serde, "key");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getString(String topic, byte[] bytes, SerdeWithJson serde, String errField) {
        String str = "null";
        if (bytes == null) return str;
        if (serde == null) {
            if (!this.allowErrors) throw new SerializationException("No " + errField + " serde found for topic: " + topic);
            return "ERROR: No serde found";
        }
        try {
            return serde.toJson(serde.deserialize(bytes));
        }
        catch (SerializationException e) {
            if (!this.allowErrors) throw e;
            return "ERROR: " + e.getMessage();
        }
    }

    public void close() {
    }
}

