/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import io.confluent.controlcenter.data.KafkaMetadataDao;
import io.confluent.controlcenter.rest.Credential;
import io.confluent.controlcenter.rest.TimeseriesUtils;
import io.confluent.controlcenter.streams.ContextAwareTransformer;
import io.confluent.controlcenter.streams.TopicStoreMaster;
import io.confluent.controlcenter.streams.aggregation.BufferMetricEvent;
import io.confluent.controlcenter.streams.aggregation.GroupingSets;
import io.confluent.controlcenter.streams.aggregation.MetricEvent;
import io.confluent.controlcenter.streams.aggregation.MetricHolder;
import io.confluent.controlcenter.streams.aggregation.MetricValues;
import io.confluent.controlcenter.streams.aggregation.MetricsAggregation;
import io.confluent.controlcenter.streams.internals.ReadOnlyWindowStoreFacade;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;

class TransformCompositeMetrics
extends ContextAwareTransformer<Windowed<? extends MetricEvent>, MetricValues, KeyValue<Windowed<MetricEvent>, MetricValues>> {
    private final MetricsAggregation metricsAggregation;
    private final KafkaMetadataDao kafkaMetadataDao;
    private final TopicStoreMaster.Store<ByteBuffer, MetricHolder, MetricHolder> metricsAggregateStore;
    private GroupingSets.PartitionedGroupingSets.GroupedWindowStore<MetricValues> metricsStore = null;

    @Inject
    public TransformCompositeMetrics(MetricsAggregation metricsAggregation, TopicStoreMaster.Store<ByteBuffer, MetricHolder, MetricHolder> metricsAggregateStore, KafkaMetadataDao kafkaMetadataDao) {
        this.metricsAggregation = metricsAggregation;
        this.metricsAggregateStore = metricsAggregateStore;
        this.kafkaMetadataDao = kafkaMetadataDao;
    }

    private Integer brokerCount(long window, String clusterId, String topic) {
        return this.brokerCount(window, "byTopicLeaderCount", clusterId, MetricsAggregation.CLUSTER_TOPIC, clusterId, topic);
    }

    private Integer brokerCount(long window, String clusterId) {
        return this.brokerCount(window, "timestamp", clusterId, MetricsAggregation.CLUSTER, clusterId);
    }

    private Integer brokerCount(long window, String byBrokerMetric, String clusterId, ImmutableList<String> fields, String ... values) {
        List<Integer> brokerIds = this.kafkaMetadataDao.getBrokerIdsFromCache(Credential.makeCredential(clusterId));
        if (brokerIds == null) {
            return null;
        }
        int brokerCount = 0;
        for (int id : brokerIds) {
            String[] valuesAndBroker = new String[fields.size() + 1];
            System.arraycopy(values, 0, valuesAndBroker, 0, values.length);
            valuesAndBroker[valuesAndBroker.length - 1] = Integer.toString(id);
            if (this.query(window, byBrokerMetric, (List<String>)ImmutableList.copyOf((Iterable)Iterables.concat(fields, (Iterable)ImmutableList.of((Object)"broker"))), valuesAndBroker) == null) continue;
            ++brokerCount;
        }
        return brokerCount;
    }

    private MetricValues query(long window, String metric, List<String> fields, String ... values) {
        try (WindowStoreIterator iterator = this.metricsStore.forGroupingSet(metric, fields).inRange(window, window).matching(values);){
            MetricValues metricValues = iterator.hasNext() ? (MetricValues)((KeyValue)iterator.next()).value : null;
            return metricValues;
        }
    }

    @Override
    public void init(ProcessorContext context) {
        StateStore rawStore = context.getStateStore(this.metricsAggregateStore.name);
        ReadOnlyWindowStoreFacade<BufferMetricEvent, MetricValues> metricsAggregateStore = rawStore instanceof TimestampedWindowStore ? new ReadOnlyWindowStoreFacade<BufferMetricEvent, MetricValues>((TimestampedWindowStore)rawStore) : (ReadOnlyWindowStoreFacade<BufferMetricEvent, MetricValues>)rawStore;
        this.metricsStore = this.metricsAggregation.metricsGroupStore(metricsAggregateStore);
    }

    public KeyValue<Windowed<MetricEvent>, MetricValues> transform(final Windowed<? extends MetricEvent> key, MetricValues value) {
        MetricValues result;
        MetricEvent metricEvent = (MetricEvent)key.key();
        String metricName = metricEvent.getMetricName();
        String clusterId = metricEvent.getDimension("cluster");
        switch (metricName) {
            case "ActiveControllerCount": {
                long window = key.window().start();
                String brokerId = metricEvent.getDimension("broker");
                if (brokerId == null) {
                    Integer brokerCount = this.brokerCount(window, clusterId);
                    if (brokerCount != null) {
                        double controllerCount = (double)brokerCount.intValue() * (double)value.sum() / (double)value.count();
                        result = TimeseriesUtils.singleMetricValue(controllerCount > 0.0 ? Math.max(1L, (long)controllerCount) : 0L);
                        break;
                    }
                    result = null;
                    break;
                }
                result = null;
                break;
            }
            case "UnderReplicatedPartitions": {
                long window = key.window().start();
                Integer brokerCount = this.brokerCount(window, clusterId);
                if (brokerCount != null) {
                    long underReplicatedPartitions = value.sum() * (long)brokerCount.intValue() / value.count();
                    result = TimeseriesUtils.singleMetricValue(underReplicatedPartitions);
                    break;
                }
                result = null;
                break;
            }
            case "UnderReplicated": {
                long window = key.window().start();
                String topic = metricEvent.getDimension("topic");
                if (topic != null) {
                    Integer brokerCount = this.brokerCount(window, clusterId, topic);
                    MetricValues leaderCount = this.query(window, "byTopicLeaderCount", (List<String>)MetricsAggregation.CLUSTER_TOPIC, clusterId, topic);
                    if (brokerCount != null && leaderCount != null) {
                        long onlinePartitions = leaderCount.sum() * (long)brokerCount.intValue() / leaderCount.count();
                        long underReplicatedPartitions = value.sum() * onlinePartitions / value.count();
                        result = TimeseriesUtils.singleMetricValue(underReplicatedPartitions);
                        break;
                    }
                    result = null;
                    break;
                }
                result = value;
                break;
            }
            case "InSyncReplicasCount": {
                long window = key.window().start();
                String topic = metricEvent.getDimension("topic");
                if (topic != null) {
                    Integer brokerCount = this.brokerCount(window, clusterId, topic);
                    MetricValues leaderCount = this.query(window, "byTopicLeaderCount", (List<String>)MetricsAggregation.CLUSTER_TOPIC, clusterId, topic);
                    MetricValues replicasCount = this.query(window, "ReplicasCount", (List<String>)MetricsAggregation.CLUSTER_TOPIC, clusterId, topic);
                    if (brokerCount != null && leaderCount != null && replicasCount != null) {
                        long onlinePartitions = leaderCount.sum() * (long)brokerCount.intValue() / leaderCount.count();
                        long replicas = replicasCount.sum() * onlinePartitions / replicasCount.count();
                        long inSyncReplicas = value.sum() * onlinePartitions / value.count();
                        return KeyValue.pair((Object)new Windowed((Object)new MetricEvent(){

                            @Override
                            public String getMetricName() {
                                return "OutOfSyncReplicasCount";
                            }

                            @Override
                            public String getDimension(String dimensionName) {
                                return ((MetricEvent)key.key()).getDimension(dimensionName);
                            }
                        }, key.window()), (Object)TimeseriesUtils.singleMetricValue(replicas - inSyncReplicas));
                    }
                    result = null;
                    break;
                }
                result = value;
                break;
            }
            default: {
                result = value;
            }
        }
        if (result != null) {
            Windowed<? extends MetricEvent> windowedKey = key;
            return KeyValue.pair(windowedKey, (Object)result);
        }
        return null;
    }
}

