/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams.aggregation;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import io.confluent.controlcenter.streams.aggregation.BufferMetricEvent;
import io.confluent.controlcenter.streams.aggregation.GroupBy;
import io.confluent.controlcenter.streams.aggregation.MetricEventSerde;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.streams.state.ReadOnlyWindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;

public class GroupingSets {
    public static PartitionedGroupingSets partitionedBy(String field) {
        return new PartitionedGroupingSets(field);
    }

    public static class PartitionedGroupingSets
    implements GroupBy<BufferMetricEvent, BufferMetricEvent> {
        public static final int NO_COPARTITON_ID = -1;
        private final String partitionField;
        private final BiMap<GroupingSet, Integer> groupingId;
        private final Map<String, ImmutableList<GroupingSet>> partitionedGroupings;
        private final Map<Integer, Map<String, Integer>> dimensionIndexes;
        private final Map<Integer, String> partitionValues;
        private final ImmutableMap<Integer, Integer> coPartitionIds;
        private final ImmutableMap<Integer, String[]> coPartitionFields;
        private final AtomicInteger nextId;

        private PartitionedGroupingSets(String partitionField) {
            this(partitionField, (ImmutableBiMap<GroupingSet, Integer>)ImmutableBiMap.of(), (ImmutableMap<String, ImmutableList<GroupingSet>>)ImmutableMap.of(), (ImmutableMap<Integer, Map<String, Integer>>)ImmutableMap.of(), (ImmutableMap<Integer, Integer>)ImmutableMap.of(), (ImmutableMap<Integer, String[]>)ImmutableMap.of(), new AtomicInteger(0));
        }

        private PartitionedGroupingSets(String partitionField, ImmutableBiMap<GroupingSet, Integer> groupingId, ImmutableMap<String, ImmutableList<GroupingSet>> partitionedGroupings, ImmutableMap<Integer, Map<String, Integer>> dimensionIndexes, ImmutableMap<Integer, Integer> coPartitionIds, ImmutableMap<Integer, String[]> coPartitionFields, AtomicInteger nextId) {
            this.partitionField = partitionField;
            this.groupingId = groupingId;
            this.partitionedGroupings = partitionedGroupings;
            this.dimensionIndexes = dimensionIndexes;
            this.coPartitionFields = coPartitionFields;
            this.coPartitionIds = coPartitionIds;
            this.nextId = nextId;
            this.partitionValues = Maps.transformValues((Map)groupingId.inverse(), (Function)new Function<GroupingSet, String>(){

                public String apply(GroupingSet input) {
                    return input.partitionValue;
                }
            });
        }

        public String getPartitionField() {
            return this.partitionField;
        }

        BiMap<GroupingSet, Integer> getGroupingId() {
            return this.groupingId;
        }

        Map<String, ImmutableList<GroupingSet>> getPartitionedGroupings() {
            return this.partitionedGroupings;
        }

        Map<Integer, Map<String, Integer>> getDimensionIndexes() {
            return this.dimensionIndexes;
        }

        Map<Integer, String> getPartitionValues() {
            return this.partitionValues;
        }

        ImmutableMap<Integer, Integer> getCoPartitionIds() {
            return this.coPartitionIds;
        }

        ImmutableMap<Integer, String[]> getCoPartitionFields() {
            return this.coPartitionFields;
        }

        AtomicInteger getNextId() {
            return this.nextId;
        }

        public Iterable<BufferMetricEvent> createMetricEventForGroupingSets(String partitionValue, final Map<String, String> map) {
            List groupingSets = (List)this.partitionedGroupings.get(partitionValue);
            if (groupingSets == null) {
                return ImmutableList.of();
            }
            return Iterables.transform((Iterable)groupingSets, (Function)new Function<GroupingSet, BufferMetricEvent>(){

                public BufferMetricEvent apply(GroupingSet groupingSet) {
                    int id = (Integer)groupingId.get((Object)groupingSet);
                    return BufferMetricEvent.fromIntAndMap(id, groupingSet.fields, map).withDimensionIndex((Map)dimensionIndexes.get(id));
                }
            });
        }

        public PartitionedGroupingSets addGroupingSet(String partitionValue, List<String> fields) {
            return this.copyAndAddGroupingSet(partitionValue, fields, -1, null);
        }

        public PartitionedGroupingSets addGroupingSet(String partitionValue, List<String> fields, int coPartitionId, List<String> coPartitionFields) {
            Preconditions.checkArgument((coPartitionId >= 0 ? 1 : 0) != 0);
            return this.copyAndAddGroupingSet(partitionValue, fields, coPartitionId, coPartitionFields);
        }

        private synchronized PartitionedGroupingSets copyAndAddGroupingSet(String partitionValue, List<String> fields, int coPartitionId, List<String> coPartitionFields) {
            String[] fieldArray = fields.toArray(new String[0]);
            GroupingSet set = new GroupingSet(partitionValue, fieldArray);
            Preconditions.checkArgument((!this.groupingId.containsKey((Object)set) ? 1 : 0) != 0, (String)"Duplicate grouping set [%s]", (Object)set);
            ImmutableList.Builder groupings = ImmutableList.builder();
            if (this.partitionedGroupings.containsKey(partitionValue)) {
                groupings.addAll((Iterable)this.partitionedGroupings.get(partitionValue)).add((Object)set);
            } else {
                groupings.add((Object)set);
            }
            HashMap updatedPartitionedGroupings = Maps.newHashMap();
            updatedPartitionedGroupings.putAll(this.partitionedGroupings);
            updatedPartitionedGroupings.put(partitionValue, groupings.build());
            ImmutableMap partitionedGroupingsCopy = ImmutableMap.copyOf((Map)updatedPartitionedGroupings);
            int id = this.nextId.getAndIncrement();
            ImmutableMap dimensionIndexesCopy = ImmutableMap.builder().putAll(this.dimensionIndexes).put((Object)id, (Object)Maps.toMap(Arrays.asList(fieldArray), (Function)new Function<String, Integer>(){
                int index = 1;

                public Integer apply(String input) {
                    return this.index++;
                }
            })).build();
            ImmutableBiMap groupingIdCopy = ImmutableBiMap.builder().putAll(this.groupingId).put((Object)set, (Object)id).build();
            ImmutableMap.Builder coPartitionIdBuilder = ImmutableMap.builder().putAll(this.coPartitionIds);
            if (coPartitionId != -1) {
                coPartitionIdBuilder.put((Object)id, (Object)coPartitionId);
            }
            ImmutableMap coPartitionIdCopy = coPartitionIdBuilder.build();
            ImmutableMap coPartitionFieldsCopy = coPartitionFields == null ? this.coPartitionFields : ImmutableMap.builder().putAll(this.coPartitionFields).put((Object)id, (Object)coPartitionFields.toArray(new String[0])).build();
            return new PartitionedGroupingSets(this.partitionField, (ImmutableBiMap<GroupingSet, Integer>)groupingIdCopy, (ImmutableMap<String, ImmutableList<GroupingSet>>)partitionedGroupingsCopy, (ImmutableMap<Integer, Map<String, Integer>>)dimensionIndexesCopy, (ImmutableMap<Integer, Integer>)coPartitionIdCopy, (ImmutableMap<Integer, String[]>)coPartitionFieldsCopy, this.nextId);
        }

        @Override
        public Serde<BufferMetricEvent> keySerde() {
            return MetricEventSerde.forGroupingSets(0, this.dimensionIndexes, this.partitionValues);
        }

        @Override
        public <V> KeyValueMapper<BufferMetricEvent, V, Iterable<KeyValue<BufferMetricEvent, V>>> keyValueMapper() {
            return new KeyValueMapper<BufferMetricEvent, V, Iterable<KeyValue<BufferMetricEvent, V>>>(){

                public Iterable<KeyValue<BufferMetricEvent, V>> apply(BufferMetricEvent bufferMetricEvent, V v) {
                    return ImmutableList.of((Object)KeyValue.pair((Object)bufferMetricEvent, v));
                }
            };
        }

        @Override
        public <V> StreamPartitioner<BufferMetricEvent, V> streamPartitioner() {
            return new StreamPartitioner<BufferMetricEvent, V>(){

                public Integer partition(String topic, BufferMetricEvent key, V value, int numPartitions) {
                    int id = Ints.fromByteArray((byte[])key.getBytes(0));
                    if (coPartitionFields.containsKey((Object)id)) {
                        int coPartitionId = (Integer)coPartitionIds.get((Object)id);
                        String[] fields = (String[])coPartitionFields.get((Object)id);
                        Object[] values = new String[fields.length];
                        for (int i = 0; i < fields.length; ++i) {
                            values[i] = key.getDimension(fields[i]);
                        }
                        return Math.abs(Objects.hash(coPartitionId, Arrays.hashCode(values)) % numPartitions);
                    }
                    return null;
                }
            };
        }

        public <V> GroupedWindowStore<V> groupStore(ReadOnlyWindowStore<BufferMetricEvent, V> store) {
            return new GroupedWindowStore<V>(store);
        }

        public class GroupedWindowStore<V> {
            ReadOnlyWindowStore<BufferMetricEvent, V> store;

            GroupedWindowStore(ReadOnlyWindowStore<BufferMetricEvent, V> store) {
                this.store = store;
            }

            public PartialGroupedWindowStore forGroupingSet(String partitionValue, Collection<String> fields) {
                return new PartialGroupedWindowStore(new GroupingSet(partitionValue, fields.toArray(new String[0])));
            }

            public class PartialGroupedWindowStore {
                GroupingSet groupingSet;
                long start = 0L;
                long end = Long.MAX_VALUE;

                PartialGroupedWindowStore(GroupingSet groupingSet) {
                    this.groupingSet = groupingSet;
                }

                public PartialGroupedWindowStore inRange(long start, long end) {
                    this.start = start;
                    this.end = end;
                    return this;
                }

                public WindowStoreIterator<V> matching(String ... values) {
                    Preconditions.checkArgument((values.length == this.groupingSet.fields.length ? 1 : 0) != 0, (Object)"number of arguments must match the number of fields in the grouping set");
                    Integer id = (Integer)PartitionedGroupingSets.this.groupingId.get((Object)this.groupingSet);
                    if (id != null) {
                        if (this.start == this.end) {
                            return new SingleValueWindowIterator<Object>(this.start, GroupedWindowStore.this.store.fetch((Object)BufferMetricEvent.fromIntAndValues(id, values), this.start));
                        }
                        return GroupedWindowStore.this.store.fetch((Object)BufferMetricEvent.fromIntAndValues(id, values), this.start, this.end);
                    }
                    return null;
                }

                private class SingleValueWindowIterator<V1>
                implements WindowStoreIterator<V1> {
                    private final long key;
                    private final V1 value;
                    private boolean returnedValue;

                    SingleValueWindowIterator(long key, V1 value) {
                        this.key = key;
                        this.value = value;
                        this.returnedValue = false;
                    }

                    public void close() {
                    }

                    public Long peekNextKey() {
                        if (this.returnedValue) {
                            throw new NoSuchElementException();
                        }
                        return this.key;
                    }

                    public boolean hasNext() {
                        return !this.returnedValue;
                    }

                    public KeyValue<Long, V1> next() {
                        if (this.returnedValue) {
                            throw new NoSuchElementException();
                        }
                        this.returnedValue = true;
                        return new KeyValue((Object)this.key, this.value);
                    }

                    public void remove() {
                    }
                }
            }
        }
    }

    static class GroupingSet {
        final String partitionValue;
        final String[] fields;

        GroupingSet(String partitionValue, String[] fields) {
            Preconditions.checkNotNull((Object)partitionValue);
            Preconditions.checkNotNull((Object)fields);
            this.partitionValue = partitionValue;
            this.fields = fields;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("partitionValue", (Object)this.partitionValue).add("fields", (Object)Arrays.toString(this.fields)).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupingSet that = (GroupingSet)o;
            return Objects.equals(this.partitionValue, that.partitionValue) && Arrays.equals(this.fields, that.fields);
        }

        public int hashCode() {
            int ret = Objects.hash(this.partitionValue);
            ret += ret * 31 + Arrays.hashCode(this.fields);
            return ret;
        }
    }
}

