/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams.aggregation;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import io.confluent.controlcenter.rest.Credential;
import io.confluent.metrics.YammerMetricsUtils;
import io.confluent.metrics.record.ConfluentMetric;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.ValueMapper;

public class MetricsExtractor
implements ValueMapper<ConfluentMetric.MetricsMessage, Iterable<KeyValue<Map<String, String>, Long>>> {
    public static final ImmutableSet<String> PARTITION_METRICS = ImmutableSet.of((Object)"UnderReplicated", (Object)"InSyncReplicasCount", (Object)"ReplicasCount");
    public static final ImmutableSet<String> LOG_METRICS = ImmutableSet.of((Object)"NumLogSegments", (Object)"LogStartOffset", (Object)"LogEndOffset", (Object)"Size");
    public static final double NETWORK_PROCESSOR_AVG_IDLE_PERCENT_SCALING_FACTOR = 10000.0;
    private final String metricField;
    private final LoadingCache<Credential, SortedSet<Integer>> brokerCache;
    private final LoadingCache<Credential, SortedSet<String>> topicCache;

    private static TopicPartition topicPartition(Map<String, String> dimensions) {
        return new TopicPartition(dimensions.get("topic"), Integer.parseInt(dimensions.get("partition")));
    }

    public MetricsExtractor(String metricField, LoadingCache<Credential, SortedSet<Integer>> brokerCache, LoadingCache<Credential, SortedSet<String>> topicCache) {
        this.metricField = metricField;
        this.brokerCache = brokerCache;
        this.topicCache = topicCache;
    }

    public Iterable<KeyValue<Map<String, String>, Long>> apply(ConfluentMetric.MetricsMessage value) {
        String brokerId = Integer.toString(value.getBrokerId());
        String clusterId = value.getClusterId();
        ((SortedSet)this.brokerCache.getUnchecked((Object)Credential.makeCredential(clusterId))).add(value.getBrokerId());
        HashSet leaderTopicPartitions = Sets.newHashSet();
        LinkedList metrics = Lists.newLinkedList((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)Iterables.concat((Iterable)YammerMetricsUtils.metricsIterable((Iterable)value.getYammerGaugeList()), (Iterable)YammerMetricsUtils.metricsIterable((Iterable)value.getYammerMeterList()), (Iterable)YammerMetricsUtils.metricsIterable((Iterable)value.getYammerHistogramList()), (Iterable)YammerMetricsUtils.metricsIterable((Iterable)value.getYammerTimerList())), (Function)new YammerToDimensions(leaderTopicPartitions, this.topicCache, clusterId, brokerId, this.metricField)), (Iterable)ImmutableList.of((Object)KeyValue.pair((Object)ImmutableMap.of((Object)this.metricField, (Object)"timestamp", (Object)"cluster", (Object)clusterId, (Object)"broker", (Object)brokerId), (Object)value.getTimestamp()))));
        return FluentIterable.from((Iterable)metrics).filter(Predicates.or((Predicate)Predicates.not((Predicate)new IsPartitionMetric(this.metricField)), (Predicate)new DimensionFromLeader(leaderTopicPartitions))).transform((Function)new SetLeaderDimensionForLogMetrics(this.metricField, leaderTopicPartitions)).append(Iterables.transform((Iterable)Multimaps.index((Iterable)leaderTopicPartitions, (Function)new Function<TopicPartition, String>(){

            public String apply(TopicPartition input) {
                return input.topic();
            }
        }).asMap().entrySet(), (Function)new AddLeaderCount(this.metricField, clusterId, brokerId)));
    }

    public static class AddLeaderCount
    implements Function<Map.Entry<String, Collection<TopicPartition>>, KeyValue<Map<String, String>, Long>> {
        private final String metricField;
        private final String clusterId;
        private final String brokerId;

        public AddLeaderCount(String metricField, String clusterId, String brokerId) {
            this.metricField = metricField;
            this.clusterId = clusterId;
            this.brokerId = brokerId;
        }

        public KeyValue<Map<String, String>, Long> apply(Map.Entry<String, Collection<TopicPartition>> input) {
            return KeyValue.pair((Object)ImmutableMap.of((Object)this.metricField, (Object)"byTopicLeaderCount", (Object)"cluster", (Object)this.clusterId, (Object)"broker", (Object)this.brokerId, (Object)"topic", (Object)input.getKey()), (Object)input.getValue().size());
        }
    }

    public static class SetLeaderDimensionForLogMetrics
    implements Function<KeyValue<Map<String, String>, Long>, KeyValue<Map<String, String>, Long>> {
        private final String metricField;
        private final Set<TopicPartition> leaderTopicPartitions;

        public SetLeaderDimensionForLogMetrics(String metricField, Set<TopicPartition> leaderTopicPartitions) {
            this.metricField = metricField;
            this.leaderTopicPartitions = leaderTopicPartitions;
        }

        public KeyValue<Map<String, String>, Long> apply(KeyValue<Map<String, String>, Long> input) {
            Map dimensions = (Map)input.key;
            if (LOG_METRICS.contains(dimensions.get(this.metricField))) {
                dimensions.put("isLeader", Boolean.toString(this.leaderTopicPartitions.contains(MetricsExtractor.topicPartition(dimensions))));
            }
            return input;
        }
    }

    public static class DimensionFromLeader
    implements Predicate<KeyValue<Map<String, String>, Long>> {
        private final Set<TopicPartition> leaderTopicPartitions;

        public DimensionFromLeader(Set<TopicPartition> leaderTopicPartitions) {
            this.leaderTopicPartitions = leaderTopicPartitions;
        }

        public boolean apply(KeyValue<Map<String, String>, Long> input) {
            return this.leaderTopicPartitions.contains(MetricsExtractor.topicPartition((Map)input.key));
        }
    }

    public static class IsPartitionMetric
    implements Predicate<KeyValue<Map<String, String>, Long>> {
        private final String metricField;

        public IsPartitionMetric(String metricField) {
            this.metricField = metricField;
        }

        public boolean apply(KeyValue<Map<String, String>, Long> input) {
            return PARTITION_METRICS.contains(((Map)input.key).get(this.metricField));
        }
    }

    public static class YammerToDimensions
    implements Function<YammerMetricsUtils.YammerMetric, KeyValue<Map<String, String>, Long>> {
        private final Set<TopicPartition> leaderTopicPartitions;
        private final LoadingCache<Credential, SortedSet<String>> topicCache;
        private final String clusterId;
        private final String brokerId;
        private final String metricField;

        public YammerToDimensions(Set<TopicPartition> leaderTopicPartitions, LoadingCache<Credential, SortedSet<String>> topicCache, String clusterId, String brokerId, String metricField) {
            this.leaderTopicPartitions = leaderTopicPartitions;
            this.topicCache = topicCache;
            this.clusterId = clusterId;
            this.brokerId = brokerId;
            this.metricField = metricField;
        }

        public KeyValue<Map<String, String>, Long> apply(YammerMetricsUtils.YammerMetric input) {
            String metricName = input.getName();
            Map tags = input.getTags();
            if ("ReplicasCount".equals(metricName) && input.longAggregate() > 0L) {
                TopicPartition tp = MetricsExtractor.topicPartition(tags);
                this.leaderTopicPartitions.add(tp);
                ((SortedSet)this.topicCache.getUnchecked((Object)Credential.makeCredential(this.clusterId))).add(tp.topic());
            }
            HashMap dimensions = Maps.newHashMap();
            dimensions.put("cluster", this.clusterId);
            dimensions.put("broker", this.brokerId);
            dimensions.putAll(tags);
            dimensions.put(this.metricField, metricName);
            long metric = "NetworkProcessorAvgIdlePercent".equals(metricName) ? (long)(input.doubleAggregate() * 10000.0) : input.longAggregate();
            return KeyValue.pair((Object)dimensions, (Object)metric);
        }
    }
}

