/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class LruSet<E>
implements Set<E> {
    public static final Object NOTHING_AT_ALL = new Object();
    private final LoadingCache<E, Object> cache;

    public LruSet(int maxSize) {
        this.cache = CacheBuilder.newBuilder().maximumSize((long)maxSize).build(new CacheLoader<E, Object>(){

            public Object load(E key) throws Exception {
                return NOTHING_AT_ALL;
            }
        });
    }

    @Override
    public int size() {
        return (int)this.cache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cache.asMap().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.cache.asMap().containsKey(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.cache.asMap().keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.cache.asMap().keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.cache.asMap().keySet().toArray(a);
    }

    @Override
    public boolean add(E e) {
        if (this.contains(e)) {
            return false;
        }
        this.cache.getUnchecked(e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        boolean wasPresent = this.contains(o);
        this.cache.invalidate(o);
        return wasPresent;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.cache.asMap().keySet().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
    }
}

