# Confluent Control Center

This repository is for all things C3 backend. If you're looking for the frontend repository, it is located [here](https://github.com/confluentinc/blueway-fe).

## License Key

If you are looking for a development/demo license key, there is currently a shared key.
You can find the key on our internal wiki [here](https://confluentinc.atlassian.net/wiki/spaces/SE/pages/1687395973/License+Key+for+demo+dev+INTERNAL+USE+ONLY).

## Quick Setup

For the quickest way to get Confluent Control Center up and running on your machine, see the [following](./docker/control-center/README.md).

## Advanced Setup

*Note!* All directions assume you have a similar file structure for your projects and that you're starting in `root`:
``` bash
. # root
├── controlcenter
└── kafka
```

First you'll need to build Kafka:

``` bash
brew install maven
git clone git@github.com:apache/kafka.git
cd kafka
./gradlewAll install
```

To rebuild:

``` bash
cd kafka
rm -rf .gradle/ && ./gradlew clean && ./gradlewAll install
```

To build the whole project you need to run ```./mvnw package``` in the blueway directory. This will require you to have built each of the depenedent confluent libraries and installed them in your local maven repo. To do this run ```./mvnw install``` in each of these Confluent projects (in this order). You may also need the correct branch checked out for each one:
```
common, rest-utils, schema-registry, kafka-rest, license-file-generator, blueway-fe
```

## Running the Application ##

You'll need to have the following programs running:

1. **ZooKeeper listening at `localhost:2181`**
  ``` bash
  cd kafka
  bin/zookeeper-server-start.sh config/zookeeper.properties
  ```

1. **Kafka**
  ``` bash
  cd kafka
  bin/kafka-server-start.sh config/server.properties
  ```

1. **Connect listening at `localhost:8083`**
  ``` bash
  cd kafka
  bin/connect-distributed.sh config/connect-distributed.properties
  ```
  *Note: you might also want to run the above command with additional connectors in your CLASSPATH. Here is an example with the [hdfs-connector](https://github.com/confluentinc/kafka-connect-hdfs) added:*
  ``` bash
  CLASSPATH=/path/to/root/kafka-connect-hdfs/target/kafka-connect-hdfs-*-package/share/java/kafka-connect-hdfs/* bin/connect-distributed.sh config/connect-distributed.properties
  ```

1. **controlcenter application**
  ``` bash
  cd controlcenter
  ./mvnw package -DskipTests
  ./bin/control-center-start config/control-center-dev.properties
  ```

1. **Start a fake producer / consumer**
  ``` bash
  ./private-bin/rock ./config/control-center-dev.properties
  ```
  
  Configure Rock by editing ```control-center-dev.properties```
  
  If you'd like to test with multiple partitions of production/consumption run
  ``` bash
  bin/kafka-topics.sh --zookeeper localhost:2181 --alter --partitions 18 --topic test-topic
  bin/kafka-topics.sh --zookeeper localhost:2181 --alter --partitions 12 --topic another-topic
  ```

  You may now open the application at [localhost:9021](http://localhost:9021)

  *Note: If you are experiencing problems building, you may need to force an update of your local maven cache using the -U flag: `./mvnw clean package -U -DskipTests`*
  
1. **(Optional) Frontend Development**
All frontend development is done in [confluentinc/blueway-fe](https://github.com/confluentinc/blueway-fe) which includes detailed instructions for getting started.


## Resetting the Application (deleting all data) ##

```
./bin/control-center-reset config/control-center-dev.properties
```

#Dumping/Loading Data

## Data format ##

Similar to `kafka-avro-console-producer` and `kafka-avro-console-consumer`, each record is a single line with the fields separated by tab (by default).  All fields are optional except the value.  Possible fields are:

<table>
    <tr>
        <th>Field</th>
        <th>Format</th>
        <th>Description</th>
        <th>Example</th>
    </tr>
    <tr>
        <td>topic</td>
        <td>string</td>
        <td>the topic</td>
        <td>_confluent-monitoring</td>
    </tr>
    <tr>
        <td>partition</td>
        <td>integer</td>
        <td>the partition</td>
        <td>1</td>
    </tr>
    <tr>
        <td>timestamp</td>
        <td><a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601 datetime</a></td>
        <td>the message timestamp</td>
        <td>2016-06-09T09:29:30.648-07:00</td>
    </tr>
    <tr>
        <td>key</td>
        <td>JSON (similar to <a href="https://developers.google.com/protocol-buffers/docs/proto3#json">Protobuf</a> encoding but defaults are included)</td>
        <td>the message key</td>
        <td>null</td>
    </tr>
    <tr>
        <td>value</td>
        <td>JSON (similar to <a href="https://developers.google.com/protocol-buffers/docs/proto3#json">Protobuf</a> encoding but defaults are included)</td>
        <td>the message value</td>
        <td>{"clientType":"PRODUCER","clientId":"producer-id-2"}</td>
    </tr>
</table>

### Getting a sample of monitoring data to load later ###

```
./bin/control-center-console-consumer config/control-center-dev.properties --topic _confluent-monitoring --from-beginning > monitoring.json
^C
Processed a total of 325 messages
```

Sample data

```
$ head -5 monitoring.json
_confluent-monitoring	0	2016-06-09T09:29:30.633-07:00	null	{"clientType":"PRODUCER","clientId":"producer-id-2","session":"388cb0d9-a647-4481-92bf-63915e96c52c","window":"1465489755000","timestamp":"1465489770465","topic":"another-topic","count":"63","aggregateBytes":"504","aggregateCrc":-9.81604109E8,"samplePeriod":"15000","minWindow":"-1","maxWindow":"-1"}
_confluent-monitoring	0	2016-06-09T09:29:30.648-07:00	null	{"clientType":"PRODUCER","clientId":"producer-id-2","session":"388cb0d9-a647-4481-92bf-63915e96c52c","sequence":"1","window":"1465489770000","timestamp":"1465489770465","topic":"another-topic","count":"3","aggregateBytes":"24","aggregateCrc":9.0084232E8,"samplePeriod":"15000","minWindow":"1465489755000","maxWindow":"1465489755000"}
_confluent-monitoring	0	2016-06-09T09:29:30.650-07:00	null	{"clientType":"PRODUCER","clientId":"producer-id-2","session":"388cb0d9-a647-4481-92bf-63915e96c52c","window":"1465489755000","timestamp":"1465489770465","topic":"test-topic","count":"67","aggregateBytes":"536","aggregateCrc":-4.62237136E8,"samplePeriod":"15000","minWindow":"-1","maxWindow":"-1"}
_confluent-monitoring	0	2016-06-09T09:29:30.651-07:00	null	{"clientType":"PRODUCER","clientId":"producer-id-2","session":"388cb0d9-a647-4481-92bf-63915e96c52c","sequence":"1","window":"1465489770000","timestamp":"1465489770465","topic":"test-topic","count":"3","aggregateBytes":"24","aggregateCrc":-1.773583436E9,"samplePeriod":"15000","minWindow":"1465489755000","maxWindow":"1465489755000"}
_confluent-monitoring	0	2016-06-09T09:29:30.633-07:00	null	{"clientType":"PRODUCER","clientId":"myproducer","session":"d2b2db6f-f56e-4940-9574-6f7cf5c07f19","window":"1465489755000","timestamp":"1465489770465","topic":"test-topic","count":"135","aggregateBytes":"1080","aggregateCrc":1.418194272E9,"samplePeriod":"15000","minWindow":"-1","maxWindow":"-1"}
```

### Loading saved data ###

```
./private-bin/control-center-console-producer config/control-center-dev.properties --topic _confluent-monitoring --property parse.topic=true < monitoring.json
```

### Dumping data from all C3 topics ###

```
./bin/control-center-console-consumer config/control-center-dev.properties --from-beginning --whitelist "_confluent-controlcenter.+"
```

## Generating Monitoring Input Data ##

### Generate 5 minutes of data for 2 input partitions (in the future so that it doesn't expire and get filtered by C3) ###
`python tools/generate_stream_monitoring_input.py --start-time-unix=1530898605 --spec tools/stream_monitoring/10-producers-spec.json --monitoring-partitions 2 --duration 300 > generated.json`

### Start C3 before loading data to make sure the monitoring topic is created ###

```
rm -rf /tmp/confluent/ /tmp/kafka-logs/ /tmp/zookeeper/
#cd kafka
./bin/zookeeper-server-start.sh config/zookeeper.properties
./bin/kafka-server-start.sh config/server.properties
./bin/control-center-start config/control-center-dev.properties
```

### Load generated data ###

`./private-bin/control-center-console-producer config/control-center-dev.properties --topic _confluent-monitoring --property parse.timestamp=false --property parse.key=false < generated.json`

### View it in the UI ###

The generated data file has UI links as comments at the beginning and end of the file

```
head -2 generated.json
# Start first window: 2018-07-06 10:36:45, start last window: 2018-07-06 15:36:30
# C3 UI: http://localhost:9021/monitoring/consumer-groups?monitoringClusterId=cluster-0&fixed-end=1530916605000&fixed-start=1530898605000
```

## Generating Broker Monitoring Input Data ##

### Generate 5 minutes of data (in the future so that it doesn't expire and get filtered by C3) ###
`python tools/generate_broker_monitoring_input.py --start-time-unix=1530898605 --spec tools/broker_monitoring/100-topics-spec.json --duration 5 > generated.json`

Be careful generating data for large clusters. You'll want to compress it inline if you 
pre-generate the data because the metrics data in JSON form is very verbose.

### Load generated data ###

`./private-bin/control-center-console-producer config/control-center-dev.properties --topic _confluent-metrics --property parse.timestamp=false --property parse.key=false < generated.json`

### View it in the UI ###

The generated data file has UI links as comments at the beginning and end of the file

```
head -2 generated.json
# Start first window: 2018-07-06 10:36:45, start last window: 2018-07-06 15:36:30
# C3 UI: http://localhost:9021/monitoring/consumer-groups?monitoringClusterId=cluster-0&fixed-end=1530916605000&fixed-start=1530898605000
```

## Running Sub-Topologies ##

For debugging or perf testing, you can run a single sub-topology by specifying an input topic for it.

Examples:

### Run only the first sub-topology that consumes from the monitoring topic ###
```
./bin/control-center-start --run-tasks-for=_confluent-monitoring config/control-center-dev.properties
```

### Run the "Verifier" sub-topology that consumes from the re-keyed topic ###
```
./bin/control-center-start --run-tasks-for=_confluent-controlcenter-3-2-0-1-monitoring-message-rekey config/control-center-dev.properties
```

### Run the "MonitoringStream" sub-topology ###
```
./bin/control-center-start --run-tasks-for=_confluent-controlcenter-3-2-0-1-monitoring-aggregate-rekey config/control-center-dev.properties
```

### Run the "GroupStream" sub-topology ###
```
./bin/control-center-start --run-tasks-for=_confluent-controlcenter-3-2-0-1-group-stream-extension-rekey config/control-center-dev.properties
```

### Run the map/combine step of the "ConsumerGroupStream" sub-topology ###
```
./bin/control-center-start --run-tasks-for=_confluent-controlcenter-3-2-0-1-aggregate-topic-partition config/control-center-dev.properties
```

### Run the reduce steps of the "ConsumerGroupStream" sub-topology ###
```
./bin/control-center-start --run-tasks-for=_confluent-controlcenter-3-2-0-1-group-aggregate-topic-FIFTEEN_SECONDS config/control-center-dev.properties
./bin/control-center-start --run-tasks-for=_confluent-controlcenter-3-2-0-1-group-aggregate-topic-ONE_HOUR config/control-center-dev.properties
./bin/control-center-start --run-tasks-for=_confluent-controlcenter-3-2-0-1-group-aggregate-topic-ONE_WEEK config/control-center-dev.properties
```
### Run the reduce steps of the "monitoring-message-rekey" sub-topology ###
```
./bin/control-center-start --run-tasks-for=_confluent-controlcenter-3-2-0-1-monitoring-message-rekey config/control-center-dev.properties
```

## Authentication ##

Testing authentication can be done with a static file, or using ldap:

### file
```
cat <<EOF > /tmp/confluent/login.properties
jay: kafka,Administrators
neha: akfak,Administrators
jun: kafka-
EOF
```


### ldap
Get open ldap running via docker:
```
docker run -v /tmp/ldap:/var/lib/ldap \
           -e LDAP_DOMAIN=confluent.io \
           -e LDAP_ORGANISATION="Confluent" \
           -e LDAP_ROOTPASS=kafkaesque \
           -d nickstenning/slapd
```

Add some users to ldap:

```
cat <<EOF > /tmp/data.ldif
dn: dc=confluent,dc=io
objectClass: dcObject
objectClass: organization
dc: confluent
o: Confluent
description: We do Kafka

dn: ou=People,dc=confluent,dc=io
objectClass: organizationalunit
objectClass: top
ou: People

dn: ou=Groups,dc=confluent,dc=io
objectClass: organizationalunit
ou: Groups

dn: cn=Administrators,ou=Groups,dc=confluent,dc=io
objectClass: groupofuniquenames
objectClass: top
ou: Groups
cn: Administrators
uniquemember: sn=jay,ou=People,dc=confluent,dc=io
uniquemember: sn=neha,ou=People,dc=confluent,dc=io

dn: sn=jay,ou=People,dc=confluent,dc=io
cn: Jay Kreps
objectClass: inetOrgPerson
sn: jay
userPassword: kafka
ou: Administrators
ou: People

dn: sn=neha,ou=People,dc=confluent,dc=io
cn: Neha Narkhede
objectClass: inetOrgPerson
sn: neha
userPassword: akfak
ou: Administrators
ou: People

dn: sn=jun,ou=People,dc=confluent,dc=io
cn: Jun Rao
objectClass: inetOrgPerson
sn: jun
userPassword: kafka-
ou: People
EOF

ldapadd -h localhost -p 3890 -c -D cn=admin,dc=confluent,dc=io -W -f data.ldif
```
