/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.rest.ForceRollSegmentsHandle;
import io.confluent.rest.InternalRestServer;
import io.confluent.rest.ResponseContainer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForceRollSegmentsHandler
extends Handler.Abstract {
    private static final Logger log = LoggerFactory.getLogger(InternalRestServer.class);
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final String FORCE_ROLL_SEGMENTS_CONTEXT_PATH = "/v1/tiertools";
    public static final String FORCE_ROLL_SEGMENTS_PATH = "/forcerollsegments";
    private final ForceRollSegmentsHandle forceRollSegmentsHandle;

    public ForceRollSegmentsHandler(ForceRollSegmentsHandle forceRollSegmentsHandle) {
        this.forceRollSegmentsHandle = forceRollSegmentsHandle;
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        String target = request.getHttpURI().getPath();
        if (target.endsWith(FORCE_ROLL_SEGMENTS_PATH)) {
            log.info("Handling REST request at path: {}", (Object)FORCE_ROLL_SEGMENTS_PATH);
            this.handleForceRollSegments(request, response);
        } else {
            log.warn("Unable to handle request at unknown path: " + target);
            ForceRollSegmentsHandler.generateErrorResponse(404, "Unknown command", response);
        }
        return true;
    }

    private void handleForceRollSegments(Request request, Response response) throws IOException {
        try (InputStream inputStream = Content.Source.asInputStream((Content.Source)request);){
            ForceRollSegmentsRequest forceRollSegmentsRequest = (ForceRollSegmentsRequest)OBJECT_MAPPER.readValue(inputStream, ForceRollSegmentsRequest.class);
            log.info("Received ForceRollSegmentsRequest: {}", (Object)forceRollSegmentsRequest.toString());
            List<String> failedPartitions = this.forceRollSegmentsHandle.maybeForceRollSegments(forceRollSegmentsRequest.logicalClusterId).stream().map(TopicPartition::toString).collect(Collectors.toList());
            ForceRollSegmentsResponse cmdResponse = new ForceRollSegmentsResponse(failedPartitions.isEmpty(), failedPartitions);
            ResponseContainer.dataResponse(cmdResponse).write(OBJECT_MAPPER, response);
        }
        catch (Exception e) {
            String errorMessage = "Failed to force roll segments";
            log.error(errorMessage, (Throwable)e);
            int errorCode = e instanceof IllegalArgumentException ? 400 : 500;
            ForceRollSegmentsHandler.generateErrorResponse(errorCode, errorMessage + e.getMessage(), response);
        }
    }

    private static void generateErrorResponse(int errorCode, String message, Response response) throws IOException {
        log.error("Sending error message with code: {} to REST client: {}", (Object)errorCode, (Object)message);
        ResponseContainer.ErrorResponse errResponse = new ResponseContainer.ErrorResponse(0, errorCode, message);
        ResponseContainer<?> responseContainer = ResponseContainer.errorResponse(Collections.singletonList(errResponse));
        responseContainer.write(OBJECT_MAPPER, response);
    }

    public static final class ForceRollSegmentsRequest {
        @JsonProperty(value="logicalClusterId")
        final String logicalClusterId;

        @JsonCreator
        public ForceRollSegmentsRequest(@JsonProperty(value="logicalClusterId", required=true) String logicalClusterId) {
            this.logicalClusterId = logicalClusterId;
        }

        public String toString() {
            return "ForceRollSegmentsRequest{logicalClusterId=" + this.logicalClusterId + "}";
        }
    }

    public static final class ForceRollSegmentsResponse {
        @JsonProperty(value="success")
        final boolean success;
        @JsonProperty(value="failedPartitions")
        final List<String> failedPartitions;

        @JsonCreator
        public ForceRollSegmentsResponse(@JsonProperty(value="success", required=true) boolean success, @JsonProperty(value="failedPartitions", required=true) List<String> failedPartitions) {
            this.success = success;
            this.failedPartitions = failedPartitions;
        }

        public boolean success() {
            return this.success;
        }

        public List<String> failedPartitions() {
            return this.failedPartitions;
        }

        public String toString() {
            return "ForceRollSegmentsResponse{success=" + this.success + "failedPartitions=" + this.logFailedPartitions() + "}";
        }

        private String logFailedPartitions() {
            return String.join((CharSequence)", ", this.failedPartitions);
        }
    }
}

