/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.clients.plugins.auth.token;

import com.fasterxml.jackson.core.type.TypeReference;
import io.confluent.kafka.clients.plugins.auth.entities.SanitizeTokenRequest;
import io.confluent.kafka.clients.plugins.auth.token.AbstractTokenLoginCallbackHandler;
import io.confluent.security.auth.client.provider.BuiltInAuthProviders;
import io.confluent.security.auth.client.rest.RestClient;
import io.confluent.security.auth.client.rest.RestRequest;
import io.confluent.security.auth.client.rest.entities.AuthenticationResponse;
import io.confluent.security.auth.client.rest.exceptions.RestClientException;
import io.confluent.security.auth.common.JwtBearerToken;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenBearerLoginCallbackHandler
extends AbstractTokenLoginCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(TokenBearerLoginCallbackHandler.class);
    private RestClient restClient;
    private Map<String, Object> configs;
    private JwtConsumer jwtReader;
    private static final String SANITIZE_TOKEN_ENDPOINT = "/token/sanitize";
    private static final String MEX_CLAIM = "mex";
    private static final TypeReference<AuthenticationResponse> AUTHENTICATION_RESPONSE_TYPE = new TypeReference<AuthenticationResponse>(){};

    @Override
    public void configure(Map<String, ?> configs) {
        this.configs = new HashMap(configs);
        this.configs.put("confluent.metadata.http.auth.credentials.provider", BuiltInAuthProviders.HttpCredentialProviders.BEARER.name());
        this.jwtReader = new JwtConsumerBuilder().setSkipSignatureVerification().setDisableRequireSignature().setSkipAllValidators().setSkipAllDefaultValidators().build();
        String authenticationToken = (String)configs.get("authenticationToken");
        this.createAndSetRestClient(this.configs, authenticationToken);
    }

    private void createAndSetRestClient(Map<String, Object> configs, String authenticationToken) {
        configs.put("confluent.metadata.token.auth.credential", authenticationToken);
        this.close();
        this.restClient = this.createRestClient(configs);
    }

    protected RestClient createRestClient(Map<String, Object> configs) {
        return new RestClient(configs);
    }

    @Override
    void attachAuthToken(OAuthBearerTokenCallback callback) {
        if (callback.token() != null) {
            throw new IllegalArgumentException("Callback had an Authentication Token already");
        }
        try {
            String authToken = this.configs.get("confluent.metadata.token.auth.credential").toString();
            JwtClaims currClaims = this.getCurrentClaims(authToken);
            if (currClaims.hasClaim(MEX_CLAIM)) {
                ArrayList<String> claimsToSanitize = new ArrayList<String>();
                claimsToSanitize.add(MEX_CLAIM);
                OAuthBearerToken newToken = this.sanitizeToken(authToken, claimsToSanitize);
                log.debug("Successfully sanitized the token for claims: {}", (Object)Arrays.toString(claimsToSanitize.toArray()));
                this.createAndSetRestClient(this.configs, newToken.value());
            }
        }
        catch (Exception e) {
            throw new KafkaException("TokenBearerLoginCallbackHandler failed due to exception while sanitizing token", (Throwable)e);
        }
        OAuthBearerToken token = this.restClient.login();
        this.createAndSetRestClient(this.configs, token.value());
        callback.token(token);
    }

    protected JwtClaims getCurrentClaims(String authToken) {
        try {
            return this.jwtReader.processToClaims(authToken);
        }
        catch (Exception e) {
            throw new KafkaException("TokenBearerLoginCallbackHandler failed due to get current claims", (Throwable)e);
        }
    }

    protected OAuthBearerToken sanitizeToken(String authToken, Collection<String> sanitizeClaims) throws RestClientException, URISyntaxException {
        log.debug("Got a request to sanitize the token for claims: {}", (Object)Arrays.toString(sanitizeClaims.toArray()));
        RestRequest request = this.restClient.newRequest(SANITIZE_TOKEN_ENDPOINT);
        SanitizeTokenRequest sanitizeTokenRequest = new SanitizeTokenRequest(authToken, sanitizeClaims);
        request.setRequest(sanitizeTokenRequest);
        request.setRequestMethod("POST");
        request.setResponse(AUTHENTICATION_RESPONSE_TYPE);
        AuthenticationResponse response = (AuthenticationResponse)this.restClient.sendRequest(request);
        return new JwtBearerToken(response.authenticationToken());
    }

    @Override
    public void close() {
        this.closeRestClient();
    }

    @Override
    public void validateHaveCredentials(Map<String, String> moduleOptions, Map<String, ?> configs) throws ConfigException {
        String authenticationToken = moduleOptions.getOrDefault("authenticationToken", "");
        if (authenticationToken.isEmpty()) {
            throw new ConfigException(String.format("Missing required configuration %s which has no default value.", "authenticationToken"));
        }
    }

    private void closeRestClient() {
        if (this.restClient != null) {
            this.restClient.close();
        }
    }
}

