/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf.dynamic;

import com.google.protobuf.DescriptorProtos;
import io.confluent.kafka.schemaregistry.protobuf.dynamic.DynamicSchema;
import io.confluent.protobuf.MetaProto;
import java.util.Map;

public class EnumDefinition {
    private DescriptorProtos.EnumDescriptorProto mEnumType;

    public static Builder newBuilder(String enumName) {
        return EnumDefinition.newBuilder(enumName, null);
    }

    public static Builder newBuilder(String enumName, Boolean allowAlias) {
        return new Builder(enumName, allowAlias);
    }

    public String toString() {
        return this.mEnumType.toString();
    }

    DescriptorProtos.EnumDescriptorProto getEnumType() {
        return this.mEnumType;
    }

    private EnumDefinition(DescriptorProtos.EnumDescriptorProto enumType) {
        this.mEnumType = enumType;
    }

    public static class Builder {
        private DescriptorProtos.EnumDescriptorProto.Builder mEnumTypeBuilder = DescriptorProtos.EnumDescriptorProto.newBuilder();

        public String getName() {
            return this.mEnumTypeBuilder.getName();
        }

        public Builder addValue(String name, int num) {
            return this.addValue(name, num, null, null);
        }

        public Builder addValue(String name, int num, String doc, Map<String, String> params) {
            DescriptorProtos.EnumValueDescriptorProto.Builder enumValBuilder = DescriptorProtos.EnumValueDescriptorProto.newBuilder();
            enumValBuilder.setName(name).setNumber(num);
            MetaProto.Meta meta = DynamicSchema.toMeta(doc, params);
            if (meta != null) {
                DescriptorProtos.EnumValueOptions.Builder optionsBuilder = DescriptorProtos.EnumValueOptions.newBuilder();
                optionsBuilder.setExtension(MetaProto.enumValueMeta, (Object)meta);
                enumValBuilder.mergeOptions(optionsBuilder.build());
            }
            this.mEnumTypeBuilder.addValue(enumValBuilder.build());
            return this;
        }

        public Builder setMeta(String doc, Map<String, String> params) {
            MetaProto.Meta meta = DynamicSchema.toMeta(doc, params);
            if (meta != null) {
                DescriptorProtos.EnumOptions.Builder optionsBuilder = DescriptorProtos.EnumOptions.newBuilder();
                optionsBuilder.setExtension(MetaProto.enumMeta, (Object)meta);
                this.mEnumTypeBuilder.mergeOptions(optionsBuilder.build());
            }
            return this;
        }

        public EnumDefinition build() {
            return new EnumDefinition(this.mEnumTypeBuilder.build());
        }

        private Builder(String enumName, Boolean allowAlias) {
            this.mEnumTypeBuilder.setName(enumName);
            if (allowAlias != null) {
                DescriptorProtos.EnumOptions.Builder optionsBuilder = DescriptorProtos.EnumOptions.newBuilder();
                optionsBuilder.setAllowAlias(allowAlias.booleanValue());
                this.mEnumTypeBuilder.mergeOptions(optionsBuilder.build());
            }
        }
    }
}

