/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import io.confluent.kafka.schemaregistry.rest.MutableHttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class RequestHeaderHandler
extends HandlerWrapper {
    public static final String X_REQUEST_ID_HEADER = "X-Request-ID";
    public static final String X_FORWARDED_FOR_HEADER = "X-Forwarded-For";
    private static final Logger log = LoggerFactory.getLogger(RequestHeaderHandler.class);

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        MDC.clear();
        MutableHttpServletRequest mutableRequest = new MutableHttpServletRequest(request);
        this.addXRequestIdToRequest(baseRequest, mutableRequest, response);
        this.addXForwardedForToRequest(baseRequest, mutableRequest, request);
        super.handle(target, baseRequest, (HttpServletRequest)mutableRequest, response);
    }

    protected void addXRequestIdToRequest(Request baseRequest, MutableHttpServletRequest mutableRequest, HttpServletResponse response) {
        ArrayList<String> inputHeaders = Collections.list(baseRequest.getHeaders(X_REQUEST_ID_HEADER));
        String requestId = this.getRequestId(inputHeaders);
        mutableRequest.putHeader(X_REQUEST_ID_HEADER, requestId);
        response.setHeader(X_REQUEST_ID_HEADER, requestId);
        MDC.put((String)"requestId", (String)requestId);
    }

    protected void addXForwardedForToRequest(Request baseRequest, MutableHttpServletRequest mutableRequest, HttpServletRequest request) {
        if (baseRequest.getHeader("X-Forward") == null) {
            mutableRequest.putHeader(X_FORWARDED_FOR_HEADER, request.getRemoteAddr());
        }
        log.info("Forwarded for header in RequestHeaderHandler: {}", (Object)mutableRequest.getHeader(X_FORWARDED_FOR_HEADER));
    }

    protected String getRequestId(List<String> headers) {
        if (headers.size() == 1 && StringUtil.isNotBlank((String)headers.get(0))) {
            return headers.get(0);
        }
        return UUID.randomUUID().toString();
    }
}

