/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.exceptions;

import io.confluent.rest.entities.ErrorMessage;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.eclipse.jetty.io.EofException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class JettyEofExceptionMapper
implements ExceptionMapper<EofException> {
    private static final String ERROR_MESSAGE = "EOF Exception encountered - client disconnected during stream processing.";
    private static final Logger LOGGER = LoggerFactory.getLogger(JettyEofExceptionMapper.class);

    public Response toResponse(EofException exception) {
        LOGGER.error(ERROR_MESSAGE, (Throwable)exception);
        ErrorMessage message = new ErrorMessage(Response.Status.BAD_REQUEST.getStatusCode(), ERROR_MESSAGE);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build();
    }
}

