/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.Sets;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.CompatibilityPolicy;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.ParsedSchemaHolder;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaVersionFetcher;
import io.confluent.kafka.schemaregistry.client.rest.entities.Config;
import io.confluent.kafka.schemaregistry.client.rest.entities.ContextId;
import io.confluent.kafka.schemaregistry.client.rest.entities.ExtendedSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaEntity;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaTags;
import io.confluent.kafka.schemaregistry.client.rest.entities.SubjectVersion;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ModeUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.TagSchemaRequest;
import io.confluent.kafka.schemaregistry.client.security.SslFactory;
import io.confluent.kafka.schemaregistry.exceptions.InvalidSchemaException;
import io.confluent.kafka.schemaregistry.exceptions.OperationNotPermittedException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryStoreException;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.metrics.MetricsContainer;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.rest.VersionId;
import io.confluent.kafka.schemaregistry.rest.extensions.SchemaRegistryResourceExtension;
import io.confluent.kafka.schemaregistry.rest.handlers.CompositeUpdateRequestHandler;
import io.confluent.kafka.schemaregistry.rest.handlers.UpdateRequestHandler;
import io.confluent.kafka.schemaregistry.storage.CloseableIterator;
import io.confluent.kafka.schemaregistry.storage.ConfigKey;
import io.confluent.kafka.schemaregistry.storage.ConfigValue;
import io.confluent.kafka.schemaregistry.storage.ContextKey;
import io.confluent.kafka.schemaregistry.storage.ContextValue;
import io.confluent.kafka.schemaregistry.storage.DelegatingIterator;
import io.confluent.kafka.schemaregistry.storage.FilteredIterator;
import io.confluent.kafka.schemaregistry.storage.LazyParsedSchemaHolder;
import io.confluent.kafka.schemaregistry.storage.LookupCache;
import io.confluent.kafka.schemaregistry.storage.LookupFilter;
import io.confluent.kafka.schemaregistry.storage.Mode;
import io.confluent.kafka.schemaregistry.storage.RuleSetHandler;
import io.confluent.kafka.schemaregistry.storage.SchemaIdAndSubjects;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryValue;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;
import io.confluent.kafka.schemaregistry.storage.Store;
import io.confluent.kafka.schemaregistry.storage.TransformedIterator;
import io.confluent.kafka.schemaregistry.storage.encoder.MetadataEncoderService;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreException;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import io.confluent.rest.NamedURI;
import java.security.KeyStore;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.HostnameVerifier;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.utils.Time;
import org.eclipse.jetty.server.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSchemaRegistry
implements SchemaRegistry,
SslFactory.SslFactoryCreated {
    private static final Logger log = LoggerFactory.getLogger(AbstractSchemaRegistry.class);
    protected Store<SchemaRegistryKey, SchemaRegistryValue> store;
    protected final SchemaRegistryConfig config;
    protected final Map<String, Object> props;
    protected final MetricsContainer metricsContainer;
    protected final Map<String, SchemaProvider> providers;
    protected final List<SchemaRegistryResourceExtension> resourceExtensions;
    protected final List<Handler.Singleton> customHandler;
    protected final List<UpdateRequestHandler> updateRequestHandlers;
    protected final SslFactory sslFactory;
    protected final LoadingCache<RawSchema, ParsedSchema> newSchemaCache;
    protected final LoadingCache<RawSchema, ParsedSchema> oldSchemaCache;
    protected final CompatibilityLevel defaultCompatibilityLevel;
    protected final boolean defaultValidateFields;
    protected final boolean defaultValidateNames;
    protected final Mode defaultMode;
    protected final int schemaSearchDefaultLimit;
    protected final int schemaSearchMaxLimit;
    protected final int subjectVersionSearchDefaultLimit;
    protected final int subjectVersionSearchMaxLimit;
    protected final int subjectSearchDefaultLimit;
    protected final int contextSearchMaxLimit;
    protected final int contextSearchDefaultLimit;
    protected final int subjectSearchMaxLimit;
    protected final boolean allowModeChanges;
    protected final AtomicBoolean initialized;
    protected final Time time;
    protected LookupCache<SchemaRegistryKey, SchemaRegistryValue> lookupCache;
    protected MetadataEncoderService metadataEncoder;
    protected RuleSetHandler ruleSetHandler;

    protected AbstractSchemaRegistry(SchemaRegistryConfig config, MetricsContainer metricsContainer) throws SchemaRegistryException {
        this.config = config;
        this.props = new ConcurrentHashMap<String, Object>();
        this.metricsContainer = metricsContainer;
        this.providers = this.initProviders();
        this.resourceExtensions = this.initResourceExtensions();
        this.customHandler = new CopyOnWriteArrayList<Handler.Singleton>();
        this.updateRequestHandlers = new CopyOnWriteArrayList<UpdateRequestHandler>();
        this.ruleSetHandler = new RuleSetHandler();
        String interInstanceListenerNameConfig = config.interInstanceListenerName();
        NamedURI internalListener = AbstractSchemaRegistry.getInterInstanceListener(config.getListeners(), interInstanceListenerNameConfig, config.interInstanceProtocol());
        Map<String, Object> sslConfig = config.getOverriddenSslConfigs(internalListener);
        this.sslFactory = new SslFactory(ConfigDef.convertToStringMapWithPasswordValues(sslConfig), (SslFactory.SslFactoryCreated)this);
        this.newSchemaCache = Caffeine.newBuilder().maximumSize((long)(config.getInt("schema.cache.size") / 2)).expireAfterAccess((long)config.getInt("schema.cache.expiry.secs").intValue(), TimeUnit.SECONDS).build(s -> this.loadSchema(s.getSchema(), s.isNew(), s.isNormalize()));
        this.oldSchemaCache = Caffeine.newBuilder().maximumSize((long)(config.getInt("schema.cache.size") / 2)).expireAfterAccess((long)config.getInt("schema.cache.expiry.secs").intValue(), TimeUnit.SECONDS).build(s -> this.loadSchema(s.getSchema(), s.isNew(), s.isNormalize()));
        this.defaultCompatibilityLevel = config.compatibilityType();
        this.defaultValidateFields = config.getBoolean("schema.validate.fields");
        this.defaultValidateNames = config.getBoolean("schema.validate.names");
        this.defaultMode = Mode.READWRITE;
        this.schemaSearchDefaultLimit = config.getInt("schema.search.default.limit");
        this.schemaSearchMaxLimit = config.getInt("schema.search.max.limit");
        this.subjectVersionSearchDefaultLimit = config.getInt("subject.version.search.default.limit");
        this.subjectVersionSearchMaxLimit = config.getInt("subject.version.search.max.limit");
        this.subjectSearchDefaultLimit = config.getInt("subject.search.default.limit");
        this.contextSearchMaxLimit = config.getInt("context.search.max.limit");
        this.contextSearchDefaultLimit = config.getInt("context.search.default.limit");
        this.subjectSearchMaxLimit = config.getInt("subject.search.max.limit");
        this.allowModeChanges = config.getBoolean("mode.mutability");
        this.initialized = new AtomicBoolean(false);
        this.time = config.getTime();
    }

    protected List<SchemaRegistryResourceExtension> initResourceExtensions() {
        return this.config.getConfiguredInstances(this.config.definedResourceExtensionConfigName(), SchemaRegistryResourceExtension.class);
    }

    public static NamedURI getInterInstanceListener(List<NamedURI> listeners, String interInstanceListenerName, String requestedScheme) throws SchemaRegistryException {
        if (requestedScheme.isEmpty()) {
            requestedScheme = "http";
        }
        NamedURI internalListener = null;
        for (NamedURI listener : listeners) {
            if (listener.getName() != null && listener.getName().equalsIgnoreCase(interInstanceListenerName)) {
                internalListener = listener;
                break;
            }
            if (!listener.getUri().getScheme().equalsIgnoreCase(requestedScheme)) continue;
            internalListener = listener;
        }
        if (internalListener == null) {
            throw new SchemaRegistryException(" No listener configured with requested scheme " + requestedScheme);
        }
        return internalListener;
    }

    protected Map<String, SchemaProvider> initProviders() {
        Map schemaProviderConfigs = this.config.originalsWithPrefix("schema.providers.");
        schemaProviderConfigs.put("schemaVersionFetcher", this);
        List<SchemaProvider> defaultSchemaProviders = Arrays.asList(new AvroSchemaProvider(), new JsonSchemaProvider(), new ProtobufSchemaProvider());
        for (SchemaProvider provider : defaultSchemaProviders) {
            provider.configure(schemaProviderConfigs);
        }
        HashMap<String, SchemaProvider> providerMap = new HashMap<String, SchemaProvider>();
        this.registerProviders(providerMap, defaultSchemaProviders);
        List customSchemaProviders = this.config.getConfiguredInstances("schema.providers", SchemaProvider.class, schemaProviderConfigs);
        this.registerProviders(providerMap, customSchemaProviders);
        this.metricsContainer.getCustomSchemaProviderCount().record(customSchemaProviders.size());
        return providerMap;
    }

    protected void registerProviders(Map<String, SchemaProvider> providerMap, List<SchemaProvider> schemaProviders) {
        for (SchemaProvider schemaProvider : schemaProviders) {
            log.info("Registering schema provider for {}: {}", (Object)schemaProvider.schemaType(), (Object)schemaProvider.getClass().getName());
            providerMap.put(schemaProvider.schemaType(), schemaProvider);
        }
    }

    protected ParsedSchema loadSchema(Schema schema, boolean isNew, boolean normalize) throws InvalidSchemaException {
        SchemaProvider provider;
        String schemaType = schema.getSchemaType();
        if (schemaType == null) {
            schemaType = "AVRO";
        }
        if ((provider = this.schemaProvider(schemaType)) == null) {
            String errMsg = "Invalid schema type " + schemaType;
            log.error(errMsg);
            throw new InvalidSchemaException(errMsg);
        }
        String type = schemaType;
        try {
            return provider.parseSchemaOrElseThrow(schema, isNew, normalize);
        }
        catch (Exception e) {
            throw new InvalidSchemaException("Invalid schema of type " + type + ", details: " + e.getMessage());
        }
    }

    public Schema register(String subject, RegisterSchemaRequest request, boolean normalize) throws SchemaRegistryException {
        try {
            Schema schema = new Schema(subject, request);
            if (request.hasSchemaTagsToAddOrRemove()) {
                ParsedSchema parsedSchema = this.parseSchema(schema);
                ParsedSchema newSchema = parsedSchema.copy(TagSchemaRequest.schemaTagsListToMap((List)request.getSchemaTagsToAdd()), TagSchemaRequest.schemaTagsListToMap((List)request.getSchemaTagsToRemove()));
                int version = request.getVersion() != null ? request.getVersion() : -1;
                schema = new Schema(subject, Integer.valueOf(version), schema.getId(), newSchema);
            }
            return this.register(subject, schema, normalize, request.doPropagateSchemaTags());
        }
        catch (IllegalArgumentException e) {
            throw new InvalidSchemaException(e);
        }
    }

    protected boolean isReadOnlyMode(String subject) throws SchemaRegistryStoreException {
        Mode subjectMode = this.getModeInScope(subject);
        return subjectMode == Mode.READONLY || subjectMode == Mode.READONLY_OVERRIDE;
    }

    protected void checkRegisterMode(String subject, Schema schema) throws OperationNotPermittedException, SchemaRegistryStoreException {
        String context = QualifiedSubject.qualifiedContextFor((String)this.tenant(), (String)subject);
        if (this.isReadOnlyMode(subject)) {
            throw new OperationNotPermittedException("Subject " + subject + " in context " + context + " is in read-only mode");
        }
        if (schema.getId() >= 0) {
            if (!this.getModeInScope(subject).isImportOrForwardMode()) {
                throw new OperationNotPermittedException("Subject " + subject + " in context " + context + " is not in import mode");
            }
        } else if (this.getModeInScope(subject) != Mode.READWRITE) {
            throw new OperationNotPermittedException("Subject " + subject + " in context " + context + " is not in read-write mode");
        }
    }

    private boolean maybePropagateSchemaTags(Schema schema, LazyParsedSchemaHolder previousSchema, boolean propagateSchemaTags) throws InvalidSchemaException {
        if (!propagateSchemaTags || previousSchema == null) {
            return false;
        }
        Map schemaTags = previousSchema.schema().inlineTaggedEntities();
        if (schemaTags.isEmpty()) {
            return false;
        }
        ParsedSchema parsedSchema = this.parseSchema(schema);
        parsedSchema = parsedSchema.copy(schemaTags, Collections.emptyMap());
        schema.setSchema(parsedSchema.canonicalString());
        return true;
    }

    private String getConfluentVersion(Metadata metadata) {
        return metadata != null ? metadata.getConfluentVersion() : null;
    }

    protected boolean maybeSetMetadataRuleSet(Config config, Schema schema, Schema previousSchema, Integer newVersion) {
        Metadata specificMetadata = null;
        if (schema.getMetadata() != null) {
            specificMetadata = schema.getMetadata();
        } else if (previousSchema != null) {
            specificMetadata = previousSchema.getMetadata();
        }
        Metadata defaultMetadata = config.getDefaultMetadata();
        Metadata overrideMetadata = config.getOverrideMetadata();
        Metadata mergedMetadata = Metadata.mergeMetadata((Metadata)Metadata.mergeMetadata((Metadata)defaultMetadata, (Metadata)specificMetadata), (Metadata)overrideMetadata);
        RuleSet specificRuleSet = null;
        if (schema.getRuleSet() != null) {
            specificRuleSet = schema.getRuleSet();
        } else if (previousSchema != null) {
            specificRuleSet = previousSchema.getRuleSet();
        }
        RuleSet defaultRuleSet = config.getDefaultRuleSet();
        RuleSet overrideRuleSet = config.getOverrideRuleSet();
        RuleSet mergedRuleSet = RuleSet.mergeRuleSets((RuleSet)RuleSet.mergeRuleSets((RuleSet)defaultRuleSet, (RuleSet)specificRuleSet), (RuleSet)overrideRuleSet);
        if (newVersion != null && (schema.getVersion() != 0 || this.getConfluentVersion(mergedMetadata) != null)) {
            mergedMetadata = Metadata.setConfluentVersion((Metadata)mergedMetadata, (int)newVersion);
        }
        if (mergedMetadata != null || mergedRuleSet != null) {
            schema.setMetadata(mergedMetadata);
            schema.setRuleSet(mergedRuleSet);
            return true;
        }
        return false;
    }

    protected boolean maybePopulateFromPrevious(Config config, Schema schema, List<ParsedSchemaHolder> undeletedVersions, int newVersion, boolean propagateSchemaTags) throws SchemaRegistryException {
        Schema previousSchema;
        boolean populatedSchema = false;
        LazyParsedSchemaHolder previousSchemaHolder = !undeletedVersions.isEmpty() ? (LazyParsedSchemaHolder)undeletedVersions.get(0) : null;
        Schema schema2 = previousSchema = previousSchemaHolder != null ? this.toSchemaEntity(previousSchemaHolder.schemaValue()) : null;
        if (schema == null || schema.getSchema() == null || schema.getSchema().trim().isEmpty()) {
            if (previousSchema != null) {
                schema.setSchema(previousSchema.getSchema());
                schema.setSchemaType(previousSchema.getSchemaType());
                schema.setReferences(previousSchema.getReferences());
                populatedSchema = true;
            } else {
                throw new InvalidSchemaException("Empty schema");
            }
        }
        boolean populatedSchemaTags = this.maybePropagateSchemaTags(schema, previousSchemaHolder, propagateSchemaTags);
        boolean populatedMetadataRuleSet = this.maybeSetMetadataRuleSet(config, schema, previousSchema, newVersion);
        return populatedSchema || populatedSchemaTags || populatedMetadataRuleSet;
    }

    private RuleSet maybeModifyPreviousRuleSet(String subject, TagSchemaRequest request) throws SchemaRegistryException {
        RuleSet ruleSet;
        if (request.getRulesToMerge() == null && request.getRulesToRemove() == null) {
            return request.getRuleSet();
        }
        int oldVersion = request.getNewVersion() != null ? request.getNewVersion() - 1 : -1;
        Schema oldSchema = this.get(subject, oldVersion, false);
        RuleSet ruleSet2 = ruleSet = oldSchema != null ? oldSchema.getRuleSet() : null;
        if (request.getRulesToMerge() != null) {
            ruleSet = RuleSet.mergeRuleSets((RuleSet)ruleSet, (RuleSet)request.getRulesToMerge());
        }
        if (ruleSet != null && request.getRulesToRemove() != null) {
            List encodingRules;
            List domainRules;
            List rulesToRemove = request.getRulesToRemove();
            List migrationRules = ruleSet.getMigrationRules();
            if (migrationRules != null) {
                migrationRules = migrationRules.stream().filter(r -> !rulesToRemove.contains(r.getName())).collect(Collectors.toList());
            }
            if ((domainRules = ruleSet.getDomainRules()) != null) {
                domainRules = domainRules.stream().filter(r -> !rulesToRemove.contains(r.getName())).collect(Collectors.toList());
            }
            if ((encodingRules = ruleSet.getEncodingRules()) != null) {
                encodingRules = encodingRules.stream().filter(r -> !rulesToRemove.contains(r.getName())).collect(Collectors.toList());
            }
            ruleSet = new RuleSet(migrationRules, domainRules, encodingRules);
        }
        return ruleSet;
    }

    public Schema modifySchemaTags(String subject, Schema schema, TagSchemaRequest request) throws SchemaRegistryException {
        ParsedSchema parsedSchema = this.parseSchema(schema);
        int newVersion = request.getNewVersion() != null ? request.getNewVersion() : 0;
        Metadata mergedMetadata = request.getMetadata() != null ? request.getMetadata() : parsedSchema.metadata();
        mergedMetadata = Metadata.setConfluentVersion((Metadata)mergedMetadata, (int)newVersion);
        RuleSet ruleSet = this.maybeModifyPreviousRuleSet(subject, request);
        try {
            ParsedSchema newSchema = parsedSchema.copy(TagSchemaRequest.schemaTagsListToMap((List)request.getTagsToAdd()), TagSchemaRequest.schemaTagsListToMap((List)request.getTagsToRemove())).copy(mergedMetadata, ruleSet).copy(Integer.valueOf(newVersion));
            return this.register(subject, new Schema(subject, Integer.valueOf(newVersion), Integer.valueOf(-1), newSchema), false);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidSchemaException(e);
        }
    }

    protected void logSchemaOp(Schema schema, String operation) {
        log.info("Resource association log - (tenant, id, subject, operation): ({}, {}, {}, {})", new Object[]{this.tenant(), schema.getId(), schema.getSubject(), operation});
    }

    protected boolean isSchemaFieldValidationEnabled(Config config) {
        return config.isValidateFields() != null ? config.isValidateFields() : this.defaultValidateFields;
    }

    protected boolean isSchemaNameValidationEnabled(Config config) {
        return config.isValidateNames() != null ? config.isValidateNames() : this.defaultValidateNames;
    }

    private ParsedSchema maybeValidateAndNormalizeSchema(ParsedSchema parsedSchema, Schema schema, Config config, boolean normalize) throws InvalidSchemaException {
        try {
            Mode mode = this.getModeInScope(schema.getSubject());
            if (!mode.isImportOrForwardMode()) {
                parsedSchema.validate(this.isSchemaFieldValidationEnabled(config));
            }
            if (normalize) {
                parsedSchema = parsedSchema.normalize();
            }
        }
        catch (Exception e) {
            String errMsg = "Invalid schema " + String.valueOf(schema) + ", details: " + e.getMessage();
            log.error(errMsg, (Throwable)e);
            throw new InvalidSchemaException(errMsg, e);
        }
        schema.setSchemaType(parsedSchema.schemaType());
        schema.setSchema(parsedSchema.canonicalString());
        schema.setReferences(parsedSchema.references());
        return parsedSchema;
    }

    protected ParsedSchema canonicalizeSchema(Schema schema, Config config, boolean isNew, boolean normalize) throws InvalidSchemaException {
        if (schema == null || schema.getSchema() == null || schema.getSchema().trim().isEmpty()) {
            return null;
        }
        ParsedSchema parsedSchema = this.parseSchema(schema, isNew, normalize);
        return this.maybeValidateAndNormalizeSchema(parsedSchema, schema, config, normalize);
    }

    protected boolean isSubjectVersionDeleted(String subject, int version) throws SchemaRegistryException {
        try {
            SchemaValue schemaValue = (SchemaValue)this.store.get(new SchemaKey(subject, version));
            return schemaValue == null || schemaValue.isDeleted();
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error while retrieving schema from the backend Kafka store", e);
        }
    }

    private CloseableIterator<SchemaRegistryValue> allVersionsFromAllContexts(BiFunction<String, Integer, SchemaRegistryKey> keyCreator, String tenantPrefix, String unqualifiedSubjectOrPrefix, boolean isPrefix) throws SchemaRegistryException {
        ArrayList<SchemaRegistryValue> versions = new ArrayList<SchemaRegistryValue>();
        try (CloseableIterator<SchemaRegistryValue> iter = this.allVersions(keyCreator, tenantPrefix + unqualifiedSubjectOrPrefix, isPrefix);){
            while (iter.hasNext()) {
                versions.add((SchemaRegistryValue)iter.next());
            }
        }
        ArrayList<ContextValue> contexts = new ArrayList<ContextValue>();
        try (CloseableIterator<SchemaRegistryValue> iter = this.allContexts();){
            while (iter.hasNext()) {
                contexts.add((ContextValue)iter.next());
            }
        }
        for (ContextValue v : contexts) {
            QualifiedSubject qualSub = new QualifiedSubject(v.getTenant(), v.getContext(), unqualifiedSubjectOrPrefix);
            CloseableIterator<SchemaRegistryValue> subiter = this.allVersions(keyCreator, qualSub.toQualifiedSubject(), isPrefix);
            try {
                while (subiter.hasNext()) {
                    versions.add((SchemaRegistryValue)subiter.next());
                }
            }
            finally {
                if (subiter == null) continue;
                subiter.close();
            }
        }
        return new DelegatingIterator<SchemaRegistryValue>(versions.iterator());
    }

    private CloseableIterator<SchemaRegistryValue> allVersions(BiFunction<String, Integer, SchemaRegistryKey> keyCreator, String subjectOrPrefix, boolean isPrefix) throws SchemaRegistryException {
        try {
            Object end;
            Object start;
            int idx = subjectOrPrefix.indexOf(":*:");
            if (idx >= 0) {
                String tenantPrefix = subjectOrPrefix.substring(0, idx);
                String unqualifiedSubjectOrPrefix = subjectOrPrefix.substring(idx + ":*:".length());
                if (!unqualifiedSubjectOrPrefix.isEmpty()) {
                    return this.allVersionsFromAllContexts(keyCreator, tenantPrefix, unqualifiedSubjectOrPrefix, isPrefix);
                }
                start = tenantPrefix + ":.:";
                end = tenantPrefix + ":.\uffff:";
            } else {
                start = subjectOrPrefix;
                end = isPrefix ? subjectOrPrefix + "\uffff" : subjectOrPrefix;
            }
            SchemaRegistryKey key1 = keyCreator.apply((String)start, 1);
            SchemaRegistryKey key2 = keyCreator.apply((String)end, Integer.MAX_VALUE);
            return FilteredIterator.filter(TransformedIterator.transform(this.store.getAll(key1, key2), v -> {
                if (v instanceof SchemaValue) {
                    try {
                        this.metadataEncoder.decodeMetadata((SchemaValue)v);
                    }
                    catch (SchemaRegistryStoreException e) {
                        log.error("Failed to decode metadata for schema id {}", (Object)((SchemaValue)v).getId(), (Object)e);
                        return null;
                    }
                }
                return v;
            }), Objects::nonNull);
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error from the backend Kafka store", e);
        }
    }

    private CloseableIterator<SchemaRegistryValue> allVersions(String subjectOrPrefix, boolean isPrefix) throws SchemaRegistryException {
        return this.allVersions(SchemaKey::new, subjectOrPrefix, isPrefix);
    }

    private static boolean shouldInclude(boolean isDeleted, LookupFilter filter) {
        return switch (filter) {
            default -> throw new IncompatibleClassChangeError();
            case LookupFilter.DEFAULT -> {
                if (!isDeleted) {
                    yield true;
                }
                yield false;
            }
            case LookupFilter.INCLUDE_DELETED -> true;
            case LookupFilter.DELETED_ONLY -> isDeleted;
        };
    }

    private List<SchemaKey> schemaKeysByVersion(CloseableIterator<SchemaRegistryValue> schemas, LookupFilter filter) {
        ArrayList<SchemaKey> schemaList = new ArrayList<SchemaKey>();
        while (schemas.hasNext()) {
            SchemaValue schemaValue = (SchemaValue)schemas.next();
            boolean shouldInclude = AbstractSchemaRegistry.shouldInclude(schemaValue.isDeleted(), filter);
            if (!shouldInclude) continue;
            SchemaKey schemaKey = schemaValue.toKey();
            schemaList.add(schemaKey);
        }
        return schemaList;
    }

    protected List<SchemaKey> getAllSchemaKeysDescending(String subject) throws SchemaRegistryException {
        try (CloseableIterator<SchemaRegistryValue> allVersions = this.allVersions(subject, false);){
            List<SchemaKey> schemaKeys = this.schemaKeysByVersion(allVersions, LookupFilter.INCLUDE_DELETED);
            schemaKeys.sort(Collections.reverseOrder());
            List<SchemaKey> list = schemaKeys;
            return list;
        }
    }

    protected Schema lookUpSchemaUnderSubject(Config config, String subject, Schema schema, boolean normalize, boolean lookupDeletedSchema, boolean lookupLatestOnly) throws SchemaRegistryException {
        try {
            SchemaIdAndSubjects schemaIdAndSubjects;
            Schema newSchema = schema != null ? schema.copy() : null;
            ParsedSchema parsedSchema = this.canonicalizeSchema(newSchema, config, false, normalize);
            if (parsedSchema != null && !lookupLatestOnly && (schemaIdAndSubjects = this.lookupCache.schemaIdAndSubjects(newSchema)) != null && schemaIdAndSubjects.hasSubject(subject) && (lookupDeletedSchema || !this.isSubjectVersionDeleted(subject, schemaIdAndSubjects.getVersion(subject)))) {
                Schema matchingSchema = newSchema.copy();
                matchingSchema.setSubject(subject);
                matchingSchema.setVersion(Integer.valueOf(schemaIdAndSubjects.getVersion(subject)));
                matchingSchema.setId(Integer.valueOf(schemaIdAndSubjects.getSchemaId()));
                return matchingSchema;
            }
            if (lookupLatestOnly) {
                Schema prev = this.getLatestVersion(subject);
                if (prev != null && parsedSchema != null && parsedSchema.canLookup(this.parseSchema(prev), (SchemaVersionFetcher)this)) {
                    return prev;
                }
            } else {
                List<SchemaKey> allVersions = this.getAllSchemaKeysDescending(subject);
                for (SchemaKey schemaKey : allVersions) {
                    Schema prev = this.get(schemaKey.getSubject(), schemaKey.getVersion(), lookupDeletedSchema);
                    if (prev == null || parsedSchema == null || !parsedSchema.canLookup(this.parseSchema(prev), (SchemaVersionFetcher)this)) continue;
                    return prev;
                }
            }
            return null;
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error from the backend Kafka store", e);
        }
    }

    @Override
    public Schema lookUpSchemaUnderSubject(String subject, Schema schema, boolean normalize, boolean lookupDeletedSchema) throws SchemaRegistryException {
        if (schema == null) {
            return null;
        }
        Config config = this.getConfigInScope(subject);
        Schema existingSchema = this.lookUpSchemaUnderSubject(config, subject, schema, normalize, lookupDeletedSchema, false);
        if (existingSchema != null) {
            return existingSchema;
        }
        Schema prev = this.getLatestVersion(subject);
        if (prev == null) {
            return null;
        }
        Schema next = schema.copy();
        this.maybeSetMetadataRuleSet(config, next, prev, null);
        if (next.equals((Object)schema)) {
            return null;
        }
        return this.lookUpSchemaUnderSubject(config, subject, next, normalize, lookupDeletedSchema, false);
    }

    public void checkIfSchemaWithIdExist(int id, Schema schema) throws SchemaRegistryException, StoreException {
        SchemaRegistryValue existingValue;
        String qctx = QualifiedSubject.qualifiedContextFor((String)this.tenant(), (String)schema.getSubject());
        SchemaKey existingKey = this.lookupCache.schemaKeyById(id, qctx);
        if (existingKey != null && (existingValue = (SchemaRegistryValue)this.lookupCache.get(existingKey)) instanceof SchemaValue) {
            SchemaValue existingSchemaValue = (SchemaValue)existingValue;
            Schema existingSchema = this.toSchemaEntity(existingSchemaValue);
            Schema schemaCopy = schema.copy();
            schemaCopy.setId(existingSchema.getId());
            schemaCopy.setSubject(existingSchema.getSubject());
            schemaCopy.setVersion(existingSchema.getVersion());
            if (!existingSchema.equals((Object)schemaCopy)) {
                String context = QualifiedSubject.qualifiedContextFor((String)this.tenant(), (String)schema.getSubject());
                throw new OperationNotPermittedException(String.format("Overwrite new schema with id %s in context %s is not permitted.", id, context));
            }
        }
    }

    protected CloseableIterator<SchemaRegistryValue> allContexts() throws SchemaRegistryException {
        try {
            ContextKey key1 = new ContextKey(this.tenant(), String.valueOf('\u0000'));
            ContextKey key2 = new ContextKey(this.tenant(), String.valueOf('\uffff'));
            return this.lookupCache.getAll(key1, key2);
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error from the backend Kafka store", e);
        }
    }

    SchemaKey getSchemaKeyUsingContexts(int id, String subject) throws StoreException, SchemaRegistryException {
        QualifiedSubject qs = QualifiedSubject.create((String)this.tenant(), (String)subject);
        boolean isQualifiedSubject = qs != null && !".".equals(qs.getContext());
        SchemaKey subjectVersionKey = this.lookupCache.schemaKeyById(id, subject);
        if (qs == null || qs.getSubject().isEmpty() || isQualifiedSubject || subjectVersionKey != null) {
            return subjectVersionKey;
        }
        try (CloseableIterator<SchemaRegistryValue> iter = this.allContexts();){
            while (iter.hasNext()) {
                ContextValue v = (ContextValue)iter.next();
                QualifiedSubject qualSub = new QualifiedSubject(v.getTenant(), v.getContext(), qs.getSubject());
                SchemaKey key = this.lookupCache.schemaKeyById(id, qualSub.toQualifiedSubject());
                if (key == null) continue;
                SchemaKey schemaKey = key;
                return schemaKey;
            }
        }
        return this.lookupCache.schemaKeyById(id, qs.toQualifiedContext());
    }

    private Map.Entry<Integer, String> getIdUsingContexts(String guid) throws StoreException, SchemaRegistryException {
        Integer id = this.lookupCache.idByGuid(guid, ".");
        if (id != null) {
            return new AbstractMap.SimpleEntry<Integer, String>(id, ".");
        }
        try (CloseableIterator<SchemaRegistryValue> iter = this.allContexts();){
            while (iter.hasNext()) {
                ContextValue v = (ContextValue)iter.next();
                QualifiedSubject qualSub = new QualifiedSubject(v.getTenant(), v.getContext(), null);
                String ctx = qualSub.toQualifiedContext();
                id = this.lookupCache.idByGuid(guid, ctx);
                if (id == null) continue;
                AbstractMap.SimpleEntry<Integer, String> simpleEntry = new AbstractMap.SimpleEntry<Integer, String>(id, ctx);
                return simpleEntry;
            }
        }
        return null;
    }

    private Set<String> extractUniqueSubjects(Iterator<SchemaRegistryValue> allVersions, LookupFilter filter) {
        HashMap<String, Boolean> subjects = new HashMap<String, Boolean>();
        while (allVersions.hasNext()) {
            SchemaValue value = (SchemaValue)allVersions.next();
            subjects.merge(value.getSubject(), value.isDeleted(), (v1, v2) -> v1 != false && v2 != false);
        }
        return subjects.keySet().stream().filter(k -> AbstractSchemaRegistry.shouldInclude((Boolean)subjects.get(k), filter)).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public List<SubjectVersion> listVersionsForId(int id, String subject) throws SchemaRegistryException {
        return this.listVersionsForId(id, subject, false);
    }

    @Override
    public List<SubjectVersion> listVersionsForId(int id, String subject, boolean lookupDeleted) throws SchemaRegistryException {
        try {
            SchemaKey subjectVersionKey = this.getSchemaKeyUsingContexts(id, subject);
            if (subjectVersionKey == null) {
                return null;
            }
            SchemaValue schema = (SchemaValue)this.store.get(subjectVersionKey);
            if (schema == null) {
                return null;
            }
            Schema schemaEntity = this.toSchemaEntity(schema);
            this.logSchemaOp(schemaEntity, "READ");
            SchemaIdAndSubjects schemaIdAndSubjects = this.lookupCache.schemaIdAndSubjects(schemaEntity);
            if (schemaIdAndSubjects == null) {
                return null;
            }
            return schemaIdAndSubjects.allSubjectVersions().entrySet().stream().flatMap(e -> {
                try {
                    SchemaValue schemaValue = (SchemaValue)this.store.get(new SchemaKey((String)e.getKey(), (Integer)e.getValue()));
                    if (schemaValue != null && (!schemaValue.isDeleted() || lookupDeleted)) {
                        return Stream.of(new SubjectVersion((String)e.getKey(), (Integer)e.getValue()));
                    }
                    return Stream.empty();
                }
                catch (StoreException ex) {
                    return Stream.empty();
                }
            }).collect(Collectors.toList());
        }
        catch (StoreException e2) {
            throw new SchemaRegistryStoreException("Error while retrieving schema with id " + id + " from the backend Kafka store", e2);
        }
    }

    private CloseableIterator<SchemaRegistryValue> allConfigs(String subjectOrPrefix, boolean isPrefix) throws SchemaRegistryException {
        return this.allVersions((s, v) -> new ConfigKey((String)s), subjectOrPrefix, isPrefix);
    }

    private Map<String, List<String>> getAliases(String subjectPrefix) throws SchemaRegistryException {
        try (CloseableIterator<SchemaRegistryValue> iter = this.allConfigs(subjectPrefix, true);){
            HashMap<String, List<String>> subjectToAliases = new HashMap<String, List<String>>();
            while (iter.hasNext()) {
                ConfigValue configValue = (ConfigValue)iter.next();
                String alias = configValue.getAlias();
                if (alias == null) continue;
                QualifiedSubject qualAlias = QualifiedSubject.qualifySubjectWithParent((String)this.tenant(), (String)configValue.getSubject(), (String)alias, (boolean)true);
                List aliases = subjectToAliases.computeIfAbsent(qualAlias.toQualifiedSubject(), k -> new ArrayList());
                aliases.add(configValue.getSubject());
            }
            HashMap<String, List<String>> hashMap = subjectToAliases;
            return hashMap;
        }
    }

    private Map<String, List<ExtendedSchema>> schemasByVersion(Map<String, List<String>> subjectByAliases, CloseableIterator<SchemaRegistryValue> schemas, LookupFilter filter, boolean returnLatestOnly, Predicate<Schema> postFilter) {
        HashMap<String, List<ExtendedSchema>> schemaMap = new HashMap<String, List<ExtendedSchema>>();
        ExtendedSchema previousSchema = null;
        while (schemas.hasNext()) {
            Schema schemaEntity;
            SchemaValue schemaValue = (SchemaValue)schemas.next();
            boolean bl = AbstractSchemaRegistry.shouldInclude(schemaValue.isDeleted(), filter);
            if (!bl) continue;
            try {
                schemaEntity = this.toSchemaEntity(schemaValue);
            }
            catch (SchemaRegistryStoreException e) {
                log.error("Failed to decode metadata for schema id {}", (Object)schemaValue.getId(), (Object)e);
                continue;
            }
            List<String> aliases = subjectByAliases.get(schemaValue.getSubject());
            ExtendedSchema schema = new ExtendedSchema(schemaEntity, aliases);
            List schemaList = schemaMap.computeIfAbsent(schemaValue.getSubject(), k -> new ArrayList());
            if (returnLatestOnly) {
                if (previousSchema != null && !schema.getSubject().equals(previousSchema.getSubject())) {
                    schemaList.add(previousSchema);
                }
            } else {
                schemaList.add(schema);
            }
            previousSchema = schema;
        }
        if (returnLatestOnly && previousSchema != null) {
            List schemaList = schemaMap.computeIfAbsent(previousSchema.getSubject(), k -> new ArrayList());
            schemaList.add(previousSchema);
        }
        if (postFilter != null) {
            for (Map.Entry entry : schemaMap.entrySet()) {
                List schemaList = (List)entry.getValue();
                schemaList = schemaList.stream().filter(postFilter).collect(Collectors.toList());
                entry.setValue(schemaList);
            }
        }
        return schemaMap;
    }

    public Iterator<ExtendedSchema> allVersionsIncludingAliasesWithSubjectPrefix(String prefix, LookupFilter filter, boolean returnLatestOnly, Predicate<Schema> postFilter) throws SchemaRegistryException {
        Map<String, List<String>> aliases = this.getAliases(prefix);
        try (CloseableIterator<SchemaRegistryValue> allVersions = this.allVersions(prefix, true);){
            Map<String, List<ExtendedSchema>> schemas = this.schemasByVersion(aliases, allVersions, filter, returnLatestOnly, postFilter);
            ArrayList<ExtendedSchema> result = new ArrayList<ExtendedSchema>();
            for (List<ExtendedSchema> list : schemas.values()) {
                result.addAll(list);
            }
            for (Map.Entry entry : aliases.entrySet()) {
                String subject = (String)entry.getKey();
                if (schemas.containsKey(subject)) continue;
                CloseableIterator<SchemaRegistryValue> subVersions = this.allVersions(subject, false);
                try {
                    Map<String, List<ExtendedSchema>> subSchemas = this.schemasByVersion(aliases, subVersions, filter, returnLatestOnly, postFilter);
                    for (List<ExtendedSchema> schemaList : subSchemas.values()) {
                        result.addAll(schemaList);
                    }
                }
                finally {
                    if (subVersions == null) continue;
                    subVersions.close();
                }
            }
            Collections.sort(result);
            Iterator<Object> iterator = result.iterator();
            return iterator;
        }
    }

    private Iterator<ExtendedSchema> allVersionsWithSubjectPrefix(String prefix, LookupFilter filter, boolean returnLatestOnly, Predicate<Schema> postFilter) throws SchemaRegistryException {
        try (CloseableIterator<SchemaRegistryValue> allVersions = this.allVersions(prefix, true);){
            Map<String, List<ExtendedSchema>> schemas = this.schemasByVersion(Collections.emptyMap(), allVersions, filter, returnLatestOnly, postFilter);
            ArrayList<ExtendedSchema> result = new ArrayList<ExtendedSchema>();
            for (List<ExtendedSchema> schemaList : schemas.values()) {
                result.addAll(schemaList);
            }
            Collections.sort(result);
            Iterator<List<Object>> iterator = result.iterator();
            return iterator;
        }
    }

    private Schema getLatestVersionFromSubjectSchemas(CloseableIterator<SchemaRegistryValue> schemas) throws SchemaRegistryException {
        int latestVersionId = -1;
        SchemaValue latestSchemaValue = null;
        while (schemas.hasNext()) {
            SchemaValue schemaValue = (SchemaValue)schemas.next();
            if (schemaValue.isDeleted() || schemaValue.getVersion() <= latestVersionId) continue;
            latestVersionId = schemaValue.getVersion();
            latestSchemaValue = schemaValue;
        }
        return latestSchemaValue != null ? this.toSchemaEntity(latestSchemaValue) : null;
    }

    private List<String> validateReservedFields(ParsedSchema currentSchema, ParsedSchemaHolder previousSchema) {
        Sets.SetView removedFields;
        ArrayList<String> errorMessages = new ArrayList<String>();
        Set updatedReservedFields = currentSchema.getReservedFields();
        if (previousSchema != null && !(removedFields = Sets.difference((Set)previousSchema.schema().getReservedFields(), (Set)updatedReservedFields)).isEmpty()) {
            removedFields.forEach(field -> errorMessages.add(String.format("The new schema has reserved field %s removed from its metadata which is present in the old schema's metadata.", field)));
        }
        updatedReservedFields.forEach(reservedField -> {
            if (currentSchema.hasTopLevelField(reservedField)) {
                errorMessages.add(String.format("The new schema has field that conflicts with the reserved field %s.", reservedField));
            }
        });
        return errorMessages;
    }

    private static String getCompatibilityGroupValue(ParsedSchema parsedSchema, String compatibilityGroup) {
        if (parsedSchema.metadata() != null && parsedSchema.metadata().getProperties() != null) {
            return (String)parsedSchema.metadata().getProperties().get(compatibilityGroup);
        }
        return null;
    }

    protected List<String> isCompatibleWithPrevious(Config config, ParsedSchema parsedSchema, List<ParsedSchemaHolder> previousSchemas) {
        ParsedSchemaHolder previousSchemaHolder;
        ArrayList<String> errorMessages = new ArrayList<String>();
        ParsedSchemaHolder parsedSchemaHolder = previousSchemaHolder = !previousSchemas.isEmpty() ? previousSchemas.get(previousSchemas.size() - 1) : null;
        if (this.isSchemaFieldValidationEnabled(config)) {
            errorMessages.addAll(this.validateReservedFields(parsedSchema, previousSchemaHolder));
        }
        CompatibilityLevel compatibility = CompatibilityLevel.forName((String)config.getCompatibilityLevel());
        CompatibilityPolicy compatibilityPolicy = CompatibilityPolicy.forName((String)config.getCompatibilityPolicy());
        String compatibilityGroup = config.getCompatibilityGroup();
        if (compatibilityGroup != null) {
            String groupValue = AbstractSchemaRegistry.getCompatibilityGroupValue(parsedSchema, compatibilityGroup);
            previousSchemas = previousSchemas.stream().filter(s -> Objects.equals(groupValue, AbstractSchemaRegistry.getCompatibilityGroupValue(s.schema(), compatibilityGroup))).collect(Collectors.toList());
        }
        errorMessages.addAll(parsedSchema.isCompatible(compatibility, compatibilityPolicy, previousSchemas));
        if (!errorMessages.isEmpty()) {
            try {
                errorMessages.add(String.format("{validateFields: '%b', compatibility: '%s'}", this.isSchemaFieldValidationEnabled(config), compatibility));
            }
            catch (UnsupportedOperationException e) {
                log.warn("Failed to append 'compatibility' to error messages");
            }
        }
        return errorMessages;
    }

    public void removeCustomHandler(Handler.Singleton handler) {
        this.customHandler.remove(handler);
    }

    public int normalizeLimit(int suppliedLimit, int defaultLimit, int maxLimit) {
        int limit = defaultLimit;
        if (suppliedLimit > 0 && suppliedLimit <= maxLimit) {
            limit = suppliedLimit;
        }
        return limit;
    }

    @Override
    public void clearNewSchemaCache() {
        this.newSchemaCache.invalidateAll();
    }

    @Override
    public void clearOldSchemaCache() {
        this.oldSchemaCache.invalidateAll();
    }

    @Override
    public void invalidateFromNewSchemaCache(Schema schemaKey) {
        this.newSchemaCache.invalidate((Object)new RawSchema(schemaKey, true, false));
        this.newSchemaCache.invalidate((Object)new RawSchema(schemaKey, true, true));
    }

    protected void invalidateFromOldSchemaCache(Schema schemaKey) {
        this.oldSchemaCache.invalidate((Object)new RawSchema(schemaKey, false, false));
        this.oldSchemaCache.invalidate((Object)new RawSchema(schemaKey, false, true));
    }

    @Override
    public int normalizeSchemaLimit(int suppliedLimit) {
        return this.normalizeLimit(suppliedLimit, this.schemaSearchDefaultLimit, this.schemaSearchMaxLimit);
    }

    @Override
    public int normalizeSubjectLimit(int suppliedLimit) {
        return this.normalizeLimit(suppliedLimit, this.subjectSearchDefaultLimit, this.subjectSearchMaxLimit);
    }

    @Override
    public int normalizeContextLimit(int suppliedLimit) {
        return this.normalizeLimit(suppliedLimit, this.contextSearchDefaultLimit, this.contextSearchMaxLimit);
    }

    @Override
    public int normalizeSubjectVersionLimit(int suppliedLimit) {
        return this.normalizeLimit(suppliedLimit, this.subjectVersionSearchDefaultLimit, this.subjectVersionSearchMaxLimit);
    }

    @Override
    public HostnameVerifier getHostnameVerifier() throws SchemaRegistryStoreException {
        String sslEndpointIdentificationAlgo = this.config.getString("ssl.endpoint.identification.algorithm");
        if (sslEndpointIdentificationAlgo == null || sslEndpointIdentificationAlgo.equals("none") || sslEndpointIdentificationAlgo.isEmpty()) {
            return (hostname, session) -> true;
        }
        if (sslEndpointIdentificationAlgo.equalsIgnoreCase("https")) {
            return null;
        }
        throw new SchemaRegistryStoreException("ssl.endpoint.identification.algorithm " + sslEndpointIdentificationAlgo + " not supported");
    }

    @Override
    public SchemaString get(int id, String subject) throws SchemaRegistryException {
        return this.get(id, subject, null, false);
    }

    @Override
    public Schema get(String subject, int version, boolean returnDeletedSchema) throws SchemaRegistryException {
        VersionId versionId = new VersionId(version);
        if (versionId.isLatest()) {
            return this.getLatestVersion(subject);
        }
        SchemaValue schemaValue = this.getSchemaValue(new SchemaKey(subject, version));
        Schema schema = null;
        if (schemaValue != null && (!schemaValue.isDeleted() || returnDeletedSchema)) {
            schema = this.toSchemaEntity(schemaValue);
        }
        return schema;
    }

    @Override
    public void setMode(String subject, ModeUpdateRequest mode) throws SchemaRegistryException {
        this.setMode(subject, mode, false);
    }

    @Override
    public Mode getModeInScope(String subject) throws SchemaRegistryStoreException {
        try {
            Mode globalMode = this.lookupCache.mode(null, true, this.defaultMode);
            Mode subjectMode = this.lookupCache.mode(subject, true, this.defaultMode);
            return globalMode == Mode.READONLY_OVERRIDE ? globalMode : subjectMode;
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Failed to write new config value to the store", e);
        }
    }

    @Override
    public Mode getMode(String subject) throws SchemaRegistryStoreException {
        try {
            Mode globalMode = this.lookupCache.mode(null, false, this.defaultMode);
            Mode subjectMode = this.lookupCache.mode(subject, false, this.defaultMode);
            return globalMode == Mode.READONLY_OVERRIDE ? globalMode : subjectMode;
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Failed to write new config value to the store", e);
        }
    }

    @Override
    public List<String> isCompatible(String subject, Schema newSchema, List<SchemaKey> previousSchemas, boolean normalize) throws SchemaRegistryException {
        if (previousSchemas == null) {
            log.error("Previous schema not provided");
            throw new InvalidSchemaException("Previous schema not provided");
        }
        try {
            boolean doValidation;
            ArrayList<ParsedSchemaHolder> prevParsedSchemas = new ArrayList<ParsedSchemaHolder>(previousSchemas.size());
            for (SchemaKey previousSchema : previousSchemas) {
                prevParsedSchemas.add(new LazyParsedSchemaHolder(this, previousSchema));
            }
            Config config = this.getConfigInScope(subject);
            ParsedSchema parsedSchema = this.canonicalizeSchema(newSchema, config, doValidation = this.isSchemaNameValidationEnabled(config), normalize);
            if (parsedSchema == null) {
                log.error("Empty schema");
                throw new InvalidSchemaException("Empty schema");
            }
            return this.isCompatibleWithPrevious(config, parsedSchema, prevParsedSchemas);
        }
        catch (IllegalStateException e) {
            if (e.getCause() instanceof SchemaRegistryException) {
                throw (SchemaRegistryException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public Config getConfigInScope(String subject) throws SchemaRegistryStoreException {
        try {
            return this.lookupCache.config(subject, true, new Config(this.defaultCompatibilityLevel.name));
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Failed to write new config value to the store", e);
        }
    }

    @Override
    public Config getConfig(String subject) throws SchemaRegistryStoreException {
        try {
            return this.lookupCache.config(subject, false, new Config(this.defaultCompatibilityLevel.name));
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Failed to write new config value to the store", e);
        }
    }

    @Override
    public Schema getLatestVersion(String subject) throws SchemaRegistryException {
        try (CloseableIterator<SchemaRegistryValue> allVersions = this.allVersions(subject, false);){
            Schema schema = this.getLatestVersionFromSubjectSchemas(allVersions);
            return schema;
        }
    }

    @Override
    public Iterator<ExtendedSchema> getVersionsWithSubjectPrefix(String prefix, boolean includeAliases, LookupFilter filter, boolean returnLatestOnly, Predicate<Schema> postFilter) throws SchemaRegistryException {
        if (includeAliases) {
            return this.allVersionsIncludingAliasesWithSubjectPrefix(prefix, filter, returnLatestOnly, postFilter);
        }
        return this.allVersionsWithSubjectPrefix(prefix, filter, returnLatestOnly, postFilter);
    }

    @Override
    public Iterator<SchemaKey> getAllVersions(String subject, LookupFilter filter) throws SchemaRegistryException {
        try (CloseableIterator<SchemaRegistryValue> allVersions = this.allVersions(subject, false);){
            List<SchemaKey> schemaKeys = this.schemaKeysByVersion(allVersions, filter);
            Collections.sort(schemaKeys);
            Iterator<SchemaKey> iterator = schemaKeys.iterator();
            return iterator;
        }
    }

    @Override
    public boolean hasSubjects(String subject, boolean lookupDeletedSubjects) throws SchemaRegistryStoreException {
        try {
            return this.lookupCache.hasSubjects(subject, lookupDeletedSubjects);
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error from the backend Kafka store", e);
        }
    }

    @Override
    public Set<String> subjects(String subject, boolean lookupDeletedSubjects) throws SchemaRegistryStoreException {
        try {
            return this.lookupCache.subjects(subject, lookupDeletedSubjects);
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error from the backend Kafka store", e);
        }
    }

    @Override
    public Set<String> listSubjectsForId(int id, String subject, boolean returnDeleted) throws SchemaRegistryException {
        List<SubjectVersion> versions = this.listVersionsForId(id, subject, returnDeleted);
        return versions != null ? (Set)versions.stream().map(SubjectVersion::getSubject).collect(Collectors.toCollection(LinkedHashSet::new)) : null;
    }

    @Override
    public Set<String> listSubjectsForId(int id, String subject) throws SchemaRegistryException {
        return this.listSubjectsForId(id, subject, false);
    }

    @Override
    public List<String> listContexts() throws SchemaRegistryException {
        ArrayList<String> contexts = new ArrayList<String>();
        contexts.add(".");
        try (CloseableIterator<SchemaRegistryValue> iter = this.allContexts();){
            while (iter.hasNext()) {
                ContextValue contextValue = (ContextValue)iter.next();
                contexts.add(contextValue.getContext());
            }
        }
        return contexts;
    }

    @Override
    public Set<String> listSubjectsWithPrefix(String prefix, LookupFilter filter) throws SchemaRegistryException {
        try (CloseableIterator<SchemaRegistryValue> allVersions = this.allVersions(prefix, true);){
            Set<String> set = this.extractUniqueSubjects(allVersions, filter);
            return set;
        }
    }

    @Override
    public Set<String> listSubjects(LookupFilter filter) throws SchemaRegistryException {
        return this.listSubjectsWithPrefix(":*:", filter);
    }

    @Override
    public List<Integer> getReferencedBy(String subject, VersionId versionId) throws SchemaRegistryException {
        try {
            int version = versionId.getVersionId();
            if (versionId.isLatest()) {
                version = this.getLatestVersion(subject).getVersion();
            }
            SchemaKey key = new SchemaKey(subject, version);
            ArrayList<Integer> ids = new ArrayList<Integer>(this.lookupCache.referencesSchema(key));
            Collections.sort(ids);
            return ids;
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error from the backend Kafka store", e);
        }
    }

    @Override
    public List<ContextId> listIdsForGuid(String guid) throws SchemaRegistryException {
        try {
            ArrayList<ContextId> ids = new ArrayList<ContextId>();
            Integer id = this.lookupCache.idByGuid(guid, ".");
            if (id != null) {
                ids.add(new ContextId(".", id));
            }
            try (CloseableIterator<SchemaRegistryValue> iter = this.allContexts();){
                while (iter.hasNext()) {
                    ContextValue v = (ContextValue)iter.next();
                    QualifiedSubject qualSub = new QualifiedSubject(v.getTenant(), v.getContext(), null);
                    String ctx = qualSub.toQualifiedContext();
                    id = this.lookupCache.idByGuid(guid, ctx);
                    if (id == null) continue;
                    ids.add(new ContextId(qualSub.getContext(), id));
                }
            }
            Collections.sort(ids);
            return ids;
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error while retrieving schema with guid " + guid + " from the backend Kafka store", e);
        }
    }

    @Override
    public SchemaString getByGuid(String guid, String format) throws SchemaRegistryException {
        try {
            Map.Entry<Integer, String> id = this.getIdUsingContexts(guid);
            if (id == null) {
                return null;
            }
            SchemaString schema = this.get(id.getKey(), id.getValue(), format, false);
            schema.setSubject(null);
            schema.setVersion(null);
            return schema;
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error while retrieving schema with guid " + guid + " from the backend Kafka store", e);
        }
    }

    @Override
    public SchemaValue getSchemaValue(SchemaKey key) throws SchemaRegistryException {
        try {
            return (SchemaValue)this.store.get(key);
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error while retrieving schema from the backend Kafka store", e);
        }
    }

    @Override
    public Schema toSchemaEntity(SchemaValue schemaValue) throws SchemaRegistryStoreException {
        this.metadataEncoder.decodeMetadata(schemaValue);
        return schemaValue.toSchemaEntity();
    }

    @Override
    public boolean schemaVersionExists(String subject, VersionId versionId, boolean returnDeletedSchema) throws SchemaRegistryException {
        int version = versionId.getVersionId();
        Schema schema = this.get(subject, version, returnDeletedSchema);
        return schema != null;
    }

    @Override
    public Schema getUsingContexts(String subject, int version, boolean returnDeletedSchema) throws SchemaRegistryException {
        boolean isQualifiedSubject;
        Schema schema = this.get(subject, version, returnDeletedSchema);
        if (schema != null) {
            this.logSchemaOp(schema, "READ");
            return schema;
        }
        QualifiedSubject qs = QualifiedSubject.create((String)this.tenant(), (String)subject);
        boolean bl = isQualifiedSubject = qs != null && !".".equals(qs.getContext());
        if (isQualifiedSubject) {
            return null;
        }
        try (CloseableIterator<SchemaRegistryValue> iter = this.allContexts();){
            while (iter.hasNext()) {
                ContextValue v = (ContextValue)iter.next();
                QualifiedSubject qualSub = new QualifiedSubject(v.getTenant(), v.getContext(), qs.getSubject());
                schema = this.get(qualSub.toQualifiedSubject(), version, returnDeletedSchema);
                if (schema == null) continue;
                this.logSchemaOp(schema, "READ");
                Schema schema2 = schema;
                return schema2;
            }
        }
        return null;
    }

    @Override
    public ParsedSchema parseSchema(Schema schema, boolean isNew, boolean normalize) throws InvalidSchemaException {
        try {
            ParsedSchema parsedSchema;
            RawSchema rawSchema = new RawSchema(schema.toHashKey(), isNew, normalize);
            ParsedSchema parsedSchema2 = parsedSchema = isNew ? (ParsedSchema)this.newSchemaCache.get((Object)rawSchema) : (ParsedSchema)this.oldSchemaCache.get((Object)rawSchema);
            if (schema.getVersion() != null) {
                parsedSchema = parsedSchema.copy(schema.getVersion());
            }
            return parsedSchema;
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof InvalidSchemaException) {
                throw (InvalidSchemaException)cause;
            }
            throw new InvalidSchemaException(e);
        }
    }

    @Override
    public ParsedSchema parseSchema(Schema schema) throws InvalidSchemaException {
        return this.parseSchema(schema, false, false);
    }

    @Override
    public void extractSchemaTags(Schema schema, List<String> tags) throws SchemaRegistryException {
        ParsedSchema parsedSchema = this.parseSchema(schema);
        boolean isWildcard = tags.contains("*");
        List schemaTags = parsedSchema.inlineTaggedEntities().entrySet().stream().filter(e -> isWildcard || !Collections.disjoint(tags, (Collection)e.getValue())).map(e -> new SchemaTags((SchemaEntity)e.getKey(), new ArrayList((Collection)e.getValue()))).collect(Collectors.toList());
        schema.setSchemaTags(schemaTags);
    }

    @Override
    public Schema lookUpSchemaUnderSubjectUsingContexts(String subject, Schema schema, boolean normalize, boolean lookupDeletedSchema) throws SchemaRegistryException {
        boolean isQualifiedSubject;
        Schema matchingSchema = this.lookUpSchemaUnderSubject(subject, schema, normalize, lookupDeletedSchema);
        if (matchingSchema != null) {
            this.logSchemaOp(matchingSchema, "READ");
            return matchingSchema;
        }
        QualifiedSubject qs = QualifiedSubject.create((String)this.tenant(), (String)subject);
        boolean bl = isQualifiedSubject = qs != null && !".".equals(qs.getContext());
        if (isQualifiedSubject) {
            return null;
        }
        try (CloseableIterator<SchemaRegistryValue> iter = this.allContexts();){
            while (iter.hasNext()) {
                ContextValue v = (ContextValue)iter.next();
                QualifiedSubject qualSub = new QualifiedSubject(v.getTenant(), v.getContext(), qs.getSubject());
                Schema qualSchema = schema.copy();
                qualSchema.setSubject(qualSub.toQualifiedSubject());
                try {
                    matchingSchema = this.lookUpSchemaUnderSubject(qualSub.toQualifiedSubject(), qualSchema, normalize, lookupDeletedSchema);
                }
                catch (InvalidSchemaException invalidSchemaException) {
                    // empty catch block
                }
                if (matchingSchema == null) continue;
                this.logSchemaOp(matchingSchema, "READ");
                Schema schema2 = matchingSchema;
                return schema2;
            }
        }
        return null;
    }

    @Override
    public Schema getLatestWithMetadata(String subject, Map<String, String> metadata, boolean lookupDeletedSchema) throws SchemaRegistryException {
        List<SchemaKey> allVersions = this.getAllSchemaKeysDescending(subject);
        for (SchemaKey schemaKey : allVersions) {
            SortedMap props;
            Schema schema = this.get(schemaKey.getSubject(), schemaKey.getVersion(), lookupDeletedSchema);
            if (schema == null) continue;
            this.logSchemaOp(schema, "READ");
            if (schema.getMetadata() == null || (props = schema.getMetadata().getProperties()) == null || !props.entrySet().containsAll(metadata.entrySet())) continue;
            return schema;
        }
        return null;
    }

    @Override
    public LookupCache<SchemaRegistryKey, SchemaRegistryValue> getLookupCache() {
        return this.lookupCache;
    }

    @Override
    public Set<String> schemaTypes() {
        return this.providers.keySet();
    }

    @Override
    public SchemaRegistryConfig config() {
        return this.config;
    }

    @Override
    public Map<String, Object> properties() {
        return this.props;
    }

    @Override
    public MetadataEncoderService getMetadataEncoder() {
        return this.metadataEncoder;
    }

    @Override
    public void addUpdateRequestHandler(UpdateRequestHandler updateRequestHandler) {
        this.updateRequestHandlers.add(updateRequestHandler);
    }

    @Override
    public UpdateRequestHandler getCompositeUpdateRequestHandler() {
        ArrayList<UpdateRequestHandler> handlers = new ArrayList<UpdateRequestHandler>();
        handlers.add(this.ruleSetHandler);
        handlers.addAll(this.updateRequestHandlers);
        return new CompositeUpdateRequestHandler(handlers);
    }

    @Override
    public List<Handler.Singleton> getCustomHandler() {
        return this.customHandler;
    }

    @Override
    public void addCustomHandler(Handler.Singleton handler) {
        this.customHandler.add(handler);
    }

    @Override
    public MetricsContainer getMetricsContainer() {
        return this.metricsContainer;
    }

    @Override
    public List<SchemaRegistryResourceExtension> getResourceExtensions() {
        return this.resourceExtensions;
    }

    @Override
    public SchemaProvider schemaProvider(String schemaType) {
        return this.providers.get(schemaType);
    }

    @Override
    public RuleSetHandler getRuleSetHandler() {
        return this.ruleSetHandler;
    }

    @Override
    public void setRuleSetHandler(RuleSetHandler ruleSetHandler) {
        this.ruleSetHandler = ruleSetHandler;
    }

    @Override
    public SslFactory getSslFactory() {
        return this.sslFactory;
    }

    public void onKeystoreCreated(KeyStore keystore) {
        this.metricsContainer.emitCertificateExpirationMetric(keystore, this.metricsContainer.getCertificateExpirationKeystore());
    }

    public void onTruststoreCreated(KeyStore truststore) {
        this.metricsContainer.emitCertificateExpirationMetric(truststore, this.metricsContainer.getCertificateExpirationTruststore());
    }

    protected static class RawSchema {
        private final Schema schema;
        private final boolean isNew;
        private final boolean normalize;

        public RawSchema(Schema schema, boolean isNew, boolean normalize) {
            this.schema = schema;
            this.isNew = isNew;
            this.normalize = normalize;
        }

        public Schema getSchema() {
            return this.schema;
        }

        public boolean isNew() {
            return this.isNew;
        }

        public boolean isNormalize() {
            return this.normalize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RawSchema that = (RawSchema)o;
            return this.isNew == that.isNew && this.normalize == that.normalize && Objects.equals(this.schema, that.schema);
        }

        public int hashCode() {
            return Objects.hash(this.schema, this.isNew, this.normalize);
        }

        public String toString() {
            return "RawSchema{schema=" + String.valueOf(this.schema) + ", isNew=" + this.isNew + ", normalize=" + this.normalize + "}";
        }
    }

    public static class SchemeAndPort {
        public int port;
        public String scheme;

        public SchemeAndPort(String scheme, int port) {
            this.port = port;
            this.scheme = scheme;
        }
    }
}

