/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaVersionFetcher;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.Config;
import io.confluent.kafka.schemaregistry.client.rest.entities.ContextId;
import io.confluent.kafka.schemaregistry.client.rest.entities.ExtendedSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.SubjectVersion;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ModeUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.TagSchemaRequest;
import io.confluent.kafka.schemaregistry.client.security.SslFactory;
import io.confluent.kafka.schemaregistry.exceptions.IdGenerationException;
import io.confluent.kafka.schemaregistry.exceptions.InvalidSchemaException;
import io.confluent.kafka.schemaregistry.exceptions.OperationNotPermittedException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryRequestForwardingException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryStoreException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryTimeoutException;
import io.confluent.kafka.schemaregistry.exceptions.UnknownLeaderException;
import io.confluent.kafka.schemaregistry.metrics.MetricsContainer;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.rest.VersionId;
import io.confluent.kafka.schemaregistry.rest.extensions.SchemaRegistryResourceExtension;
import io.confluent.kafka.schemaregistry.rest.handlers.UpdateRequestHandler;
import io.confluent.kafka.schemaregistry.storage.KafkaStore;
import io.confluent.kafka.schemaregistry.storage.LookupCache;
import io.confluent.kafka.schemaregistry.storage.LookupFilter;
import io.confluent.kafka.schemaregistry.storage.Mode;
import io.confluent.kafka.schemaregistry.storage.RuleSetHandler;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryIdentity;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryValue;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;
import io.confluent.kafka.schemaregistry.storage.encoder.MetadataEncoderService;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.net.ssl.HostnameVerifier;
import org.apache.avro.reflect.Nullable;
import org.eclipse.jetty.server.Handler;

public interface SchemaRegistry
extends SchemaVersionFetcher {
    public static final int MIN_VERSION = 1;
    public static final int MAX_VERSION = Integer.MAX_VALUE;
    public static final String DEFAULT_TENANT = "default";
    public static final String RESERVED_FIELD_REMOVED = "The new schema has reserved field %s removed from its metadata which is present in the old schema's metadata.";
    public static final String FIELD_CONFLICTS_WITH_RESERVED_FIELD = "The new schema has field that conflicts with the reserved field %s.";

    public void init() throws SchemaRegistryException;

    public Set<String> schemaTypes();

    default public Schema register(String subject, Schema schema) throws SchemaRegistryException {
        return this.register(subject, schema, false);
    }

    default public Schema register(String subject, Schema schema, boolean normalize) throws SchemaRegistryException {
        return this.register(subject, schema, normalize, false);
    }

    public Schema register(String var1, Schema var2, boolean var3, boolean var4) throws SchemaRegistryException;

    default public Schema getByVersion(String subject, int version, boolean returnDeletedSchema) {
        try {
            return this.get(subject, version, returnDeletedSchema);
        }
        catch (SchemaRegistryException e) {
            throw new RuntimeException(e);
        }
    }

    public Schema get(String var1, int var2, boolean var3) throws SchemaRegistryException;

    public SchemaString get(int var1, String var2) throws SchemaRegistryException;

    public SchemaString get(int var1, String var2, String var3, boolean var4) throws SchemaRegistryException;

    default public Set<String> listSubjects() throws SchemaRegistryException {
        return this.listSubjects(LookupFilter.DEFAULT);
    }

    public Set<String> listSubjects(LookupFilter var1) throws SchemaRegistryException;

    public Set<String> listSubjectsForId(int var1, String var2) throws SchemaRegistryException;

    public Set<String> listSubjectsForId(int var1, String var2, boolean var3) throws SchemaRegistryException;

    public Iterator<SchemaKey> getAllVersions(String var1, LookupFilter var2) throws SchemaRegistryException;

    public Iterator<ExtendedSchema> getVersionsWithSubjectPrefix(String var1, boolean var2, LookupFilter var3, boolean var4, Predicate<Schema> var5) throws SchemaRegistryException;

    public Schema getLatestVersion(String var1) throws SchemaRegistryException;

    public List<Integer> deleteSubject(String var1, boolean var2) throws SchemaRegistryException;

    public void deleteContext(String var1) throws SchemaRegistryException;

    default public Schema lookUpSchemaUnderSubject(String subject, Schema schema, boolean lookupDeletedSchema) throws SchemaRegistryException {
        return this.lookUpSchemaUnderSubject(subject, schema, false, lookupDeletedSchema);
    }

    public Schema lookUpSchemaUnderSubject(String var1, Schema var2, boolean var3, boolean var4) throws SchemaRegistryException;

    public Schema getLatestWithMetadata(String var1, Map<String, String> var2, boolean var3) throws SchemaRegistryException;

    public List<String> isCompatible(String var1, Schema var2, List<SchemaKey> var3, boolean var4) throws SchemaRegistryException;

    public void close() throws IOException;

    public void deleteSchemaVersion(String var1, Schema var2, boolean var3) throws SchemaRegistryException;

    default public String tenant() {
        return DEFAULT_TENANT;
    }

    default public void setTenant(String tenant) {
    }

    public SchemaRegistryConfig config();

    public Map<String, Object> properties();

    public MetadataEncoderService getMetadataEncoder();

    public void addUpdateRequestHandler(UpdateRequestHandler var1);

    public Mode getModeInScope(String var1) throws SchemaRegistryStoreException;

    public List<Handler.Singleton> getCustomHandler();

    public void postInit() throws SchemaRegistryException;

    public UpdateRequestHandler getCompositeUpdateRequestHandler();

    public int normalizeContextLimit(int var1);

    public Config getConfigInScope(String var1) throws SchemaRegistryStoreException;

    public Config getConfig(String var1) throws SchemaRegistryStoreException;

    public List<String> listContexts() throws SchemaRegistryException;

    public Schema lookUpSchemaUnderSubjectUsingContexts(String var1, Schema var2, boolean var3, boolean var4) throws SchemaRegistryException;

    public boolean hasSubjects(String var1, boolean var2) throws SchemaRegistryStoreException;

    public ParsedSchema parseSchema(Schema var1) throws InvalidSchemaException;

    public ParsedSchema parseSchema(Schema var1, boolean var2, boolean var3) throws InvalidSchemaException;

    public Set<String> listSubjectsWithPrefix(String var1, LookupFilter var2) throws SchemaRegistryException;

    public int normalizeSubjectLimit(int var1);

    public int normalizeSchemaLimit(int var1);

    public void extractSchemaTags(Schema var1, List<String> var2) throws SchemaRegistryException;

    public List<SubjectVersion> listVersionsForId(int var1, String var2, boolean var3) throws SchemaRegistryException;

    public int normalizeSubjectVersionLimit(int var1);

    public SchemaString getByGuid(String var1, String var2) throws SchemaRegistryException;

    public List<ContextId> listIdsForGuid(String var1) throws SchemaRegistryException;

    public Schema getUsingContexts(String var1, int var2, boolean var3) throws SchemaRegistryException;

    public List<Integer> getReferencedBy(String var1, VersionId var2) throws SchemaRegistryException;

    public boolean schemaVersionExists(String var1, VersionId var2, boolean var3) throws SchemaRegistryException;

    public Mode getMode(String var1) throws SchemaRegistryStoreException;

    public MetricsContainer getMetricsContainer();

    public List<SchemaRegistryResourceExtension> getResourceExtensions();

    public Config updateConfig(String var1, ConfigUpdateRequest var2) throws SchemaRegistryStoreException, OperationNotPermittedException, UnknownLeaderException;

    public void deleteSubjectConfig(String var1) throws SchemaRegistryStoreException, OperationNotPermittedException;

    public void setMode(String var1, ModeUpdateRequest var2, boolean var3) throws SchemaRegistryException;

    public void setMode(String var1, ModeUpdateRequest var2) throws SchemaRegistryException;

    public SchemaProvider schemaProvider(String var1);

    public Schema toSchemaEntity(SchemaValue var1) throws SchemaRegistryStoreException;

    public SchemaValue getSchemaValue(SchemaKey var1) throws SchemaRegistryException;

    public Set<String> subjects(String var1, boolean var2) throws SchemaRegistryStoreException;

    public void addCustomHandler(Handler.Singleton var1);

    public void deleteSubjectMode(String var1) throws SchemaRegistryStoreException, OperationNotPermittedException;

    default public void deleteSubjectMode(String subject, boolean recursive) throws SchemaRegistryStoreException, OperationNotPermittedException {
    }

    public RuleSetHandler getRuleSetHandler();

    public void setRuleSetHandler(RuleSetHandler var1);

    public HostnameVerifier getHostnameVerifier() throws SchemaRegistryStoreException;

    public SchemaRegistryIdentity myIdentity();

    public boolean initialized();

    public boolean healthy();

    public SslFactory getSslFactory();

    public LookupCache<SchemaRegistryKey, SchemaRegistryValue> getLookupCache();

    default public KafkaStore<SchemaRegistryKey, SchemaRegistryValue> getKafkaStore() {
        return null;
    }

    default public void clearOldSchemaCache() {
    }

    default public void clearNewSchemaCache() {
    }

    default public void invalidateFromNewSchemaCache(Schema schemaKey) {
    }

    default public String getGroupId() {
        return null;
    }

    default public String getKafkaClusterId() {
        return null;
    }

    default public void deleteSubjectModeOrForward(String subject, boolean recursive, Map<String, String> headerProperties) throws SchemaRegistryStoreException, SchemaRegistryRequestForwardingException, OperationNotPermittedException, UnknownLeaderException {
    }

    default public void setModeOrForward(String subject, ModeUpdateRequest mode, boolean force, Map<String, String> headerProperties) throws SchemaRegistryException {
    }

    default public void deleteSchemaVersionOrForward(Map<String, String> headerProperties, String subject, Schema schema, boolean permanentDelete) throws SchemaRegistryException {
    }

    default public Schema modifySchemaTagsOrForward(String subject, Schema schema, TagSchemaRequest request, Map<String, String> headerProperties) throws SchemaRegistryException {
        return null;
    }

    default public Schema registerOrForward(String subject, RegisterSchemaRequest request, boolean normalize, Map<String, String> headerProperties) throws SchemaRegistryException {
        return null;
    }

    default public List<Integer> deleteSubjectOrForward(Map<String, String> requestProperties, String subject, boolean permanentDelete) throws SchemaRegistryException {
        return null;
    }

    default public Config updateConfigOrForward(String subject, ConfigUpdateRequest newConfig, Map<String, String> headerProperties) throws SchemaRegistryStoreException, SchemaRegistryRequestForwardingException, UnknownLeaderException, OperationNotPermittedException {
        return null;
    }

    default public void deleteConfigOrForward(String subject, Map<String, String> headerProperties) throws SchemaRegistryStoreException, SchemaRegistryRequestForwardingException, OperationNotPermittedException, UnknownLeaderException {
    }

    default public void deleteContextOrForward(Map<String, String> requestProperties, String delimitedContext) throws SchemaRegistryException {
    }

    default public void addLeaderChangeListener(Consumer<Boolean> listener) {
    }

    default public boolean isLeader() {
        return false;
    }

    default public SchemaRegistryIdentity leaderIdentity() {
        return null;
    }

    default public RestService leaderRestService() {
        return null;
    }

    default public void setLeader(@Nullable SchemaRegistryIdentity newLeader) throws SchemaRegistryTimeoutException, SchemaRegistryStoreException, IdGenerationException {
    }
}

