/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.client.impl;

import io.confluent.ksql.api.client.TopicInfo;
import java.util.List;
import java.util.Objects;

public class TopicInfoImpl
implements TopicInfo {
    private final String name;
    private final int partitions;
    private final List<Integer> replicasPerPartition;

    TopicInfoImpl(String name, int partitions, List<Integer> replicasPerPartition) {
        this.name = Objects.requireNonNull(name);
        this.partitions = partitions;
        this.replicasPerPartition = Objects.requireNonNull(replicasPerPartition);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPartitions() {
        return this.partitions;
    }

    @Override
    public List<Integer> getReplicasPerPartition() {
        return this.replicasPerPartition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicInfoImpl topicInfo = (TopicInfoImpl)o;
        return this.partitions == topicInfo.partitions && this.name.equals(topicInfo.name) && this.replicasPerPartition.equals(topicInfo.replicasPerPartition);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.partitions, this.replicasPerPartition);
    }

    public String toString() {
        return "TopicInfo{name='" + this.name + '\'' + ", partitions=" + this.partitions + ", replicasPerPartition=" + this.replicasPerPartition + '}';
    }
}

