/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.builder;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.context.QueryLoggerUtil;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.logging.processing.ProcessingLogContext;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.schema.ksql.PersistenceSchema;
import io.confluent.ksql.schema.ksql.PhysicalSchema;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.GenericKeySerDe;
import io.confluent.ksql.serde.GenericRowSerDe;
import io.confluent.ksql.serde.KeySerdeFactory;
import io.confluent.ksql.serde.ValueSerdeFactory;
import io.confluent.ksql.serde.WindowInfo;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.QuerySchemas;
import java.util.LinkedHashMap;
import java.util.Objects;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.Windowed;

public final class KsqlQueryBuilder {
    private final StreamsBuilder streamsBuilder;
    private final KsqlConfig ksqlConfig;
    private final ServiceContext serviceContext;
    private final ProcessingLogContext processingLogContext;
    private final FunctionRegistry functionRegistry;
    private final KeySerdeFactory keySerdeFactory;
    private final ValueSerdeFactory valueSerdeFactory;
    private final QueryId queryId;
    private final LinkedHashMap<String, PersistenceSchema> schemas = new LinkedHashMap();

    public static KsqlQueryBuilder of(StreamsBuilder streamsBuilder, KsqlConfig ksqlConfig, ServiceContext serviceContext, ProcessingLogContext processingLogContext, FunctionRegistry functionRegistry, QueryId queryId) {
        return new KsqlQueryBuilder(streamsBuilder, ksqlConfig, serviceContext, processingLogContext, functionRegistry, queryId, (KeySerdeFactory)new GenericKeySerDe(), (ValueSerdeFactory)new GenericRowSerDe());
    }

    @VisibleForTesting
    KsqlQueryBuilder(StreamsBuilder streamsBuilder, KsqlConfig ksqlConfig, ServiceContext serviceContext, ProcessingLogContext processingLogContext, FunctionRegistry functionRegistry, QueryId queryId, KeySerdeFactory keySerdeFactory, ValueSerdeFactory valueSerdeFactory) {
        this.streamsBuilder = Objects.requireNonNull(streamsBuilder, "streamsBuilder");
        this.ksqlConfig = Objects.requireNonNull(ksqlConfig, "ksqlConfig");
        this.serviceContext = Objects.requireNonNull(serviceContext, "serviceContext");
        this.processingLogContext = Objects.requireNonNull(processingLogContext, "processingLogContext");
        this.functionRegistry = Objects.requireNonNull(functionRegistry, "functionRegistry");
        this.queryId = Objects.requireNonNull(queryId, "queryId");
        this.keySerdeFactory = Objects.requireNonNull(keySerdeFactory, "keySerdeFactory");
        this.valueSerdeFactory = Objects.requireNonNull(valueSerdeFactory, "valueSerdeFactory");
    }

    public ProcessingLogContext getProcessingLogContext() {
        return this.processingLogContext;
    }

    public ServiceContext getServiceContext() {
        return this.serviceContext;
    }

    public KsqlConfig getKsqlConfig() {
        return this.ksqlConfig;
    }

    public FunctionRegistry getFunctionRegistry() {
        return this.functionRegistry;
    }

    public StreamsBuilder getStreamsBuilder() {
        return this.streamsBuilder;
    }

    public QuerySchemas getSchemas() {
        return QuerySchemas.of(this.schemas);
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public KsqlQueryBuilder withKsqlConfig(KsqlConfig newConfig) {
        return KsqlQueryBuilder.of(this.streamsBuilder, newConfig, this.serviceContext, this.processingLogContext, this.functionRegistry, this.queryId);
    }

    public QueryContext.Stacker buildNodeContext(String context) {
        return new QueryContext.Stacker().push(context);
    }

    public Serde<Struct> buildKeySerde(FormatInfo format, PhysicalSchema schema, QueryContext queryContext) {
        String loggerNamePrefix = QueryLoggerUtil.queryLoggerName(this.queryId, queryContext);
        return this.keySerdeFactory.create(format, schema.keySchema(), this.ksqlConfig, this.serviceContext.getSchemaRegistryClientFactory(), loggerNamePrefix, this.processingLogContext);
    }

    public Serde<Windowed<Struct>> buildKeySerde(FormatInfo format, WindowInfo window, PhysicalSchema schema, QueryContext queryContext) {
        String loggerNamePrefix = QueryLoggerUtil.queryLoggerName(this.queryId, queryContext);
        return this.keySerdeFactory.create(format, window, schema.keySchema(), this.ksqlConfig, this.serviceContext.getSchemaRegistryClientFactory(), loggerNamePrefix, this.processingLogContext);
    }

    public Serde<GenericRow> buildValueSerde(FormatInfo format, PhysicalSchema schema, QueryContext queryContext) {
        String loggerNamePrefix = QueryLoggerUtil.queryLoggerName(this.queryId, queryContext);
        this.track(loggerNamePrefix, schema.valueSchema());
        return this.valueSerdeFactory.create(format, schema.valueSchema(), this.ksqlConfig, this.serviceContext.getSchemaRegistryClientFactory(), loggerNamePrefix, this.processingLogContext);
    }

    private void track(String loggerNamePrefix, PersistenceSchema schema) {
        if (this.schemas.containsKey(loggerNamePrefix)) {
            throw new IllegalStateException("Schema with tracked:" + loggerNamePrefix);
        }
        this.schemas.put(loggerNamePrefix, schema);
    }
}

