/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.codegen;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.codegen.CodeGenSpec;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.testing.EffectivelyImmutable;
import io.confluent.ksql.util.KsqlException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import org.codehaus.commons.compiler.IExpressionEvaluator;

@Immutable
public class ExpressionMetadata {
    @EffectivelyImmutable
    private final IExpressionEvaluator expressionEvaluator;
    private final SqlType expressionType;
    private final ThreadLocal<Object[]> threadLocalParameters;
    private final Expression expression;
    private final CodeGenSpec spec;

    public ExpressionMetadata(IExpressionEvaluator expressionEvaluator, CodeGenSpec spec, SqlType expressionType, Expression expression) {
        this.expressionEvaluator = Objects.requireNonNull(expressionEvaluator, "expressionEvaluator");
        this.expressionType = Objects.requireNonNull(expressionType, "expressionType");
        this.expression = Objects.requireNonNull(expression, "expression");
        this.spec = Objects.requireNonNull(spec, "spec");
        this.threadLocalParameters = ThreadLocal.withInitial(() -> new Object[spec.arguments().size()]);
    }

    public List<CodeGenSpec.ArgumentSpec> arguments() {
        return this.spec.arguments();
    }

    public SqlType getExpressionType() {
        return this.expressionType;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Object evaluate(GenericRow row) {
        try {
            return this.expressionEvaluator.evaluate(this.getParameters(row));
        }
        catch (InvocationTargetException e) {
            throw new KsqlException(e.getCause().getMessage(), e.getCause());
        }
    }

    private Object[] getParameters(GenericRow row) {
        Object[] parameters = this.threadLocalParameters.get();
        this.spec.resolve(row, parameters);
        return parameters;
    }
}

