/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.codegen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import io.confluent.ksql.execution.codegen.CodeGenSpec;
import io.confluent.ksql.execution.codegen.helpers.ArrayAccess;
import io.confluent.ksql.execution.codegen.helpers.ArrayBuilder;
import io.confluent.ksql.execution.codegen.helpers.SearchedCaseFunction;
import io.confluent.ksql.execution.expression.tree.ArithmeticBinaryExpression;
import io.confluent.ksql.execution.expression.tree.ArithmeticUnaryExpression;
import io.confluent.ksql.execution.expression.tree.BetweenPredicate;
import io.confluent.ksql.execution.expression.tree.BooleanLiteral;
import io.confluent.ksql.execution.expression.tree.Cast;
import io.confluent.ksql.execution.expression.tree.ComparisonExpression;
import io.confluent.ksql.execution.expression.tree.CreateArrayExpression;
import io.confluent.ksql.execution.expression.tree.CreateMapExpression;
import io.confluent.ksql.execution.expression.tree.CreateStructExpression;
import io.confluent.ksql.execution.expression.tree.DecimalLiteral;
import io.confluent.ksql.execution.expression.tree.DereferenceExpression;
import io.confluent.ksql.execution.expression.tree.DoubleLiteral;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.execution.expression.tree.InListExpression;
import io.confluent.ksql.execution.expression.tree.InPredicate;
import io.confluent.ksql.execution.expression.tree.IntegerLiteral;
import io.confluent.ksql.execution.expression.tree.IsNotNullPredicate;
import io.confluent.ksql.execution.expression.tree.IsNullPredicate;
import io.confluent.ksql.execution.expression.tree.LikePredicate;
import io.confluent.ksql.execution.expression.tree.LogicalBinaryExpression;
import io.confluent.ksql.execution.expression.tree.LongLiteral;
import io.confluent.ksql.execution.expression.tree.NotExpression;
import io.confluent.ksql.execution.expression.tree.NullLiteral;
import io.confluent.ksql.execution.expression.tree.QualifiedColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.SearchedCaseExpression;
import io.confluent.ksql.execution.expression.tree.SimpleCaseExpression;
import io.confluent.ksql.execution.expression.tree.StringLiteral;
import io.confluent.ksql.execution.expression.tree.SubscriptExpression;
import io.confluent.ksql.execution.expression.tree.TimeLiteral;
import io.confluent.ksql.execution.expression.tree.TimestampLiteral;
import io.confluent.ksql.execution.expression.tree.Type;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.WhenClause;
import io.confluent.ksql.execution.util.ExpressionTypeManager;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.function.GenericsUtil;
import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.KsqlScalarFunction;
import io.confluent.ksql.function.UdfFactory;
import io.confluent.ksql.function.types.ArrayType;
import io.confluent.ksql.function.types.ParamType;
import io.confluent.ksql.function.types.ParamTypes;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.FunctionName;
import io.confluent.ksql.schema.Operator;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.FormatOptions;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.SqlArray;
import io.confluent.ksql.schema.ksql.types.SqlDecimal;
import io.confluent.ksql.schema.ksql.types.SqlMap;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.ksql.types.SqlTypes;
import io.confluent.ksql.util.DecimalUtil;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.Pair;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public class SqlToJavaVisitor {
    public static final List<String> JAVA_IMPORTS = ImmutableList.of((Object)"org.apache.kafka.connect.data.Struct", (Object)"io.confluent.ksql.execution.codegen.helpers.ArrayAccess", (Object)"io.confluent.ksql.execution.codegen.helpers.SearchedCaseFunction", (Object)"io.confluent.ksql.execution.codegen.helpers.SearchedCaseFunction.LazyWhenClause", (Object)"java.util.HashMap", (Object)"java.util.Map", (Object)"java.util.List", (Object)"java.util.ArrayList", (Object)"com.google.common.collect.ImmutableList", (Object)"com.google.common.collect.ImmutableMap", (Object)"java.util.function.Supplier", (Object)DecimalUtil.class.getCanonicalName(), (Object[])new String[]{BigDecimal.class.getCanonicalName(), MathContext.class.getCanonicalName(), RoundingMode.class.getCanonicalName(), SchemaBuilder.class.getCanonicalName(), Struct.class.getCanonicalName(), ArrayBuilder.class.getCanonicalName()});
    private static final Map<Operator, String> DECIMAL_OPERATOR_NAME = ImmutableMap.builder().put((Object)Operator.ADD, (Object)"add").put((Object)Operator.SUBTRACT, (Object)"subtract").put((Object)Operator.MULTIPLY, (Object)"multiply").put((Object)Operator.DIVIDE, (Object)"divide").put((Object)Operator.MODULUS, (Object)"remainder").build();
    private static final Map<ComparisonExpression.Type, String> SQL_COMPARE_TO_JAVA = ImmutableMap.builder().put((Object)ComparisonExpression.Type.EQUAL, (Object)"==").put((Object)ComparisonExpression.Type.NOT_EQUAL, (Object)"!=").put((Object)ComparisonExpression.Type.IS_DISTINCT_FROM, (Object)"!=").put((Object)ComparisonExpression.Type.GREATER_THAN_OR_EQUAL, (Object)">=").put((Object)ComparisonExpression.Type.GREATER_THAN, (Object)">").put((Object)ComparisonExpression.Type.LESS_THAN_OR_EQUAL, (Object)"<=").put((Object)ComparisonExpression.Type.LESS_THAN, (Object)"<").build();
    private final LogicalSchema schema;
    private final FunctionRegistry functionRegistry;
    private final ExpressionTypeManager expressionTypeManager;
    private final Function<FunctionName, String> funNameToCodeName;
    private final Function<ColumnName, String> colRefToCodeName;
    private final Function<CreateStructExpression, String> structToCodeName;

    public static SqlToJavaVisitor of(LogicalSchema schema, FunctionRegistry functionRegistry, CodeGenSpec spec) {
        HashMultiset nameCounts = HashMultiset.create();
        return new SqlToJavaVisitor(schema, functionRegistry, spec::getCodeName, arg_0 -> SqlToJavaVisitor.lambda$of$0((Multiset)nameCounts, spec, arg_0), spec::getStructSchemaName);
    }

    @VisibleForTesting
    SqlToJavaVisitor(LogicalSchema schema, FunctionRegistry functionRegistry, Function<ColumnName, String> colRefToCodeName, Function<FunctionName, String> funNameToCodeName, Function<CreateStructExpression, String> structToCodeName) {
        this.expressionTypeManager = new ExpressionTypeManager(schema, functionRegistry);
        this.schema = Objects.requireNonNull(schema, "schema");
        this.functionRegistry = Objects.requireNonNull(functionRegistry, "functionRegistry");
        this.colRefToCodeName = Objects.requireNonNull(colRefToCodeName, "colRefToCodeName");
        this.funNameToCodeName = Objects.requireNonNull(funNameToCodeName, "funNameToCodeName");
        this.structToCodeName = Objects.requireNonNull(structToCodeName, "structToCodeName");
    }

    public String process(Expression expression) {
        return this.formatExpression(expression);
    }

    private String formatExpression(Expression expression) {
        Pair expressionFormatterResult = (Pair)new Formatter(this.functionRegistry).process(expression, null);
        return (String)expressionFormatterResult.getLeft();
    }

    private static /* synthetic */ String lambda$of$0(Multiset nameCounts, CodeGenSpec spec, FunctionName name) {
        int index = nameCounts.add((Object)name, 1);
        return spec.getUniqueNameForFunction(name, index);
    }

    private static final class CaseWhenProcessed {
        private final Pair<String, SqlType> whenProcessResult;
        private final Pair<String, SqlType> thenProcessResult;

        private CaseWhenProcessed(Pair<String, SqlType> whenProcessResult, Pair<String, SqlType> thenProcessResult) {
            this.whenProcessResult = whenProcessResult;
            this.thenProcessResult = thenProcessResult;
        }
    }

    private static final class CastVisitor {
        private static final Map<SqlBaseType, CastFunction> CASTERS = ImmutableMap.builder().put((Object)SqlBaseType.STRING, CastVisitor::castString).put((Object)SqlBaseType.BOOLEAN, CastVisitor::castBoolean).put((Object)SqlBaseType.INTEGER, CastVisitor::castInteger).put((Object)SqlBaseType.BIGINT, CastVisitor::castLong).put((Object)SqlBaseType.DOUBLE, CastVisitor::castDouble).put((Object)SqlBaseType.DECIMAL, CastVisitor::castDecimal).build();

        private CastVisitor() {
        }

        static Pair<String, SqlType> getCast(Pair<String, SqlType> expr, SqlType sqlType) {
            if (!sqlType.supportsCast()) {
                throw new KsqlFunctionException("Only casts to primitive types and decimal are supported: " + sqlType);
            }
            SqlType rightSchema = (SqlType)expr.getRight();
            if (sqlType.equals(rightSchema) || rightSchema == null) {
                return new Pair(expr.getLeft(), (Object)sqlType);
            }
            return CASTERS.getOrDefault(sqlType.baseType(), (e, t, r) -> {
                throw new KsqlException("Invalid cast operation: " + t);
            }).cast(expr, sqlType, sqlType);
        }

        private static Pair<String, SqlType> castString(Pair<String, SqlType> expr, SqlType sqltype, SqlType returnType) {
            String exprStr;
            SqlType schema = (SqlType)expr.getRight();
            if (schema.baseType() == SqlBaseType.DECIMAL) {
                SqlDecimal decimal = (SqlDecimal)schema;
                int precision = decimal.getPrecision();
                int scale = decimal.getScale();
                exprStr = String.format("DecimalUtil.format(%d, %d, %s)", precision, scale, expr.getLeft());
            } else {
                exprStr = "String.valueOf(" + (String)expr.getLeft() + ")";
            }
            return new Pair((Object)exprStr, (Object)returnType);
        }

        private static Pair<String, SqlType> castBoolean(Pair<String, SqlType> expr, SqlType sqltype, SqlType returnType) {
            return new Pair((Object)CastVisitor.getCastToBooleanString((SqlType)expr.getRight(), (String)expr.getLeft()), (Object)returnType);
        }

        private static Pair<String, SqlType> castInteger(Pair<String, SqlType> expr, SqlType sqltype, SqlType returnType) {
            String exprStr = CastVisitor.getCastString((SqlType)expr.getRight(), (String)expr.getLeft(), "intValue()", "Integer.parseInt");
            return new Pair((Object)exprStr, (Object)returnType);
        }

        private static Pair<String, SqlType> castLong(Pair<String, SqlType> expr, SqlType sqltype, SqlType returnType) {
            String exprStr = CastVisitor.getCastString((SqlType)expr.getRight(), (String)expr.getLeft(), "longValue()", "Long.parseLong");
            return new Pair((Object)exprStr, (Object)returnType);
        }

        private static Pair<String, SqlType> castDouble(Pair<String, SqlType> expr, SqlType sqltype, SqlType returnType) {
            String exprStr = CastVisitor.getCastString((SqlType)expr.getRight(), (String)expr.getLeft(), "doubleValue()", "Double.parseDouble");
            return new Pair((Object)exprStr, (Object)returnType);
        }

        private static Pair<String, SqlType> castDecimal(Pair<String, SqlType> expr, SqlType sqltype, SqlType returnType) {
            if (!(sqltype instanceof SqlDecimal)) {
                throw new KsqlException("Expected decimal type: " + sqltype);
            }
            SqlDecimal sqlDecimal = (SqlDecimal)sqltype;
            if (((SqlType)expr.getRight()).baseType() == SqlBaseType.DECIMAL && ((SqlType)expr.right).equals(sqlDecimal)) {
                return expr;
            }
            return new Pair((Object)CastVisitor.getDecimalCastString((SqlType)expr.getRight(), (String)expr.getLeft(), sqlDecimal), (Object)returnType);
        }

        private static String getCastToBooleanString(SqlType schema, String exprStr) {
            if (schema.baseType() == SqlBaseType.STRING) {
                return "Boolean.parseBoolean(" + exprStr + ")";
            }
            throw new KsqlFunctionException("Invalid cast operation: Cannot cast " + exprStr + " to boolean.");
        }

        private static String getCastString(SqlType schema, String exprStr, String javaTypeMethod, String javaStringParserMethod) {
            if (schema.baseType() == SqlBaseType.DECIMAL) {
                return "((" + exprStr + ")." + javaTypeMethod + ")";
            }
            switch (schema.baseType()) {
                case INTEGER: {
                    return "(new Integer(" + exprStr + ")." + javaTypeMethod + ")";
                }
                case BIGINT: {
                    return "(new Long(" + exprStr + ")." + javaTypeMethod + ")";
                }
                case DOUBLE: {
                    return "(new Double(" + exprStr + ")." + javaTypeMethod + ")";
                }
                case STRING: {
                    return javaStringParserMethod + "(" + exprStr + ")";
                }
            }
            throw new KsqlFunctionException("Invalid cast operation: Cannot cast " + exprStr + " to " + schema.toString(FormatOptions.noEscape()) + ".");
        }

        private static String getDecimalCastString(SqlType schema, String exprStr, SqlDecimal target) {
            switch (schema.baseType()) {
                case DECIMAL: 
                case DOUBLE: 
                case STRING: 
                case INTEGER: 
                case BIGINT: {
                    return String.format("(DecimalUtil.cast(%s, %d, %d))", exprStr, target.getPrecision(), target.getScale());
                }
            }
            throw new KsqlFunctionException("Invalid cast operation: Cannot cast " + exprStr + " to " + schema);
        }

        @FunctionalInterface
        private static interface CastFunction {
            public Pair<String, SqlType> cast(Pair<String, SqlType> var1, SqlType var2, SqlType var3);
        }
    }

    private class Formatter
    implements ExpressionVisitor<Pair<String, SqlType>, Void> {
        private final FunctionRegistry functionRegistry;

        Formatter(FunctionRegistry functionRegistry) {
            this.functionRegistry = functionRegistry;
        }

        private Pair<String, SqlType> visitIllegalState(Expression expression) {
            throw new IllegalStateException(String.format("expression type %s should never be visited", ((Object)((Object)expression)).getClass()));
        }

        private Pair<String, SqlType> visitUnsupported(Expression expression) {
            throw new UnsupportedOperationException(String.format("not yet implemented: %s.visit%s", this.getClass().getName(), ((Object)((Object)expression)).getClass().getSimpleName()));
        }

        @Override
        public Pair<String, SqlType> visitType(Type node, Void context) {
            return this.visitIllegalState(node);
        }

        @Override
        public Pair<String, SqlType> visitWhenClause(WhenClause whenClause, Void context) {
            return this.visitIllegalState(whenClause);
        }

        @Override
        public Pair<String, SqlType> visitInPredicate(InPredicate inPredicate, Void context) {
            return this.visitUnsupported(inPredicate);
        }

        @Override
        public Pair<String, SqlType> visitInListExpression(InListExpression inListExpression, Void context) {
            return this.visitUnsupported(inListExpression);
        }

        @Override
        public Pair<String, SqlType> visitTimestampLiteral(TimestampLiteral timestampLiteral, Void context) {
            return this.visitUnsupported(timestampLiteral);
        }

        @Override
        public Pair<String, SqlType> visitTimeLiteral(TimeLiteral timeLiteral, Void context) {
            return this.visitUnsupported(timeLiteral);
        }

        @Override
        public Pair<String, SqlType> visitSimpleCaseExpression(SimpleCaseExpression simpleCaseExpression, Void context) {
            return this.visitUnsupported(simpleCaseExpression);
        }

        @Override
        public Pair<String, SqlType> visitBooleanLiteral(BooleanLiteral node, Void context) {
            return new Pair((Object)String.valueOf(node.getValue()), (Object)SqlTypes.BOOLEAN);
        }

        @Override
        public Pair<String, SqlType> visitStringLiteral(StringLiteral node, Void context) {
            return new Pair((Object)("\"" + StringEscapeUtils.escapeJava((String)node.getValue()) + "\""), (Object)SqlTypes.STRING);
        }

        @Override
        public Pair<String, SqlType> visitDoubleLiteral(DoubleLiteral node, Void context) {
            return new Pair((Object)node.toString(), (Object)SqlTypes.DOUBLE);
        }

        @Override
        public Pair<String, SqlType> visitDecimalLiteral(DecimalLiteral decimalLiteral, Void context) {
            return new Pair((Object)("new BigDecimal(\"" + decimalLiteral.getValue() + "\")"), (Object)DecimalUtil.fromValue((BigDecimal)decimalLiteral.getValue()));
        }

        @Override
        public Pair<String, SqlType> visitNullLiteral(NullLiteral node, Void context) {
            return new Pair((Object)"null", null);
        }

        @Override
        public Pair<String, SqlType> visitColumnReference(UnqualifiedColumnReferenceExp node, Void context) {
            ColumnName fieldName = node.getReference();
            Column schemaColumn = (Column)SqlToJavaVisitor.this.schema.findValueColumn(node.getReference()).orElseThrow(() -> new KsqlException("Field not found: " + node.getReference()));
            return new Pair(SqlToJavaVisitor.this.colRefToCodeName.apply(fieldName), (Object)schemaColumn.type());
        }

        @Override
        public Pair<String, SqlType> visitQualifiedColumnReference(QualifiedColumnReferenceExp node, Void context) {
            throw new UnsupportedOperationException("Qualified column reference must be resolved to unqualified reference before codegen");
        }

        @Override
        public Pair<String, SqlType> visitDereferenceExpression(DereferenceExpression node, Void context) {
            SqlType functionReturnSchema = SqlToJavaVisitor.this.expressionTypeManager.getExpressionSqlType(node);
            String javaReturnType = SchemaConverters.sqlToJavaConverter().toJavaType(functionReturnSchema).getSimpleName();
            String struct = (String)((Pair)this.process(node.getBase(), context)).getLeft();
            String field = (String)((Pair)this.process(new StringLiteral(node.getFieldName()), context)).getLeft();
            String codeString = "((" + javaReturnType + ") " + struct + ".get(" + field + "))";
            return new Pair((Object)codeString, (Object)functionReturnSchema);
        }

        @Override
        public Pair<String, SqlType> visitLongLiteral(LongLiteral node, Void context) {
            return new Pair((Object)(node.getValue() + "L"), (Object)SqlTypes.BIGINT);
        }

        @Override
        public Pair<String, SqlType> visitIntegerLiteral(IntegerLiteral node, Void context) {
            return new Pair((Object)Integer.toString(node.getValue()), (Object)SqlTypes.INTEGER);
        }

        @Override
        public Pair<String, SqlType> visitFunctionCall(FunctionCall node, Void context) {
            FunctionName functionName = node.getName();
            String instanceName = (String)SqlToJavaVisitor.this.funNameToCodeName.apply(functionName);
            UdfFactory udfFactory = this.functionRegistry.getUdfFactory(node.getName());
            List argumentSchemas = node.getArguments().stream().map(SqlToJavaVisitor.this.expressionTypeManager::getExpressionSqlType).collect(Collectors.toList());
            KsqlScalarFunction function = udfFactory.getFunction(argumentSchemas);
            SqlType functionReturnSchema = function.getReturnType(argumentSchemas);
            String javaReturnType = SchemaConverters.sqlToJavaConverter().toJavaType(functionReturnSchema).getSimpleName();
            List<Expression> arguments = node.getArguments();
            StringJoiner joiner = new StringJoiner(", ");
            for (int i = 0; i < arguments.size(); ++i) {
                Expression arg = arguments.get(i);
                SqlType sqlType = (SqlType)argumentSchemas.get(i);
                ParamType paramType = i >= function.parameters().size() - 1 && function.isVariadic() ? ((ArrayType)Iterables.getLast((Iterable)function.parameters())).element() : (ParamType)function.parameters().get(i);
                joiner.add((CharSequence)((Pair)this.process(this.convertArgument(arg, sqlType, paramType), context)).getLeft());
            }
            String argumentsString = joiner.toString();
            String codeString = "((" + javaReturnType + ") " + instanceName + ".evaluate(" + argumentsString + "))";
            return new Pair((Object)codeString, (Object)functionReturnSchema);
        }

        private Expression convertArgument(Expression argument, SqlType argType, ParamType funType) {
            if (argType == null || GenericsUtil.hasGenerics((ParamType)funType) || SchemaConverters.sqlToFunctionConverter().toFunctionType(argType).equals((Object)funType)) {
                return argument;
            }
            SqlDecimal target = funType == ParamTypes.DECIMAL ? DecimalUtil.toSqlDecimal((SqlType)argType) : SchemaConverters.functionToSqlConverter().toSqlType(funType);
            return new Cast(argument, new Type((SqlType)target));
        }

        @Override
        public Pair<String, SqlType> visitLogicalBinaryExpression(LogicalBinaryExpression node, Void context) {
            if (node.getType() == LogicalBinaryExpression.Type.OR) {
                return new Pair((Object)this.formatBinaryExpression(" || ", node.getLeft(), node.getRight(), context), (Object)SqlTypes.BOOLEAN);
            }
            if (node.getType() == LogicalBinaryExpression.Type.AND) {
                return new Pair((Object)this.formatBinaryExpression(" && ", node.getLeft(), node.getRight(), context), (Object)SqlTypes.BOOLEAN);
            }
            throw new UnsupportedOperationException(String.format("not yet implemented: %s.visit%s", this.getClass().getName(), ((Object)((Object)node)).getClass().getSimpleName()));
        }

        @Override
        public Pair<String, SqlType> visitNotExpression(NotExpression node, Void context) {
            String exprString = (String)((Pair)this.process(node.getValue(), context)).getLeft();
            return new Pair((Object)("(!" + exprString + ")"), (Object)SqlTypes.BOOLEAN);
        }

        private String nullCheckPrefix(ComparisonExpression.Type type) {
            if (type == ComparisonExpression.Type.IS_DISTINCT_FROM) {
                return "(((Object)(%1$s)) == null || ((Object)(%2$s)) == null) ? ((((Object)(%1$s)) == null ) ^ (((Object)(%2$s)) == null )) : ";
            }
            return "(((Object)(%1$s)) == null || ((Object)(%2$s)) == null) ? false : ";
        }

        private String visitStringComparisonExpression(ComparisonExpression.Type type) {
            switch (type) {
                case EQUAL: {
                    return "(%1$s.equals(%2$s))";
                }
                case NOT_EQUAL: 
                case IS_DISTINCT_FROM: {
                    return "(!%1$s.equals(%2$s))";
                }
                case GREATER_THAN_OR_EQUAL: 
                case GREATER_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case LESS_THAN: {
                    return "(%1$s.compareTo(%2$s) " + type.getValue() + " 0)";
                }
            }
            throw new KsqlException("Unexpected string comparison: " + type.getValue());
        }

        private String visitScalarComparisonExpression(ComparisonExpression.Type type) {
            switch (type) {
                case EQUAL: {
                    return "((%1$s <= %2$s) && (%1$s >= %2$s))";
                }
                case NOT_EQUAL: 
                case IS_DISTINCT_FROM: {
                    return "((%1$s < %2$s) || (%1$s > %2$s))";
                }
                case GREATER_THAN_OR_EQUAL: 
                case GREATER_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case LESS_THAN: {
                    return "(%1$s " + type.getValue() + " %2$s)";
                }
            }
            throw new KsqlException("Unexpected scalar comparison: " + type.getValue());
        }

        private String visitBytesComparisonExpression(ComparisonExpression.Type type, SqlType left, SqlType right) {
            String comparator = (String)SQL_COMPARE_TO_JAVA.get((Object)type);
            if (comparator == null) {
                throw new KsqlException("Unexpected scalar comparison: " + type.getValue());
            }
            return String.format("(%s.compareTo(%s) %s 0)", this.toDecimal(left, 1), this.toDecimal(right, 2), comparator);
        }

        private String toDecimal(SqlType schema, int index) {
            switch (schema.baseType()) {
                case DECIMAL: {
                    return "%" + index + "$s";
                }
                case DOUBLE: {
                    return "BigDecimal.valueOf(%" + index + "$s)";
                }
            }
            return "new BigDecimal(%" + index + "$s)";
        }

        private String visitBooleanComparisonExpression(ComparisonExpression.Type type) {
            switch (type) {
                case EQUAL: {
                    return "(Boolean.compare(%1$s, %2$s) == 0)";
                }
                case NOT_EQUAL: 
                case IS_DISTINCT_FROM: {
                    return "(Boolean.compare(%1$s, %2$s) != 0)";
                }
            }
            throw new KsqlException("Unexpected boolean comparison: " + type.getValue());
        }

        @Override
        public Pair<String, SqlType> visitComparisonExpression(ComparisonExpression node, Void context) {
            Pair left = (Pair)this.process(node.getLeft(), context);
            Pair right = (Pair)this.process(node.getRight(), context);
            String exprFormat = this.nullCheckPrefix(node.getType());
            if (((SqlType)left.getRight()).baseType() == SqlBaseType.DECIMAL || ((SqlType)right.getRight()).baseType() == SqlBaseType.DECIMAL) {
                exprFormat = exprFormat + this.visitBytesComparisonExpression(node.getType(), (SqlType)left.getRight(), (SqlType)right.getRight());
            } else {
                switch (((SqlType)left.getRight()).baseType()) {
                    case STRING: {
                        exprFormat = exprFormat + this.visitStringComparisonExpression(node.getType());
                        break;
                    }
                    case MAP: {
                        throw new KsqlException("Cannot compare MAP values");
                    }
                    case ARRAY: {
                        throw new KsqlException("Cannot compare ARRAY values");
                    }
                    case BOOLEAN: {
                        exprFormat = exprFormat + this.visitBooleanComparisonExpression(node.getType());
                        break;
                    }
                    default: {
                        exprFormat = exprFormat + this.visitScalarComparisonExpression(node.getType());
                    }
                }
            }
            String expr = "(" + String.format(exprFormat, left.getLeft(), right.getLeft()) + ")";
            return new Pair((Object)expr, (Object)SqlTypes.BOOLEAN);
        }

        @Override
        public Pair<String, SqlType> visitCast(Cast node, Void context) {
            Pair expr = (Pair)this.process(node.getExpression(), context);
            return CastVisitor.getCast((Pair<String, SqlType>)expr, node.getType().getSqlType());
        }

        @Override
        public Pair<String, SqlType> visitIsNullPredicate(IsNullPredicate node, Void context) {
            Pair value = (Pair)this.process(node.getValue(), context);
            return new Pair((Object)("((" + (String)value.getLeft() + ") == null )"), (Object)SqlTypes.BOOLEAN);
        }

        @Override
        public Pair<String, SqlType> visitIsNotNullPredicate(IsNotNullPredicate node, Void context) {
            Pair value = (Pair)this.process(node.getValue(), context);
            return new Pair((Object)("((" + (String)value.getLeft() + ") != null )"), (Object)SqlTypes.BOOLEAN);
        }

        @Override
        public Pair<String, SqlType> visitArithmeticUnary(ArithmeticUnaryExpression node, Void context) {
            Pair value = (Pair)this.process(node.getValue(), context);
            switch (node.getSign()) {
                case MINUS: {
                    return this.visitArithmeticMinus((Pair<String, SqlType>)value);
                }
                case PLUS: {
                    return this.visitArithmeticPlus((Pair<String, SqlType>)value);
                }
            }
            throw new UnsupportedOperationException("Unsupported sign: " + (Object)((Object)node.getSign()));
        }

        private Pair<String, SqlType> visitArithmeticMinus(Pair<String, SqlType> value) {
            if (((SqlType)value.getRight()).baseType() == SqlBaseType.DECIMAL) {
                return new Pair((Object)String.format("(%s.negate(new MathContext(%d, RoundingMode.UNNECESSARY)))", value.getLeft(), ((SqlDecimal)value.getRight()).getPrecision()), value.getRight());
            }
            String separator = ((String)value.getLeft()).startsWith("-") ? " " : "";
            return new Pair((Object)("-" + separator + (String)value.getLeft()), value.getRight());
        }

        private Pair<String, SqlType> visitArithmeticPlus(Pair<String, SqlType> value) {
            if (((SqlType)value.getRight()).baseType() == SqlBaseType.DECIMAL) {
                return new Pair((Object)String.format("(%s.plus(new MathContext(%d, RoundingMode.UNNECESSARY)))", value.getLeft(), ((SqlDecimal)value.getRight()).getPrecision()), value.getRight());
            }
            return new Pair((Object)("+" + (String)value.getLeft()), value.getRight());
        }

        @Override
        public Pair<String, SqlType> visitArithmeticBinary(ArithmeticBinaryExpression node, Void context) {
            Pair left = (Pair)this.process(node.getLeft(), context);
            Pair right = (Pair)this.process(node.getRight(), context);
            SqlType schema = SqlToJavaVisitor.this.expressionTypeManager.getExpressionSqlType(node);
            if (schema.baseType() == SqlBaseType.DECIMAL) {
                SqlDecimal decimal = (SqlDecimal)schema;
                String leftExpr = (String)CastVisitor.getCast((Pair<String, SqlType>)left, (SqlType)DecimalUtil.toSqlDecimal((SqlType)((SqlType)left.right))).getLeft();
                String rightExpr = (String)CastVisitor.getCast((Pair<String, SqlType>)right, (SqlType)DecimalUtil.toSqlDecimal((SqlType)((SqlType)right.right))).getLeft();
                return new Pair((Object)String.format("(%s.%s(%s, new MathContext(%d, RoundingMode.UNNECESSARY)).setScale(%d))", leftExpr, DECIMAL_OPERATOR_NAME.get(node.getOperator()), rightExpr, decimal.getPrecision(), decimal.getScale()), (Object)schema);
            }
            String leftExpr = ((SqlType)left.getRight()).baseType() == SqlBaseType.DECIMAL ? (String)CastVisitor.getCast((Pair<String, SqlType>)left, (SqlType)SqlTypes.DOUBLE).getLeft() : (String)left.getLeft();
            String rightExpr = ((SqlType)right.getRight()).baseType() == SqlBaseType.DECIMAL ? (String)CastVisitor.getCast((Pair<String, SqlType>)right, (SqlType)SqlTypes.DOUBLE).getLeft() : (String)right.getLeft();
            return new Pair((Object)String.format("(%s %s %s)", leftExpr, node.getOperator().getSymbol(), rightExpr), (Object)schema);
        }

        @Override
        public Pair<String, SqlType> visitSearchedCaseExpression(SearchedCaseExpression node, Void context) {
            String functionClassName = SearchedCaseFunction.class.getSimpleName();
            List whenClauses = node.getWhenClauses().stream().map(whenClause -> new CaseWhenProcessed((Pair)this.process(whenClause.getOperand(), context), (Pair)this.process(whenClause.getResult(), context))).collect(Collectors.toList());
            SqlType resultSchema = SqlToJavaVisitor.this.expressionTypeManager.getExpressionSqlType(node);
            String resultSchemaString = SchemaConverters.sqlToJavaConverter().toJavaType(resultSchema).getCanonicalName();
            List lazyWhenClause = whenClauses.stream().map(processedWhenClause -> functionClassName + ".whenClause(" + this.buildSupplierCode("Boolean", (String)((CaseWhenProcessed)processedWhenClause).whenProcessResult.getLeft()) + ", " + this.buildSupplierCode(resultSchemaString, (String)((CaseWhenProcessed)processedWhenClause).thenProcessResult.getLeft()) + ")").collect(Collectors.toList());
            String defaultValue = node.getDefaultValue().isPresent() ? (String)((Pair)this.process(node.getDefaultValue().get(), context)).getLeft() : "null";
            String codeString = "((" + resultSchemaString + ")" + functionClassName + ".searchedCaseFunction(ImmutableList.of( " + StringUtils.join(lazyWhenClause, (String)", ") + ")," + this.buildSupplierCode(resultSchemaString, defaultValue) + "))";
            return new Pair((Object)codeString, (Object)resultSchema);
        }

        private String buildSupplierCode(String typeString, String code) {
            return " new " + Supplier.class.getSimpleName() + "<" + typeString + ">() { @Override public " + typeString + " get() { return " + code + "; }}";
        }

        @Override
        public Pair<String, SqlType> visitLikePredicate(LikePredicate node, Void context) {
            String patternString = this.trimQuotes((String)((Pair)this.process(node.getPattern(), context)).getLeft());
            String valueString = (String)((Pair)this.process(node.getValue(), context)).getLeft();
            if (patternString.startsWith("%")) {
                if (patternString.endsWith("%")) {
                    return new Pair((Object)("(" + valueString + ").contains(\"" + patternString.substring(1, patternString.length() - 1) + "\")"), (Object)SqlTypes.STRING);
                }
                return new Pair((Object)("(" + valueString + ").endsWith(\"" + patternString.substring(1) + "\")"), (Object)SqlTypes.STRING);
            }
            if (patternString.endsWith("%")) {
                return new Pair((Object)("(" + valueString + ").startsWith(\"" + patternString.substring(0, patternString.length() - 1) + "\")"), (Object)SqlTypes.STRING);
            }
            if (!patternString.contains("%")) {
                return new Pair((Object)("(" + valueString + ").equals(\"" + patternString + "\")"), (Object)SqlTypes.STRING);
            }
            throw new UnsupportedOperationException("KSQL only supports leading and trailing wildcards in LIKE expressions.");
        }

        @Override
        public Pair<String, SqlType> visitSubscriptExpression(SubscriptExpression node, Void context) {
            SqlType internalSchema = SqlToJavaVisitor.this.expressionTypeManager.getExpressionSqlType(node.getBase());
            String internalSchemaJavaType = SchemaConverters.sqlToJavaConverter().toJavaType(internalSchema).getCanonicalName();
            switch (internalSchema.baseType()) {
                case ARRAY: {
                    SqlArray array = (SqlArray)internalSchema;
                    String listName = (String)((Pair)this.process(node.getBase(), context)).getLeft();
                    String suppliedIdx = (String)((Pair)this.process(node.getIndex(), context)).getLeft();
                    String code = String.format("((%s) (%s.arrayAccess((%s) %s, ((int) %s))))", SchemaConverters.sqlToJavaConverter().toJavaType(array.getItemType()).getSimpleName(), ArrayAccess.class.getSimpleName(), internalSchemaJavaType, listName, suppliedIdx);
                    return new Pair((Object)code, (Object)array.getItemType());
                }
                case MAP: {
                    SqlMap map = (SqlMap)internalSchema;
                    return new Pair((Object)String.format("((%s) ((%s)%s).get(%s))", SchemaConverters.sqlToJavaConverter().toJavaType(map.getValueType()).getSimpleName(), internalSchemaJavaType, ((Pair)this.process(node.getBase(), context)).getLeft(), ((Pair)this.process(node.getIndex(), context)).getLeft()), (Object)map.getValueType());
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public Pair<String, SqlType> visitCreateArrayExpression(CreateArrayExpression exp, Void context) {
            StringBuilder array = new StringBuilder("new ArrayBuilder(");
            array.append(exp.getValues().size());
            array.append(')');
            for (Expression value : exp.getValues()) {
                array.append(".add(");
                array.append((String)((Pair)this.process(value, context)).getLeft());
                array.append(")");
            }
            return new Pair((Object)("((List)" + array.toString() + ".build())"), (Object)SqlToJavaVisitor.this.expressionTypeManager.getExpressionSqlType(exp));
        }

        @Override
        public Pair<String, SqlType> visitCreateMapExpression(CreateMapExpression exp, Void context) {
            StringBuilder map = new StringBuilder("ImmutableMap.builder()");
            for (Map.Entry entry : exp.getMap().entrySet()) {
                map.append(".put(");
                map.append((String)((Pair)this.process((Expression)((Object)entry.getKey()), context)).getLeft());
                map.append(", ");
                map.append((String)((Pair)this.process((Expression)((Object)entry.getValue()), context)).getLeft());
                map.append(")");
            }
            return new Pair((Object)("((Map)" + map.toString() + ".build())"), (Object)SqlToJavaVisitor.this.expressionTypeManager.getExpressionSqlType(exp));
        }

        @Override
        public Pair<String, SqlType> visitStructExpression(CreateStructExpression node, Void context) {
            String schemaName = (String)SqlToJavaVisitor.this.structToCodeName.apply(node);
            StringBuilder struct = new StringBuilder("new Struct(").append(schemaName).append(")");
            for (CreateStructExpression.Field field : node.getFields()) {
                struct.append(".put(").append('\"').append(field.getName()).append('\"').append(",").append((String)((Pair)this.process(field.getValue(), context)).getLeft()).append(")");
            }
            return new Pair((Object)("((Struct)" + struct.toString() + ")"), (Object)SqlToJavaVisitor.this.expressionTypeManager.getExpressionSqlType(node));
        }

        @Override
        public Pair<String, SqlType> visitBetweenPredicate(BetweenPredicate node, Void context) {
            Pair compareMin = (Pair)this.process(new ComparisonExpression(ComparisonExpression.Type.GREATER_THAN_OR_EQUAL, node.getValue(), node.getMin()), context);
            Pair compareMax = (Pair)this.process(new ComparisonExpression(ComparisonExpression.Type.LESS_THAN_OR_EQUAL, node.getValue(), node.getMax()), context);
            return new Pair((Object)("(" + (String)compareMin.getLeft() + " && " + (String)compareMax.getLeft() + ")"), (Object)SqlTypes.BOOLEAN);
        }

        private String formatBinaryExpression(String operator, Expression left, Expression right, Void context) {
            return "(" + (String)((Pair)this.process(left, context)).getLeft() + " " + operator + " " + (String)((Pair)this.process(right, context)).getLeft() + ")";
        }

        private String trimQuotes(String s) {
            return s.substring(1, s.length() - 1);
        }
    }
}

