/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.codegen.helpers;

import io.confluent.ksql.util.KsqlException;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public final class SearchedCaseFunction {
    private SearchedCaseFunction() {
    }

    public static <T> T searchedCaseFunction(List<LazyWhenClause<T>> whenClauses, Supplier<T> defaultValue) {
        if (whenClauses.isEmpty()) {
            throw new KsqlException("When clause cannot be empty.");
        }
        return (T)whenClauses.stream().filter(clause -> (Boolean)((LazyWhenClause)clause).operand.get()).map(clause -> ((LazyWhenClause)clause).result.get()).findFirst().orElseGet(defaultValue);
    }

    public static <T> LazyWhenClause<T> whenClause(Supplier<Boolean> operand, Supplier<T> result) {
        return new LazyWhenClause(operand, result);
    }

    public static final class LazyWhenClause<T> {
        private final Supplier<Boolean> operand;
        private final Supplier<T> result;

        private LazyWhenClause(Supplier<Boolean> operand, Supplier<T> result) {
            this.operand = Objects.requireNonNull(operand, "operand");
            this.result = Objects.requireNonNull(result, "result");
        }
    }
}

