/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.ddl.commands;

import io.confluent.ksql.execution.ddl.commands.DdlCommand;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.timestamp.TimestampColumn;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.FormatOptions;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.serde.WindowInfo;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.SchemaUtil;
import java.util.Objects;
import java.util.Optional;

public abstract class CreateSourceCommand
implements DdlCommand {
    private final SourceName sourceName;
    private final LogicalSchema schema;
    private final Optional<ColumnName> keyField;
    private final Optional<TimestampColumn> timestampColumn;
    private final String topicName;
    private final Formats formats;
    private final Optional<WindowInfo> windowInfo;

    CreateSourceCommand(SourceName sourceName, LogicalSchema schema, Optional<ColumnName> keyField, Optional<TimestampColumn> timestampColumn, String topicName, Formats formats, Optional<WindowInfo> windowInfo) {
        this.sourceName = Objects.requireNonNull(sourceName, "sourceName");
        this.schema = Objects.requireNonNull(schema, "schema");
        this.keyField = Objects.requireNonNull(keyField, "keyField");
        this.timestampColumn = Objects.requireNonNull(timestampColumn, "timestampColumn");
        this.topicName = Objects.requireNonNull(topicName, "topicName");
        this.formats = Objects.requireNonNull(formats, "formats");
        this.windowInfo = Objects.requireNonNull(windowInfo, "windowInfo");
        CreateSourceCommand.validate(schema, keyField);
    }

    public SourceName getSourceName() {
        return this.sourceName;
    }

    public LogicalSchema getSchema() {
        return this.schema;
    }

    public Optional<TimestampColumn> getTimestampColumn() {
        return this.timestampColumn;
    }

    public Optional<ColumnName> getKeyField() {
        return this.keyField;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public Formats getFormats() {
        return this.formats;
    }

    public Optional<WindowInfo> getWindowInfo() {
        return this.windowInfo;
    }

    private static void validate(LogicalSchema schema, Optional<ColumnName> keyField) {
        SqlType keyType;
        SqlType keyFieldType;
        if (schema.valueContainsAny(SchemaUtil.systemColumnNames())) {
            throw new IllegalArgumentException("Schema contains system columns in value schema");
        }
        if (schema.key().size() != 1) {
            throw new UnsupportedOperationException("Only single key columns supported");
        }
        if (keyField.isPresent() && !(keyFieldType = schema.findColumn(keyField.get()).map(Column::type).orElseThrow(IllegalArgumentException::new)).equals(keyType = ((Column)schema.key().get(0)).type())) {
            throw new KsqlException("The KEY field (" + keyField.get().toString(FormatOptions.noEscape()) + ") identified in the WITH clause is of a different type to the actual key column." + System.lineSeparator() + "Either change the type of the KEY field to match ROWKEY, or explicitly set ROWKEY to the type of the KEY field by adding 'ROWKEY " + keyFieldType + " KEY' in the schema." + System.lineSeparator() + "KEY field type: " + keyFieldType + System.lineSeparator() + "ROWKEY type: " + keyType);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateSourceCommand that = (CreateSourceCommand)o;
        return Objects.equals(this.sourceName, that.sourceName) && Objects.equals(this.schema, that.schema) && Objects.equals(this.keyField, that.keyField) && Objects.equals(this.timestampColumn, that.timestampColumn) && Objects.equals(this.topicName, that.topicName) && Objects.equals(this.formats, that.formats) && Objects.equals(this.windowInfo, that.windowInfo);
    }

    public int hashCode() {
        return Objects.hash(this.sourceName, this.schema, this.keyField, this.timestampColumn, this.topicName, this.formats, this.windowInfo);
    }
}

