/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.formatter;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.ibm.icu.number.Notation;
import com.ibm.icu.number.NumberFormatter;
import com.ibm.icu.number.Precision;
import com.ibm.icu.number.UnlocalizedNumberFormatter;
import io.confluent.ksql.execution.expression.tree.ArithmeticBinaryExpression;
import io.confluent.ksql.execution.expression.tree.ArithmeticUnaryExpression;
import io.confluent.ksql.execution.expression.tree.BetweenPredicate;
import io.confluent.ksql.execution.expression.tree.BooleanLiteral;
import io.confluent.ksql.execution.expression.tree.Cast;
import io.confluent.ksql.execution.expression.tree.ComparisonExpression;
import io.confluent.ksql.execution.expression.tree.CreateArrayExpression;
import io.confluent.ksql.execution.expression.tree.CreateMapExpression;
import io.confluent.ksql.execution.expression.tree.CreateStructExpression;
import io.confluent.ksql.execution.expression.tree.DecimalLiteral;
import io.confluent.ksql.execution.expression.tree.DereferenceExpression;
import io.confluent.ksql.execution.expression.tree.DoubleLiteral;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.execution.expression.tree.InListExpression;
import io.confluent.ksql.execution.expression.tree.InPredicate;
import io.confluent.ksql.execution.expression.tree.IntegerLiteral;
import io.confluent.ksql.execution.expression.tree.IsNotNullPredicate;
import io.confluent.ksql.execution.expression.tree.IsNullPredicate;
import io.confluent.ksql.execution.expression.tree.LikePredicate;
import io.confluent.ksql.execution.expression.tree.LogicalBinaryExpression;
import io.confluent.ksql.execution.expression.tree.LongLiteral;
import io.confluent.ksql.execution.expression.tree.NotExpression;
import io.confluent.ksql.execution.expression.tree.NullLiteral;
import io.confluent.ksql.execution.expression.tree.QualifiedColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.SearchedCaseExpression;
import io.confluent.ksql.execution.expression.tree.SimpleCaseExpression;
import io.confluent.ksql.execution.expression.tree.StringLiteral;
import io.confluent.ksql.execution.expression.tree.SubscriptExpression;
import io.confluent.ksql.execution.expression.tree.TimeLiteral;
import io.confluent.ksql.execution.expression.tree.TimestampLiteral;
import io.confluent.ksql.execution.expression.tree.Type;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.WhenClause;
import io.confluent.ksql.name.Name;
import io.confluent.ksql.schema.ksql.FormatOptions;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public final class ExpressionFormatter {
    private ExpressionFormatter() {
    }

    public static String formatExpression(Expression expression) {
        return ExpressionFormatter.formatExpression(expression, FormatOptions.of(s -> false));
    }

    public static String formatExpression(Expression expression, FormatOptions formatOptions) {
        return (String)new Formatter().process(expression, new Context(formatOptions));
    }

    private static class Formatter
    implements ExpressionVisitor<String, Context> {
        private Formatter() {
        }

        @Override
        public String visitType(Type node, Context context) {
            return node.getSqlType().toString(context.formatOptions);
        }

        @Override
        public String visitBooleanLiteral(BooleanLiteral node, Context context) {
            return String.valueOf(node.getValue());
        }

        @Override
        public String visitStringLiteral(StringLiteral node, Context context) {
            return Formatter.formatStringLiteral(node.getValue());
        }

        @Override
        public String visitSubscriptExpression(SubscriptExpression node, Context context) {
            return (String)this.process(node.getBase(), context) + "[" + (String)this.process(node.getIndex(), context) + "]";
        }

        @Override
        public String visitCreateArrayExpression(CreateArrayExpression exp, Context context) {
            return exp.getValues().stream().map(val -> (String)this.process((Expression)((Object)val), context)).collect(Collectors.joining(", ", "ARRAY[", "]"));
        }

        @Override
        public String visitCreateMapExpression(CreateMapExpression exp, Context context) {
            return exp.getMap().entrySet().stream().map(entry -> (String)this.process((Expression)((Object)((Object)entry.getKey())), context) + ":=" + (String)this.process((Expression)((Object)((Object)entry.getValue())), context)).collect(Collectors.joining(", ", "MAP(", ")"));
        }

        @Override
        public String visitStructExpression(CreateStructExpression exp, Context context) {
            return exp.getFields().stream().map(struct -> context.formatOptions.escape(struct.getName()) + ":=" + (String)this.process(struct.getValue(), context)).collect(Collectors.joining(", ", "STRUCT(", ")"));
        }

        @Override
        public String visitLongLiteral(LongLiteral node, Context context) {
            return Long.toString(node.getValue());
        }

        @Override
        public String visitIntegerLiteral(IntegerLiteral node, Context context) {
            return Integer.toString(node.getValue());
        }

        @Override
        public String visitDoubleLiteral(DoubleLiteral node, Context context) {
            if (Double.compare(node.getValue(), Double.MIN_VALUE) == 0) {
                return "4.9E-324";
            }
            return ((UnlocalizedNumberFormatter)((UnlocalizedNumberFormatter)NumberFormatter.with().notation((Notation)Notation.scientific())).precision(Precision.unlimited())).locale(Locale.ROOT).format((Number)node.getValue()).toString();
        }

        @Override
        public String visitDecimalLiteral(DecimalLiteral node, Context context) {
            return node.getValue().toString();
        }

        @Override
        public String visitTimeLiteral(TimeLiteral node, Context context) {
            return "TIME '" + node.getValue() + "'";
        }

        @Override
        public String visitTimestampLiteral(TimestampLiteral node, Context context) {
            return "TIMESTAMP '" + node.getValue() + "'";
        }

        @Override
        public String visitNullLiteral(NullLiteral node, Context context) {
            return "null";
        }

        @Override
        public String visitColumnReference(UnqualifiedColumnReferenceExp node, Context context) {
            return node.getReference().toString(context.formatOptions);
        }

        @Override
        public String visitQualifiedColumnReference(QualifiedColumnReferenceExp node, Context context) {
            return Formatter.formatName(node.getQualifier(), context) + "." + node.getReference().toString(context.formatOptions);
        }

        @Override
        public String visitDereferenceExpression(DereferenceExpression node, Context context) {
            String baseString = (String)this.process(node.getBase(), context);
            return baseString + "->" + context.formatOptions.escape(node.getFieldName());
        }

        private static String formatName(Name<?> name, Context context) {
            return name.toString(context.formatOptions);
        }

        @Override
        public String visitFunctionCall(FunctionCall node, Context context) {
            StringBuilder builder = new StringBuilder();
            String arguments = this.joinExpressions(node.getArguments(), context);
            if (node.getArguments().isEmpty() && "COUNT".equals(node.getName().name())) {
                arguments = "*";
            }
            builder.append(Formatter.formatName(node.getName(), context)).append('(').append(arguments).append(')');
            return builder.toString();
        }

        @Override
        public String visitLogicalBinaryExpression(LogicalBinaryExpression node, Context context) {
            return this.formatBinaryExpression(node.getType().toString(), node.getLeft(), node.getRight(), context);
        }

        @Override
        public String visitNotExpression(NotExpression node, Context context) {
            return "(NOT " + (String)this.process(node.getValue(), context) + ")";
        }

        @Override
        public String visitComparisonExpression(ComparisonExpression node, Context context) {
            return this.formatBinaryExpression(node.getType().getValue(), node.getLeft(), node.getRight(), context);
        }

        @Override
        public String visitIsNullPredicate(IsNullPredicate node, Context context) {
            return "(" + (String)this.process(node.getValue(), context) + " IS NULL)";
        }

        @Override
        public String visitIsNotNullPredicate(IsNotNullPredicate node, Context context) {
            return "(" + (String)this.process(node.getValue(), context) + " IS NOT NULL)";
        }

        @Override
        public String visitArithmeticUnary(ArithmeticUnaryExpression node, Context context) {
            String value = (String)this.process(node.getValue(), context);
            switch (node.getSign()) {
                case MINUS: {
                    String separator = value.startsWith("-") ? " " : "";
                    return "-" + separator + value;
                }
                case PLUS: {
                    return "+" + value;
                }
            }
            throw new UnsupportedOperationException("Unsupported sign: " + (Object)((Object)node.getSign()));
        }

        @Override
        public String visitArithmeticBinary(ArithmeticBinaryExpression node, Context context) {
            return this.formatBinaryExpression(node.getOperator().getSymbol(), node.getLeft(), node.getRight(), context);
        }

        @Override
        public String visitLikePredicate(LikePredicate node, Context context) {
            return "(" + (String)this.process(node.getValue(), context) + " LIKE " + (String)this.process(node.getPattern(), context) + ')';
        }

        @Override
        public String visitCast(Cast node, Context context) {
            return "CAST(" + (String)this.process(node.getExpression(), context) + " AS " + (Object)((Object)node.getType()) + ")";
        }

        @Override
        public String visitSearchedCaseExpression(SearchedCaseExpression node, Context context) {
            ImmutableList.Builder parts = ImmutableList.builder();
            parts.add((Object)"CASE");
            for (WhenClause whenClause : node.getWhenClauses()) {
                parts.add(this.process(whenClause, context));
            }
            node.getDefaultValue().ifPresent(value -> parts.add((Object)"ELSE").add(this.process((Expression)((Object)value), context)));
            parts.add((Object)"END");
            return "(" + Joiner.on((char)' ').join((Iterable)parts.build()) + ")";
        }

        @Override
        public String visitSimpleCaseExpression(SimpleCaseExpression node, Context context) {
            ImmutableList.Builder parts = ImmutableList.builder();
            parts.add((Object)"CASE").add(this.process(node.getOperand(), context));
            for (WhenClause whenClause : node.getWhenClauses()) {
                parts.add(this.process(whenClause, context));
            }
            node.getDefaultValue().ifPresent(value -> parts.add((Object)"ELSE").add(this.process((Expression)((Object)value), context)));
            parts.add((Object)"END");
            return "(" + Joiner.on((char)' ').join((Iterable)parts.build()) + ")";
        }

        @Override
        public String visitWhenClause(WhenClause node, Context context) {
            return "WHEN " + (String)this.process(node.getOperand(), context) + " THEN " + (String)this.process(node.getResult(), context);
        }

        @Override
        public String visitBetweenPredicate(BetweenPredicate node, Context context) {
            return "(" + (String)this.process(node.getValue(), context) + " BETWEEN " + (String)this.process(node.getMin(), context) + " AND " + (String)this.process(node.getMax(), context) + ")";
        }

        @Override
        public String visitInPredicate(InPredicate node, Context context) {
            return "(" + (String)this.process(node.getValue(), context) + " IN " + (String)this.process(node.getValueList(), context) + ")";
        }

        @Override
        public String visitInListExpression(InListExpression node, Context context) {
            return "(" + this.joinExpressions(node.getValues(), context) + ")";
        }

        private String formatBinaryExpression(String operator, Expression left, Expression right, Context context) {
            return '(' + (String)this.process(left, context) + ' ' + operator + ' ' + (String)this.process(right, context) + ')';
        }

        private String joinExpressions(List<Expression> expressions, Context context) {
            return Joiner.on((String)", ").join(expressions.stream().map(e -> (String)this.process((Expression)((Object)e), context)).iterator());
        }

        private static String formatStringLiteral(String s) {
            return "'" + s.replace("'", "''") + "'";
        }
    }

    private static final class Context {
        final FormatOptions formatOptions;

        private Context(FormatOptions formatOptions) {
            this.formatOptions = formatOptions;
        }
    }
}

