/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.execution.expression.tree.Literal;
import io.confluent.ksql.parser.NodeLocation;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class TimestampLiteral
extends Literal {
    private final String value;

    public TimestampLiteral(String value) {
        this(Optional.empty(), value);
    }

    public TimestampLiteral(Optional<NodeLocation> location, String value) {
        super(location);
        this.value = Objects.requireNonNull(value, "value");
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitTimestampLiteral(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TimestampLiteral that = (TimestampLiteral)((Object)o);
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

