/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.parser.NodeLocation;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class WhenClause
extends Expression {
    private final Expression operand;
    private final Expression result;

    public WhenClause(Expression operand, Expression result) {
        this(Optional.empty(), operand, result);
    }

    public WhenClause(Optional<NodeLocation> location, Expression operand, Expression result) {
        super(location);
        this.operand = Objects.requireNonNull(operand, "operand");
        this.result = Objects.requireNonNull(result, "result");
    }

    public Expression getOperand() {
        return this.operand;
    }

    public Expression getResult() {
        return this.result;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitWhenClause(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        WhenClause that = (WhenClause)((Object)o);
        return Objects.equals((Object)this.operand, (Object)that.operand) && Objects.equals((Object)this.result, (Object)that.result);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operand, this.result});
    }
}

