/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.function;

import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.execution.expression.tree.Literal;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.execution.util.ExpressionTypeManager;
import io.confluent.ksql.function.AggregateFunctionInitArguments;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.function.KsqlAggregateFunction;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.KsqlException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class UdafUtil {
    private UdafUtil() {
    }

    public static KsqlAggregateFunction<?, ?, ?> resolveAggregateFunction(FunctionRegistry functionRegistry, FunctionCall functionCall, LogicalSchema schema) {
        try {
            ExpressionTypeManager expressionTypeManager = new ExpressionTypeManager(schema, functionRegistry);
            SqlType argumentType = expressionTypeManager.getExpressionSqlType(functionCall.getArguments().get(0));
            Expression arg = functionCall.getArguments().get(0);
            Optional possibleValueColumn = arg instanceof UnqualifiedColumnReferenceExp ? schema.findValueColumn(((UnqualifiedColumnReferenceExp)arg).getReference()) : schema.findValueColumn(ColumnName.of((String)arg.toString()));
            Column valueColumn = (Column)possibleValueColumn.orElseThrow(() -> new KsqlException("Could not find column for expression: " + (Object)((Object)arg)));
            AggregateFunctionInitArguments aggregateFunctionInitArguments = UdafUtil.createAggregateFunctionInitArgs(valueColumn.index(), functionCall);
            return functionRegistry.getAggregateFunction(functionCall.getName(), argumentType, aggregateFunctionInitArguments);
        }
        catch (Exception e) {
            throw new KsqlException("Failed to create aggregate function: " + (Object)((Object)functionCall), (Throwable)e);
        }
    }

    public static AggregateFunctionInitArguments createAggregateFunctionInitArgs(int udafIndex, FunctionCall functionCall) {
        List args = functionCall.getArguments().stream().skip(1L).map(expr -> {
            if (expr instanceof Literal) {
                return (Literal)((Object)expr);
            }
            throw new KsqlException("Aggregate function initialisation arguments must be literals");
        }).map(Literal::getValue).collect(Collectors.toList());
        return new AggregateFunctionInitArguments(udafIndex, args);
    }
}

