/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.function;

import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.types.ArrayType;
import io.confluent.ksql.function.types.GenericType;
import io.confluent.ksql.function.types.MapType;
import io.confluent.ksql.function.types.ParamType;
import io.confluent.ksql.function.types.ParamTypes;
import io.confluent.ksql.function.types.StringType;
import io.confluent.ksql.name.FunctionName;
import io.confluent.ksql.util.KsqlException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public final class UdfUtil {
    private static final Map<Type, ParamType> JAVA_TO_ARG_TYPE = ImmutableMap.builder().put(String.class, (Object)ParamTypes.STRING).put(Boolean.TYPE, (Object)ParamTypes.BOOLEAN).put(Boolean.class, (Object)ParamTypes.BOOLEAN).put(Integer.class, (Object)ParamTypes.INTEGER).put(Integer.TYPE, (Object)ParamTypes.INTEGER).put(Long.class, (Object)ParamTypes.LONG).put(Long.TYPE, (Object)ParamTypes.LONG).put(Double.class, (Object)ParamTypes.DOUBLE).put(Double.TYPE, (Object)ParamTypes.DOUBLE).put(BigDecimal.class, (Object)ParamTypes.DECIMAL).build();

    private UdfUtil() {
    }

    public static void ensureCorrectArgs(FunctionName functionName, Object[] args, Class<?> ... argTypes) {
        if (args == null) {
            throw new KsqlFunctionException("Null argument list for " + functionName.name() + ".");
        }
        if (args.length != argTypes.length) {
            throw new KsqlFunctionException("Incorrect arguments for " + functionName.name() + ".");
        }
        for (int i = 0; i < argTypes.length; ++i) {
            if (args[i] == null || argTypes[i].isAssignableFrom(args[i].getClass())) continue;
            throw new KsqlFunctionException(String.format("Incorrect arguments type for %s. Expected %s for arg number %d but found %s.", functionName.name(), argTypes[i].getCanonicalName(), i, args[i].getClass().getCanonicalName()));
        }
    }

    public static ParamType getSchemaFromType(Type type) {
        GenericType schema;
        if (type instanceof TypeVariable) {
            schema = GenericType.of((String)((TypeVariable)type).getName());
        } else {
            schema = JAVA_TO_ARG_TYPE.get(type);
            if (schema == null) {
                schema = UdfUtil.handleParameterizedType(type);
            }
        }
        return schema;
    }

    private static ParamType handleParameterizedType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (parameterizedType.getRawType() == Map.class) {
                ParamType keyType = UdfUtil.getSchemaFromType(parameterizedType.getActualTypeArguments()[0]);
                if (!(keyType instanceof StringType)) {
                    throw new KsqlException("Maps only support STRING keys, got: " + keyType);
                }
                Type valueType = ((ParameterizedType)type).getActualTypeArguments()[1];
                if (valueType instanceof TypeVariable) {
                    return MapType.of((ParamType)GenericType.of((String)((TypeVariable)valueType).getName()));
                }
                return MapType.of((ParamType)UdfUtil.getSchemaFromType(valueType));
            }
            if (parameterizedType.getRawType() == List.class) {
                Type valueType = ((ParameterizedType)type).getActualTypeArguments()[0];
                if (valueType instanceof TypeVariable) {
                    return ArrayType.of((ParamType)GenericType.of((String)((TypeVariable)valueType).getName()));
                }
                return ArrayType.of((ParamType)UdfUtil.getSchemaFromType(valueType));
            }
        } else {
            if (type instanceof Class && ((Class)type).isArray()) {
                return ArrayType.of((ParamType)UdfUtil.getSchemaFromType(((Class)type).getComponentType()));
            }
            if (type instanceof GenericArrayType) {
                return ArrayType.of((ParamType)GenericType.of((String)((GenericArrayType)type).getGenericComponentType().getTypeName()));
            }
        }
        throw new KsqlException("Type inference is not supported for: " + type);
    }
}

