/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.function.udtf;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.codegen.ExpressionMetadata;
import io.confluent.ksql.function.KsqlTableFunction;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

@Immutable
public class TableFunctionApplier {
    private final KsqlTableFunction tableFunction;
    private final ImmutableList<ExpressionMetadata> expressionMetadataList;

    public TableFunctionApplier(KsqlTableFunction tableFunction, List<ExpressionMetadata> expressionMetadataList) {
        this.tableFunction = Objects.requireNonNull(tableFunction);
        this.expressionMetadataList = ImmutableList.copyOf((Collection)Objects.requireNonNull(expressionMetadataList));
    }

    List<?> apply(GenericRow row) {
        Object[] args = new Object[this.expressionMetadataList.size()];
        int i = 0;
        for (ExpressionMetadata expressionMetadata : this.expressionMetadataList) {
            args[i++] = expressionMetadata.evaluate(row);
        }
        return this.tableFunction.apply(args);
    }
}

