/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.KeyFormat;
import io.confluent.ksql.serde.SerdeOption;
import io.confluent.ksql.serde.ValueFormat;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

@Immutable
public final class Formats {
    private final FormatInfo keyFormat;
    private final FormatInfo valueFormat;
    private final ImmutableSet<SerdeOption> options;

    public Formats(@JsonProperty(value="keyFormat", required=true) FormatInfo keyFormat, @JsonProperty(value="valueFormat", required=true) FormatInfo valueFormat, @JsonProperty(value="options", required=true) Set<SerdeOption> options) {
        this.keyFormat = Objects.requireNonNull(keyFormat, "keyFormat");
        this.valueFormat = Objects.requireNonNull(valueFormat, "valueFormat");
        this.options = ImmutableSet.copyOf((Collection)Objects.requireNonNull(options, "options"));
    }

    public FormatInfo getKeyFormat() {
        return this.keyFormat;
    }

    public FormatInfo getValueFormat() {
        return this.valueFormat;
    }

    public Set<SerdeOption> getOptions() {
        return this.options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Formats formats = (Formats)o;
        return Objects.equals(this.keyFormat, formats.keyFormat) && Objects.equals(this.valueFormat, formats.valueFormat) && Objects.equals(this.options, formats.options);
    }

    public int hashCode() {
        return Objects.hash(this.keyFormat, this.valueFormat, this.options);
    }

    public static Formats of(FormatInfo keyFormat, FormatInfo valueFormat, Set<SerdeOption> options) {
        return new Formats(keyFormat, valueFormat, options);
    }

    public static Formats of(KeyFormat keyFormat, ValueFormat valueFormat, Set<SerdeOption> options) {
        return new Formats(keyFormat.getFormatInfo(), valueFormat.getFormatInfo(), options);
    }
}

