/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import io.confluent.ksql.execution.builder.KsqlQueryBuilder;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.schema.ksql.PhysicalSchema;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.WindowInfo;
import io.confluent.ksql.testing.EffectivelyImmutable;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.streams.kstream.Windowed;

@EffectivelyImmutable
public interface KeySerdeFactory<K> {
    public Serde<K> buildKeySerde(FormatInfo var1, PhysicalSchema var2, QueryContext var3);

    public static KeySerdeFactory<Struct> unwindowed(KsqlQueryBuilder queryBuilder) {
        return queryBuilder::buildKeySerde;
    }

    public static KeySerdeFactory<Windowed<Struct>> windowed(KsqlQueryBuilder queryBuilder, WindowInfo windowInfo) {
        return (fmt, schema, ctx) -> queryBuilder.buildKeySerde(fmt, windowInfo, schema, ctx);
    }
}

