/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.ExecutionStepPropertiesV1;
import io.confluent.ksql.execution.plan.KStreamHolder;
import io.confluent.ksql.execution.plan.PlanBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Immutable
public class StreamFilter<K>
implements ExecutionStep<KStreamHolder<K>> {
    private final ExecutionStepPropertiesV1 properties;
    private final ExecutionStep<KStreamHolder<K>> source;
    private final Expression filterExpression;

    public StreamFilter(@JsonProperty(value="properties", required=true) ExecutionStepPropertiesV1 props, @JsonProperty(value="source", required=true) ExecutionStep<KStreamHolder<K>> source, @JsonProperty(value="filterExpression", required=true) Expression filterExpression) {
        this.properties = Objects.requireNonNull(props, "props");
        this.source = Objects.requireNonNull(source, "source");
        this.filterExpression = Objects.requireNonNull(filterExpression, "filterExpression");
    }

    @Override
    public ExecutionStepPropertiesV1 getProperties() {
        return this.properties;
    }

    @Override
    @JsonIgnore
    public List<ExecutionStep<?>> getSources() {
        return Collections.singletonList(this.source);
    }

    public Expression getFilterExpression() {
        return this.filterExpression;
    }

    public ExecutionStep<KStreamHolder<K>> getSource() {
        return this.source;
    }

    @Override
    public KStreamHolder<K> build(PlanBuilder builder) {
        return builder.visitStreamFilter(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamFilter that = (StreamFilter)o;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.source, that.source) && Objects.equals((Object)this.filterExpression, (Object)that.filterExpression);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.properties, this.source, this.filterExpression});
    }
}

