/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.ExecutionStepPropertiesV1;
import io.confluent.ksql.execution.plan.KStreamHolder;
import io.confluent.ksql.execution.plan.PlanBuilder;
import io.confluent.ksql.execution.plan.SelectExpression;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Immutable
public class StreamSelect<K>
implements ExecutionStep<KStreamHolder<K>> {
    private final ExecutionStepPropertiesV1 properties;
    private final ExecutionStep<KStreamHolder<K>> source;
    private final ImmutableList<SelectExpression> selectExpressions;

    public StreamSelect(@JsonProperty(value="properties", required=true) ExecutionStepPropertiesV1 props, @JsonProperty(value="source", required=true) ExecutionStep<KStreamHolder<K>> source, @JsonProperty(value="selectExpressions", required=true) List<SelectExpression> selectExpressions) {
        this.properties = Objects.requireNonNull(props, "props");
        this.source = Objects.requireNonNull(source, "source");
        this.selectExpressions = ImmutableList.copyOf(selectExpressions);
    }

    @Override
    public ExecutionStepPropertiesV1 getProperties() {
        return this.properties;
    }

    @Override
    @JsonIgnore
    public List<ExecutionStep<?>> getSources() {
        return Collections.singletonList(this.source);
    }

    public List<SelectExpression> getSelectExpressions() {
        return this.selectExpressions;
    }

    public ExecutionStep<KStreamHolder<K>> getSource() {
        return this.source;
    }

    @Override
    public KStreamHolder<K> build(PlanBuilder builder) {
        return builder.visitStreamSelect(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamSelect that = (StreamSelect)o;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.source, that.source) && Objects.equals(this.selectExpressions, that.selectExpressions);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.source, this.selectExpressions);
    }
}

