/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.ExecutionStepPropertiesV1;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.KStreamHolder;
import io.confluent.ksql.execution.plan.PlanBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Immutable
public class StreamSink<K>
implements ExecutionStep<KStreamHolder<K>> {
    private final ExecutionStepPropertiesV1 properties;
    private final ExecutionStep<KStreamHolder<K>> source;
    private final Formats formats;
    private final String topicName;

    public StreamSink(@JsonProperty(value="properties", required=true) ExecutionStepPropertiesV1 props, @JsonProperty(value="source", required=true) ExecutionStep<KStreamHolder<K>> source, @JsonProperty(value="formats", required=true) Formats formats, @JsonProperty(value="topicName", required=true) String topicName) {
        this.properties = Objects.requireNonNull(props, "props");
        this.formats = Objects.requireNonNull(formats, "formats");
        this.source = Objects.requireNonNull(source, "source");
        this.topicName = Objects.requireNonNull(topicName, "topicName");
    }

    public String getTopicName() {
        return this.topicName;
    }

    @Override
    public ExecutionStepPropertiesV1 getProperties() {
        return this.properties;
    }

    @Override
    public List<ExecutionStep<?>> getSources() {
        return Collections.singletonList(this.source);
    }

    public Formats getFormats() {
        return this.formats;
    }

    public ExecutionStep<KStreamHolder<K>> getSource() {
        return this.source;
    }

    @Override
    public KStreamHolder<K> build(PlanBuilder builder) {
        return builder.visitStreamSink(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamSink that = (StreamSink)o;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.source, that.source) && Objects.equals(this.formats, that.formats) && Objects.equals(this.topicName, that.topicName);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.source, this.formats, this.topicName);
    }
}

