/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.ExecutionStepPropertiesV1;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.JoinType;
import io.confluent.ksql.execution.plan.KStreamHolder;
import io.confluent.ksql.execution.plan.PlanBuilder;
import java.time.Duration;
import java.util.List;
import java.util.Objects;

@Immutable
public class StreamStreamJoin<K>
implements ExecutionStep<KStreamHolder<K>> {
    private final ExecutionStepPropertiesV1 properties;
    private final JoinType joinType;
    private final Formats leftInternalFormats;
    private final Formats rightInternalFormats;
    private final ExecutionStep<KStreamHolder<K>> leftSource;
    private final ExecutionStep<KStreamHolder<K>> rightSource;
    private final Duration beforeMillis;
    private final Duration afterMillis;

    public StreamStreamJoin(@JsonProperty(value="properties", required=true) ExecutionStepPropertiesV1 props, @JsonProperty(value="joinType", required=true) JoinType joinType, @JsonProperty(value="leftInternalFormats", required=true) Formats leftIntFormats, @JsonProperty(value="rightInternalFormats", required=true) Formats rightIntFormats, @JsonProperty(value="leftSource", required=true) ExecutionStep<KStreamHolder<K>> leftSource, @JsonProperty(value="rightSource", required=true) ExecutionStep<KStreamHolder<K>> rightSource, @JsonProperty(value="beforeMillis", required=true) Duration beforeMillis, @JsonProperty(value="afterMillis", required=true) Duration afterMillis) {
        this.properties = Objects.requireNonNull(props, "props");
        this.leftInternalFormats = Objects.requireNonNull(leftIntFormats, "leftIntFormats");
        this.rightInternalFormats = Objects.requireNonNull(rightIntFormats, "rightIntFormats");
        this.joinType = Objects.requireNonNull(joinType, "joinType");
        this.leftSource = Objects.requireNonNull(leftSource, "leftSource");
        this.rightSource = Objects.requireNonNull(rightSource, "rightSource");
        this.beforeMillis = Objects.requireNonNull(beforeMillis, "beforeMillis");
        this.afterMillis = Objects.requireNonNull(afterMillis, "afterMillis");
    }

    @Override
    public ExecutionStepPropertiesV1 getProperties() {
        return this.properties;
    }

    @Override
    @JsonIgnore
    public List<ExecutionStep<?>> getSources() {
        return ImmutableList.of(this.leftSource, this.rightSource);
    }

    public Formats getLeftInternalFormats() {
        return this.leftInternalFormats;
    }

    public Formats getRightInternalFormats() {
        return this.rightInternalFormats;
    }

    public ExecutionStep<KStreamHolder<K>> getLeftSource() {
        return this.leftSource;
    }

    public ExecutionStep<KStreamHolder<K>> getRightSource() {
        return this.rightSource;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public Duration getAfterMillis() {
        return this.afterMillis;
    }

    public Duration getBeforeMillis() {
        return this.beforeMillis;
    }

    @Override
    public KStreamHolder<K> build(PlanBuilder builder) {
        return builder.visitStreamStreamJoin(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamStreamJoin that = (StreamStreamJoin)o;
        return Objects.equals(this.properties, that.properties) && this.joinType == that.joinType && Objects.equals(this.leftInternalFormats, that.leftInternalFormats) && Objects.equals(this.rightInternalFormats, that.rightInternalFormats) && Objects.equals(this.leftSource, that.leftSource) && Objects.equals(this.rightSource, that.rightSource) && Objects.equals(this.beforeMillis, that.beforeMillis) && Objects.equals(this.afterMillis, that.afterMillis);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.properties, this.joinType, this.leftInternalFormats, this.rightInternalFormats, this.leftSource, this.rightSource, this.beforeMillis, this.afterMillis});
    }
}

