/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.ExecutionStepPropertiesV1;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.KGroupedTableHolder;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.plan.PlanBuilder;
import io.confluent.ksql.name.ColumnName;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.connect.data.Struct;

@Immutable
public class TableAggregate
implements ExecutionStep<KTableHolder<Struct>> {
    private final ExecutionStepPropertiesV1 properties;
    private final ExecutionStep<KGroupedTableHolder> source;
    private final Formats internalFormats;
    private final ImmutableList<FunctionCall> aggregationFunctions;
    private final ImmutableList<ColumnName> nonAggregateColumns;

    public TableAggregate(@JsonProperty(value="properties", required=true) ExecutionStepPropertiesV1 props, @JsonProperty(value="source", required=true) ExecutionStep<KGroupedTableHolder> source, @JsonProperty(value="internalFormats", required=true) Formats internalFormats, @JsonProperty(value="nonAggregateColumns", required=true) List<ColumnName> nonAggregateColumns, @JsonProperty(value="aggregationFunctions", required=true) List<FunctionCall> aggregationFunctions) {
        this.properties = Objects.requireNonNull(props, "props");
        this.source = Objects.requireNonNull(source, "source");
        this.internalFormats = Objects.requireNonNull(internalFormats, "internalFormats");
        this.nonAggregateColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(nonAggregateColumns, "nonAggregatecolumns"));
        this.aggregationFunctions = ImmutableList.copyOf((Collection)Objects.requireNonNull(aggregationFunctions, "aggValToFunctionMap"));
    }

    @Override
    public ExecutionStepPropertiesV1 getProperties() {
        return this.properties;
    }

    @Override
    @JsonIgnore
    public List<ExecutionStep<?>> getSources() {
        return Collections.singletonList(this.source);
    }

    public Formats getInternalFormats() {
        return this.internalFormats;
    }

    public List<FunctionCall> getAggregationFunctions() {
        return this.aggregationFunctions;
    }

    public List<ColumnName> getNonAggregateColumns() {
        return this.nonAggregateColumns;
    }

    public ExecutionStep<KGroupedTableHolder> getSource() {
        return this.source;
    }

    @Override
    public KTableHolder<Struct> build(PlanBuilder builder) {
        return builder.visitTableAggregate(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableAggregate that = (TableAggregate)o;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.source, that.source) && Objects.equals(this.internalFormats, that.internalFormats) && Objects.equals(this.aggregationFunctions, that.aggregationFunctions) && Objects.equals(this.nonAggregateColumns, that.nonAggregateColumns);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.source, this.internalFormats, this.nonAggregateColumns, this.aggregationFunctions);
    }
}

