/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.ExecutionStepPropertiesV1;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.plan.PlanBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Immutable
public class TableSink<K>
implements ExecutionStep<KTableHolder<K>> {
    private final ExecutionStepPropertiesV1 properties;
    private final ExecutionStep<KTableHolder<K>> source;
    private final Formats formats;
    private final String topicName;

    public TableSink(@JsonProperty(value="properties", required=true) ExecutionStepPropertiesV1 props, @JsonProperty(value="source", required=true) ExecutionStep<KTableHolder<K>> source, @JsonProperty(value="formats", required=true) Formats formats, @JsonProperty(value="topicName", required=true) String topicName) {
        this.properties = Objects.requireNonNull(props, "props");
        this.source = Objects.requireNonNull(source, "source");
        this.formats = Objects.requireNonNull(formats, "formats");
        this.topicName = Objects.requireNonNull(topicName, "topicName");
    }

    @Override
    public ExecutionStepPropertiesV1 getProperties() {
        return this.properties;
    }

    public String getTopicName() {
        return this.topicName;
    }

    @Override
    @JsonIgnore
    public List<ExecutionStep<?>> getSources() {
        return Collections.singletonList(this.source);
    }

    public Formats getFormats() {
        return this.formats;
    }

    public ExecutionStep<KTableHolder<K>> getSource() {
        return this.source;
    }

    @Override
    public KTableHolder<K> build(PlanBuilder builder) {
        return builder.visitTableSink(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableSink tableSink = (TableSink)o;
        return Objects.equals(this.properties, tableSink.properties) && Objects.equals(this.source, tableSink.source) && Objects.equals(this.formats, tableSink.formats) && Objects.equals(this.topicName, tableSink.topicName);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.source, this.formats, this.topicName);
    }
}

