/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.transform.select;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.execution.codegen.CodeGenRunner;
import io.confluent.ksql.execution.codegen.ExpressionMetadata;
import io.confluent.ksql.execution.plan.SelectExpression;
import io.confluent.ksql.execution.transform.select.SelectValueMapper;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.util.KsqlConfig;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class SelectValueMapperFactory {
    private static final String EXP_TYPE = "Select";
    private final CodeGenRunner codeGenerator;

    @VisibleForTesting
    SelectValueMapperFactory(CodeGenRunner codeGenerator) {
        this.codeGenerator = Objects.requireNonNull(codeGenerator, "codeGenerator");
    }

    public static <K> SelectValueMapper<K> create(List<SelectExpression> selectExpressions, LogicalSchema sourceSchema, KsqlConfig ksqlConfig, FunctionRegistry functionRegistry) {
        CodeGenRunner codeGen = new CodeGenRunner(sourceSchema, ksqlConfig, functionRegistry);
        return new SelectValueMapperFactory(codeGen).create(selectExpressions);
    }

    @VisibleForTesting
    <K> SelectValueMapper<K> create(List<SelectExpression> selectExpressions) {
        return new SelectValueMapper(this.buildSelects(selectExpressions));
    }

    private List<SelectValueMapper.SelectInfo> buildSelects(List<SelectExpression> selectExpressions) {
        return selectExpressions.stream().map(this::buildSelect).collect(Collectors.toList());
    }

    private SelectValueMapper.SelectInfo buildSelect(SelectExpression selectExpression) {
        ExpressionMetadata evaluator = this.codeGenerator.buildCodeGenFromParseTree(selectExpression.getExpression(), EXP_TYPE);
        return SelectValueMapper.SelectInfo.of(selectExpression.getAlias(), evaluator);
    }
}

