/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.transform.select;

import io.confluent.ksql.execution.plan.SelectExpression;
import io.confluent.ksql.execution.transform.select.SelectValueMapper;
import io.confluent.ksql.execution.transform.select.SelectValueMapperFactory;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.util.KsqlConfig;
import java.util.List;
import java.util.Objects;

public final class Selection<K> {
    private final SelectValueMapper<K> mapper;
    private final LogicalSchema schema;

    public static <K> Selection<K> of(LogicalSchema sourceSchema, List<SelectExpression> selectExpressions, KsqlConfig ksqlConfig, FunctionRegistry functionRegistry) {
        SelectValueMapper mapper = SelectValueMapperFactory.create(selectExpressions, sourceSchema, ksqlConfig, functionRegistry);
        LogicalSchema schema = Selection.buildSchema(sourceSchema, mapper);
        return new Selection(mapper, schema);
    }

    private static LogicalSchema buildSchema(LogicalSchema sourceSchema, SelectValueMapper<?> mapper) {
        LogicalSchema.Builder schemaBuilder = LogicalSchema.builder();
        List keyCols = sourceSchema.key();
        schemaBuilder.keyColumns((Iterable)keyCols);
        for (SelectValueMapper.SelectInfo select : mapper.getSelects()) {
            schemaBuilder.valueColumn(select.getFieldName(), select.getEvaluator().getExpressionType());
        }
        return schemaBuilder.build();
    }

    private Selection(SelectValueMapper<K> mapper, LogicalSchema schema) {
        this.mapper = Objects.requireNonNull(mapper, "mapper");
        this.schema = Objects.requireNonNull(schema, "schema");
    }

    public SelectValueMapper<K> getMapper() {
        return this.mapper;
    }

    public LogicalSchema getSchema() {
        return this.schema;
    }
}

