/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.util;

import io.confluent.ksql.execution.expression.tree.ComparisonExpression;
import io.confluent.ksql.schema.ksql.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.KsqlException;

final class ComparisonUtil {
    private ComparisonUtil() {
    }

    static boolean isValidComparison(SqlType left, ComparisonExpression.Type operator, SqlType right) {
        if (left.baseType().isNumber() && right.baseType().isNumber()) {
            return true;
        }
        if (left.baseType() == SqlBaseType.STRING && right.baseType() == SqlBaseType.STRING) {
            return true;
        }
        if (left.baseType() == SqlBaseType.BOOLEAN && right.baseType() == SqlBaseType.BOOLEAN && (operator == ComparisonExpression.Type.EQUAL || operator == ComparisonExpression.Type.NOT_EQUAL)) {
            return true;
        }
        throw new KsqlException("Operator " + (Object)((Object)operator) + " cannot be used to compare " + left.baseType() + " and " + right.baseType());
    }
}

