/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.util;

import io.confluent.ksql.GenericRow;
import io.confluent.ksql.json.JsonMapper;
import io.confluent.ksql.logging.processing.ProcessingLogConfig;
import io.confluent.ksql.logging.processing.ProcessingLogMessageSchema;
import io.confluent.ksql.util.ErrorMessageUtil;
import java.util.List;
import java.util.function.Function;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EngineProcessingLogMessageFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(EngineProcessingLogMessageFactory.class);

    private EngineProcessingLogMessageFactory() {
    }

    public static Function<ProcessingLogConfig, SchemaAndValue> recordProcessingError(String errorMsg, Throwable exception, GenericRow record) {
        return config -> {
            Struct struct = new Struct(ProcessingLogMessageSchema.PROCESSING_LOG_SCHEMA);
            struct.put("type", (Object)ProcessingLogMessageSchema.MessageType.RECORD_PROCESSING_ERROR.getTypeId());
            Struct recordProcessingError = new Struct(ProcessingLogMessageSchema.MessageType.RECORD_PROCESSING_ERROR.getSchema());
            struct.put("recordProcessingError", (Object)recordProcessingError);
            recordProcessingError.put("errorMessage", (Object)errorMsg);
            List cause = ErrorMessageUtil.getErrorMessages((Throwable)exception);
            cause.remove(0);
            recordProcessingError.put("cause", (Object)cause);
            if (record == null) {
                return new SchemaAndValue(ProcessingLogMessageSchema.PROCESSING_LOG_SCHEMA, (Object)struct);
            }
            recordProcessingError.put("record", (Object)EngineProcessingLogMessageFactory.serializeRow(config, record));
            return new SchemaAndValue(ProcessingLogMessageSchema.PROCESSING_LOG_SCHEMA, (Object)struct);
        };
    }

    private static String serializeRow(ProcessingLogConfig config, GenericRow record) {
        if (!config.getBoolean(ProcessingLogConfig.INCLUDE_ROWS).booleanValue()) {
            return null;
        }
        try {
            return JsonMapper.INSTANCE.mapper.writeValueAsString((Object)record.values());
        }
        catch (Throwable t) {
            LOGGER.error("error serializing record for processing log", t);
            return null;
        }
    }
}

