/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.util;

import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.SchemaUtil;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public final class StructKeyUtil {
    private StructKeyUtil() {
    }

    public static KeyBuilder keyBuilder(LogicalSchema schema) {
        List keyCols = schema.key();
        if (keyCols.size() != 1) {
            throw new UnsupportedOperationException("Only single keys supported");
        }
        SqlType sqlType = ((Column)keyCols.get(0)).type();
        return StructKeyUtil.keyBuilder(sqlType);
    }

    public static KeyBuilder keyBuilder(SqlType sqlType) {
        Schema connectSchema = SchemaConverters.sqlToConnectConverter().toConnectSchema(sqlType);
        return new KeyBuilder(SchemaBuilder.struct().field(SchemaUtil.ROWKEY_NAME.name(), connectSchema).build());
    }

    public static final class KeyBuilder {
        private final Schema keySchema;
        private final Field keyField;

        private KeyBuilder(Schema keySchema) {
            this.keySchema = Objects.requireNonNull(keySchema, "keySchema");
            this.keyField = keySchema.field(SchemaUtil.ROWKEY_NAME.name());
        }

        public Struct build(Object rowKey) {
            Struct keyStruct = new Struct(this.keySchema);
            keyStruct.put(this.keyField, rowKey);
            return keyStruct;
        }
    }
}

