/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.windows;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.windows.KsqlWindowExpression;
import io.confluent.ksql.execution.windows.WindowVisitor;
import io.confluent.ksql.model.WindowType;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.serde.WindowInfo;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

@Immutable
public class HoppingWindowExpression
extends KsqlWindowExpression {
    private final long size;
    private final TimeUnit sizeUnit;
    private final long advanceBy;
    private final TimeUnit advanceByUnit;

    public HoppingWindowExpression(long size, TimeUnit sizeUnit, long advanceBy, TimeUnit advanceByUnit) {
        this(Optional.empty(), size, sizeUnit, advanceBy, advanceByUnit);
    }

    public HoppingWindowExpression(Optional<NodeLocation> location, long size, TimeUnit sizeUnit, long advanceBy, TimeUnit advanceByUnit) {
        super(location);
        this.size = size;
        this.sizeUnit = Objects.requireNonNull(sizeUnit, "sizeUnit");
        this.advanceBy = advanceBy;
        this.advanceByUnit = Objects.requireNonNull(advanceByUnit, "advanceByUnit");
    }

    @Override
    public WindowInfo getWindowInfo() {
        return WindowInfo.of((WindowType)WindowType.HOPPING, Optional.of(Duration.ofNanos(this.sizeUnit.toNanos(this.size))));
    }

    public TimeUnit getSizeUnit() {
        return this.sizeUnit;
    }

    public long getSize() {
        return this.size;
    }

    public TimeUnit getAdvanceByUnit() {
        return this.advanceByUnit;
    }

    public long getAdvanceBy() {
        return this.advanceBy;
    }

    @Override
    public <R, C> R accept(WindowVisitor<R, C> visitor, C context) {
        return visitor.visitHoppingWindowExpression(this, context);
    }

    public String toString() {
        return " HOPPING ( SIZE " + this.size + " " + (Object)((Object)this.sizeUnit) + " , ADVANCE BY " + this.advanceBy + " " + (Object)((Object)this.advanceByUnit) + " ) ";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.size, this.sizeUnit, this.advanceBy, this.advanceByUnit});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        HoppingWindowExpression hoppingWindowExpression = (HoppingWindowExpression)((Object)o);
        return hoppingWindowExpression.size == this.size && hoppingWindowExpression.sizeUnit == this.sizeUnit && hoppingWindowExpression.advanceBy == this.advanceBy && hoppingWindowExpression.advanceByUnit == this.advanceByUnit;
    }
}

