/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.windows;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.windows.KsqlWindowExpression;
import io.confluent.ksql.execution.windows.WindowVisitor;
import io.confluent.ksql.model.WindowType;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.serde.WindowInfo;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

@Immutable
public class SessionWindowExpression
extends KsqlWindowExpression {
    private final long gap;
    private final TimeUnit sizeUnit;

    public SessionWindowExpression(long gap, TimeUnit sizeUnit) {
        this(Optional.empty(), gap, sizeUnit);
    }

    public SessionWindowExpression(Optional<NodeLocation> location, long gap, TimeUnit sizeUnit) {
        super(location);
        this.gap = gap;
        this.sizeUnit = Objects.requireNonNull(sizeUnit, "sizeUnit");
    }

    public TimeUnit getSizeUnit() {
        return this.sizeUnit;
    }

    public long getGap() {
        return this.gap;
    }

    @Override
    public WindowInfo getWindowInfo() {
        return WindowInfo.of((WindowType)WindowType.SESSION, Optional.empty());
    }

    @Override
    public <R, C> R accept(WindowVisitor<R, C> visitor, C context) {
        return visitor.visitSessionWindowExpression(this, context);
    }

    public String toString() {
        return " SESSION ( " + this.gap + " " + (Object)((Object)this.sizeUnit) + " ) ";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.gap, this.sizeUnit});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SessionWindowExpression sessionWindowExpression = (SessionWindowExpression)((Object)o);
        return sessionWindowExpression.gap == this.gap && sessionWindowExpression.sizeUnit == this.sizeUnit;
    }
}

