/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.windows;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.windows.KsqlWindowExpression;
import io.confluent.ksql.execution.windows.WindowVisitor;
import io.confluent.ksql.model.WindowType;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.serde.WindowInfo;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

@Immutable
public class TumblingWindowExpression
extends KsqlWindowExpression {
    private final long size;
    private final TimeUnit sizeUnit;

    public TumblingWindowExpression(long size, TimeUnit sizeUnit) {
        this(Optional.empty(), size, sizeUnit);
    }

    public TumblingWindowExpression(Optional<NodeLocation> location, long size, TimeUnit sizeUnit) {
        super(location);
        this.size = size;
        this.sizeUnit = Objects.requireNonNull(sizeUnit, "sizeUnit");
    }

    @Override
    public WindowInfo getWindowInfo() {
        return WindowInfo.of((WindowType)WindowType.TUMBLING, Optional.of(Duration.ofNanos(this.sizeUnit.toNanos(this.size))));
    }

    public TimeUnit getSizeUnit() {
        return this.sizeUnit;
    }

    public long getSize() {
        return this.size;
    }

    @Override
    public <R, C> R accept(WindowVisitor<R, C> visitor, C context) {
        return visitor.visitTumblingWindowExpression(this, context);
    }

    public String toString() {
        return " TUMBLING ( SIZE " + this.size + " " + (Object)((Object)this.sizeUnit) + " ) ";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.size, this.sizeUnit});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TumblingWindowExpression tumblingWindowExpression = (TumblingWindowExpression)((Object)o);
        return tumblingWindowExpression.size == this.size && tumblingWindowExpression.sizeUnit == this.sizeUnit;
    }
}

