/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.services;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.TopicDescription;

public interface KafkaTopicClient {
    default public void validateCreateTopic(String topic, int numPartitions, short replicationFactor) {
        this.validateCreateTopic(topic, numPartitions, replicationFactor, Collections.emptyMap());
    }

    default public void validateCreateTopic(String topic, int numPartitions, short replicationFactor, Map<String, ?> configs) {
        this.createTopic(topic, numPartitions, replicationFactor, configs, new CreateTopicsOptions().validateOnly(true));
    }

    default public void createTopic(String topic, int numPartitions, short replicationFactor) {
        this.createTopic(topic, numPartitions, replicationFactor, Collections.emptyMap());
    }

    default public void createTopic(String topic, int numPartitions, short replicationFactor, Map<String, ?> configs) {
        this.createTopic(topic, numPartitions, replicationFactor, configs, new CreateTopicsOptions());
    }

    public void createTopic(String var1, int var2, short var3, Map<String, ?> var4, CreateTopicsOptions var5);

    public boolean isTopicExists(String var1);

    public Set<String> listTopicNames();

    public Map<String, TopicDescription> describeTopics(Collection<String> var1);

    default public TopicDescription describeTopic(String topicName) {
        return this.describeTopics((Collection<String>)ImmutableList.of((Object)topicName)).get(topicName);
    }

    public Map<String, String> getTopicConfig(String var1);

    public boolean addTopicConfig(String var1, Map<String, ?> var2);

    public TopicCleanupPolicy getTopicCleanupPolicy(String var1);

    public void deleteTopics(Collection<String> var1);

    public void deleteInternalTopics(String var1);

    public static enum TopicCleanupPolicy {
        COMPACT,
        DELETE,
        COMPACT_DELETE;

    }
}

