/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser;

import io.confluent.ksql.metastore.TypeRegistry;
import io.confluent.ksql.parser.AstBuilder;
import io.confluent.ksql.parser.CaseInsensitiveStream;
import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.ParsingException;
import io.confluent.ksql.parser.SqlBaseLexer;
import io.confluent.ksql.parser.SqlBaseParser;
import io.confluent.ksql.parser.exception.ParseFailedException;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.util.ParserUtil;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.misc.ParseCancellationException;

public class DefaultKsqlParser
implements KsqlParser {
    private static final BaseErrorListener ERROR_LISTENER = new BaseErrorListener(){

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e) {
            if (offendingSymbol instanceof Token && DefaultKsqlParser.isKeywordError(message, ((Token)offendingSymbol).getText())) {
                String tokenName = ((Token)offendingSymbol).getText();
                String newMessage = "\"" + tokenName + "\" is a reserved keyword and it can't be used as an identifier. You can use it as an identifier by escaping it as '" + tokenName + "' ";
                throw new ParsingException(newMessage, e, line, charPositionInLine);
            }
            throw new ParsingException(message, e, line, charPositionInLine);
        }
    };

    @Override
    public List<KsqlParser.ParsedStatement> parse(String sql) {
        try {
            SqlBaseParser.StatementsContext statementsContext = DefaultKsqlParser.getParseTree(sql);
            return statementsContext.singleStatement().stream().map(DefaultKsqlParser::parsedStatement).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new ParseFailedException(e.getMessage(), sql, e);
        }
    }

    public static KsqlParser.ParsedStatement parsedStatement(SqlBaseParser.SingleStatementContext statement) {
        return KsqlParser.ParsedStatement.of(DefaultKsqlParser.getStatementString(statement), statement);
    }

    @Override
    public KsqlParser.PreparedStatement<?> prepare(KsqlParser.ParsedStatement stmt, TypeRegistry typeRegistry) {
        try {
            AstBuilder astBuilder = new AstBuilder(typeRegistry);
            Statement root = astBuilder.buildStatement(stmt.getStatement());
            return KsqlParser.PreparedStatement.of(stmt.getStatementText(), root);
        }
        catch (ParseFailedException e) {
            if (!e.getSqlStatement().isEmpty()) {
                throw e;
            }
            throw new ParseFailedException(e.getRawMessage(), stmt.getStatementText(), e.getCause());
        }
        catch (Exception e) {
            throw new ParseFailedException("Failed to prepare statement: " + e.getMessage(), stmt.getStatementText(), e);
        }
    }

    private static SqlBaseParser.StatementsContext getParseTree(String sql) {
        SqlBaseLexer sqlBaseLexer = new SqlBaseLexer(new CaseInsensitiveStream((CharStream)CharStreams.fromString((String)sql)));
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)sqlBaseLexer);
        SqlBaseParser sqlBaseParser = new SqlBaseParser((TokenStream)tokenStream);
        sqlBaseLexer.removeErrorListeners();
        sqlBaseLexer.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
        sqlBaseParser.removeErrorListeners();
        sqlBaseParser.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
        Function<SqlBaseParser, ParserRuleContext> parseFunction = SqlBaseParser::statements;
        try {
            ((ParserATNSimulator)sqlBaseParser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            return (SqlBaseParser.StatementsContext)parseFunction.apply(sqlBaseParser);
        }
        catch (ParseCancellationException ex) {
            tokenStream.seek(0);
            sqlBaseParser.reset();
            ((ParserATNSimulator)sqlBaseParser.getInterpreter()).setPredictionMode(PredictionMode.LL);
            return (SqlBaseParser.StatementsContext)parseFunction.apply(sqlBaseParser);
        }
    }

    private static String getStatementString(SqlBaseParser.SingleStatementContext singleStatementContext) {
        CharStream charStream = singleStatementContext.start.getInputStream();
        return charStream.getText(Interval.of((int)singleStatementContext.start.getStartIndex(), (int)singleStatementContext.stop.getStopIndex()));
    }

    private static boolean isKeywordError(String message, String offendingSymbol) {
        Matcher m = ParserUtil.EXTRANEOUS_INPUT_PATTERN.matcher(message);
        return m.find() && ParserUtil.isReserved(offendingSymbol);
    }
}

