/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.properties.with;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.IntegerLiteral;
import io.confluent.ksql.execution.expression.tree.Literal;
import io.confluent.ksql.execution.expression.tree.StringLiteral;
import io.confluent.ksql.model.WindowType;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.parser.ColumnReferenceParser;
import io.confluent.ksql.parser.DurationParser;
import io.confluent.ksql.parser.properties.with.PropertiesConfig;
import io.confluent.ksql.properties.with.CommonCreateConfigs;
import io.confluent.ksql.properties.with.CreateConfigs;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.testing.EffectivelyImmutable;
import io.confluent.ksql.util.KsqlException;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.kafka.common.config.ConfigException;

@Immutable
public final class CreateSourceProperties {
    private final PropertiesConfig props;
    @EffectivelyImmutable
    private final transient Function<String, Duration> durationParser;

    public static CreateSourceProperties from(Map<String, Literal> literals) {
        try {
            return new CreateSourceProperties(literals, DurationParser::parse);
        }
        catch (ConfigException e) {
            String message = e.getMessage().replace("configuration", "property");
            throw new KsqlException(message, (Throwable)e);
        }
    }

    @VisibleForTesting
    CreateSourceProperties(Map<String, Literal> originals, Function<String, Duration> durationParser) {
        this.props = new PropertiesConfig(CreateConfigs.CONFIG_METADATA, originals);
        this.durationParser = Objects.requireNonNull(durationParser, "durationParser");
        CommonCreateConfigs.validateKeyValueFormats((Map)this.props.originals());
        this.props.validateDateTimeFormat("TIMESTAMP_FORMAT");
        this.validateWindowInfo();
    }

    public String getKafkaTopic() {
        return this.props.getString("KAFKA_TOPIC");
    }

    public Optional<Integer> getPartitions() {
        return Optional.ofNullable(this.props.getInt("PARTITIONS"));
    }

    public Optional<Short> getReplicas() {
        return Optional.ofNullable(this.props.getShort("REPLICAS"));
    }

    public Optional<WindowType> getWindowType() {
        try {
            return Optional.ofNullable(this.props.getString("WINDOW_TYPE")).map(WindowType::of);
        }
        catch (Exception e) {
            throw new KsqlException("Error in WITH clause property 'WINDOW_TYPE': " + e.getMessage(), (Throwable)e);
        }
    }

    public Optional<Duration> getWindowSize() {
        try {
            return Optional.ofNullable(this.props.getString("WINDOW_SIZE")).map(this.durationParser);
        }
        catch (Exception e) {
            throw new KsqlException("Error in WITH clause property 'WINDOW_SIZE': " + e.getMessage() + System.lineSeparator() + "Example valid value: '10 SECONDS'", (Throwable)e);
        }
    }

    public Optional<ColumnName> getTimestampColumnName() {
        return Optional.ofNullable(this.props.getString("TIMESTAMP")).map(ColumnReferenceParser::parse);
    }

    public Optional<String> getTimestampFormat() {
        return Optional.ofNullable(this.props.getString("TIMESTAMP_FORMAT"));
    }

    public Optional<Integer> getKeySchemaId() {
        return Optional.ofNullable(this.props.getInt("KEY_SCHEMA_ID"));
    }

    public Optional<Integer> getValueSchemaId() {
        return Optional.ofNullable(this.props.getInt("VALUE_SCHEMA_ID"));
    }

    public Optional<FormatInfo> getKeyFormat() {
        String keyFormat = this.getFormatName().orElse(this.props.getString("KEY_FORMAT"));
        return Optional.ofNullable(keyFormat).map(format -> FormatInfo.of((String)format, (Map)ImmutableMap.of()));
    }

    public Optional<FormatInfo> getValueFormat() {
        String valueFormat = this.getFormatName().orElse(this.props.getString("VALUE_FORMAT"));
        return Optional.ofNullable(valueFormat).map(format -> FormatInfo.of((String)format, this.getValueFormatProperties()));
    }

    public Map<String, String> getValueFormatProperties() {
        String delimiter;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String schemaName = this.props.getString("VALUE_AVRO_SCHEMA_FULL_NAME");
        if (schemaName != null) {
            builder.put((Object)"fullSchemaName", (Object)schemaName);
        }
        if ((delimiter = this.props.getString("VALUE_DELIMITER")) != null) {
            builder.put((Object)"delimiter", (Object)delimiter);
        }
        return builder.build();
    }

    public SerdeFeatures getValueSerdeFeatures() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Boolean wrapping = this.props.getBoolean("WRAP_SINGLE_VALUE");
        if (wrapping != null) {
            builder.add((Object)(wrapping != false ? SerdeFeature.WRAP_SINGLES : SerdeFeature.UNWRAP_SINGLES));
        }
        return SerdeFeatures.from((Set)builder.build());
    }

    public CreateSourceProperties withSchemaIds(Optional<Integer> keySchemaId, Optional<Integer> valueSchemaId) {
        Map<String, Literal> originals = this.props.copyOfOriginalLiterals();
        keySchemaId.ifPresent(id -> {
            Literal cfr_ignored_0 = (Literal)originals.put("KEY_SCHEMA_ID", (Literal)new IntegerLiteral(id.intValue()));
        });
        valueSchemaId.ifPresent(id -> {
            Literal cfr_ignored_0 = (Literal)originals.put("VALUE_SCHEMA_ID", (Literal)new IntegerLiteral(id.intValue()));
        });
        return new CreateSourceProperties(originals, this.durationParser);
    }

    public CreateSourceProperties withPartitionsAndReplicas(int partitions, short replicas) {
        Map<String, Literal> originals = this.props.copyOfOriginalLiterals();
        originals.put("PARTITIONS", (Literal)new IntegerLiteral(partitions));
        originals.put("REPLICAS", (Literal)new IntegerLiteral((int)replicas));
        return new CreateSourceProperties(originals, this.durationParser);
    }

    public CreateSourceProperties withFormats(String keyFormat, String valueFormat) {
        Map<String, Literal> originals = this.props.copyOfOriginalLiterals();
        originals.put("KEY_FORMAT", (Literal)new StringLiteral(keyFormat));
        originals.put("VALUE_FORMAT", (Literal)new StringLiteral(valueFormat));
        return new CreateSourceProperties(originals, this.durationParser);
    }

    public Map<String, Literal> copyOfOriginalLiterals() {
        return this.props.copyOfOriginalLiterals();
    }

    public String toString() {
        return this.props.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateSourceProperties that = (CreateSourceProperties)o;
        return Objects.equals((Object)this.props, (Object)that.props);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.props});
    }

    private void validateWindowInfo() {
        boolean requiresSize;
        Optional<WindowType> windowType = this.getWindowType();
        Optional<Duration> windowSize = this.getWindowSize();
        boolean bl = requiresSize = windowType.isPresent() && windowType.get() != WindowType.SESSION;
        if (requiresSize && !windowSize.isPresent()) {
            throw new KsqlException(windowType.get() + " windows require '" + "WINDOW_SIZE" + "' to be provided in the WITH clause. For example: '" + "WINDOW_SIZE" + "'='10 SECONDS'");
        }
        if (!requiresSize && windowSize.isPresent()) {
            throw new KsqlException("'WINDOW_SIZE' should not be set for SESSION windows.");
        }
    }

    private Optional<String> getFormatName() {
        return Optional.ofNullable(this.props.getString("FORMAT"));
    }
}

