/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import io.confluent.ksql.parser.CaseInsensitiveStream;
import io.confluent.ksql.parser.SqlBaseLexer;
import io.confluent.ksql.parser.SqlBaseParser;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public final class IdentifierUtil {
    private IdentifierUtil() {
    }

    public static boolean isValid(String identifier) {
        SqlBaseLexer sqlBaseLexer = new SqlBaseLexer(new CaseInsensitiveStream((CharStream)CharStreams.fromString((String)identifier)));
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)sqlBaseLexer);
        SqlBaseParser sqlBaseParser = new SqlBaseParser((TokenStream)tokenStream);
        sqlBaseLexer.removeErrorListeners();
        sqlBaseParser.removeErrorListeners();
        sqlBaseParser.identifier();
        return sqlBaseParser.getNumberOfSyntaxErrors() == 0 && sqlBaseParser.getCurrentToken().getCharPositionInLine() == identifier.length();
    }

    public static boolean needsQuotes(String identifier) {
        return !IdentifierUtil.isValid(identifier) || !IdentifierUtil.upperCase(identifier);
    }

    private static boolean upperCase(String identifier) {
        return identifier.toUpperCase().equals(identifier);
    }
}

